;
; ANGLE PROJECT 2 - By Rob Hutchinson.
;					rob@satanicdreams.com
;
; Written with Blitz Basic BETA V0.42.
;
; Just a little demonstration of how to get the angle and degrees
; of a line between 2 points.
; Also demonstrates the use of drawing to images.
;
; Click the mouse twice in two different places to draw a line.
; Escape to exit.
;

SeedRnd MilliSecs()
Const width=800,height=600			; Setup the screen
Global hwidth=width/2				; Calculate halfs.
Global hheight=height/2				;
Graphics width,height				;
mainimg=CreateImage(width,height) : HandleImage mainimg,0,0		; Image for background.
pointer=CreateImage(9,9)			; pointer image
SetBuffer ImageBuffer(pointer)		; Get ready to draw on our pointer blank image.
Cls									; Clear the image, cos it will be filled with junk from memory.
Color 255,255,255					; Set colour to white.
Line 0,4,9,4						; 
Line 4,0,4,9						;
Color 0,0,0							; Create the pointer.
Plot 4,4							;

;
; Function returns the angle between two sets of coordinates.
; Returned value is between 0 and 1.
;
Function Angle#(x1#,y1#,x2#,y2#)
	angle#=ATan2(x2-x1,y2-y1)
	Return (180-angle#)/360
End Function
;
; Function returns the degrees between two sets of coordinates.
; Returned value is between 0 and 360.
;
Function Degrees#(x1#,y1#,x2#,y2#)
	angle#=ATan2(x2-x1,y2-y1)
	Return 180-angle#
End Function
;
; Function returns the gradient between two sets of coordinates.
;
Function Gradient#(X1#,Y1#,X2#,Y2#)
	angle#=(X1-X2)/(Y1-Y2)
	Return angle#
End Function


SetBuffer ImageBuffer(mainimg)		; clear our main buffer
Cls									; so that its blank, ready for use.

mxa=-1								; some variables, when at -1
mxb=-1								; they are not currently set.

Repeat
	Cls
	SetBuffer ImageBuffer(mainimg)	; switch to the background image.
	Color Rnd(255),Rnd(255),Rnd(255); set color to random.
	Text 0,0,"Click twice on the screen to select points."	; keep drawing this.
	Text 0,12,"Right mouse to clear screen."				; keep drawing this.
	
	MsX=MouseX()					; get the positions of the mouse
	MsY=MouseY()					; 
	If MouseHit(1)					; When the lmb is down.
		If mxa=-1					; And there are no clicks in this session.
			mxa=MsX					; set first point to mouse position.
			mya=MsY					; 
		Else						; else..
			If mxb=-1				; when the first has been placed but second hasn`t.
				mxb=MsX				; set second point to new mouse position.
				myb=MsY				; 
				Color 255,255,0 				; lellow :)
				Line mxa,mya,mxb,myb			; draw a permanent line to the buffer from point to point.
				DrawImage pointer,mxa,mya		; draw pointer images at both ends of the line
				DrawImage pointer,mxb,myb		; lines to show start and end.
				degs#=Degrees#(mxa,mya,mxb,myb)	; get the degrees.
				Color 0,255,255					; set color
				Text mxb,myb,degs#+" degrees"	; draw the degrees text.
												;
				angl#=Angle#(mxa,mya,mxb,myb)	; get the angle. 
				Color 255,0,255					; set color.
				Texting$=angl#+" angle"			; create text
				Text mxa-StringWidth(Texting$),mya-StringHeight(Texting$),Texting$ ; draw angle as offset from other side.

				mxa=-1 : mxb=-1		; reset check values.
			EndIf
		EndIf
	EndIf

	If MouseHit(2)					; when rmb is pressed.
		Cls							; clear the screen.
	EndIf		
	;
	; Draw "TEMP" from this point on...
	;
	SetBuffer BackBuffer()						; set to draw back to our screen.
	DrawImage mainimg,0,0						; draw the buffer we are working on back to screen.
	If mxa<>-1									; when we have one click, but not 0 or 2.
		Color Rnd(255),Rnd(255),Rnd(255)		; random color
		Line mxa,mya,MsX,MsY					; draw line in this random color
		degs#=Degrees#(mxa,mya,MsX,MsY)			; get dynamic degrees.
		Color 0,255,255							; color set.
		Text MsX,MsY,degs#+" degrees"			; draw dynamic degrees.
		angl#=Angle#(mxa,mya,MsX,MsY)			; get dynamic angle.
		Color 255,0,255							; color set.
		Texting$=angl#+" angle"					; create text,
		Text mxa-StringWidth(Texting$),mya-StringHeight(Texting$),Texting$ ; draw dynamic angle.
	EndIf
	DrawImage pointer,MsX,MsY					; FINALLY, draw the pointer so it`s dominant.
	Flip										; and flip buffers.
Until KeyDown(1)								; wait until escape pressed.
End												; terminate program.