;
; BALLS PC - ReWritten by Rob Hutchinson - 21.07.2000:0910
;
; Written with Blitz Basic Beta V0.42
;
; Sure, you remember this? :) I don't know who wrote the original though.
; I think it could draw around 30-40 on an Amiga running at 40Mhz in AmiBlitz.
; Contact me: rob@satanicdreams.com or visit our website: www.satanicdreams.com
;
; Switch debugging off for fastest speeds.
; You will have to increase MaxBalls to well over 3000 on a PII-350 to lose frames.
; 

AppTitle "Bouncing Balls PC"
Const width=800,height=600,depth=16
Graphics width,height,depth
SetBuffer BackBuffer()

Type ball
	Field x#,y#,xs#,ys#
End Type

Const MaxBalls=500							; Change this for different number of balls.
Global BallImage=LoadImage("Ball.bmp")		; Load in the ball image from disk.
Global b.ball

For a=0 To MaxBalls							; Keep adding items to our list until it is full.
	b.ball=New ball
	b\x=Rnd(15,width-20)
	b\y=Rnd(15,height-20)
	b\xs=(Rnd(1)-.5)*8
	b\ys=(Rnd(1)-.5)*8
Next

;
; Main loop.
;
While Not KeyDown(1)						; Do until ESC is pressed
	UpdateBalls()
	Cls
	RenderBalls()
	Flip
Wend

End											; Terminate program here.

;
; Functions.
;
Function UpdateBalls()						; This function updates the positions of the balls.
	For b.ball=Each ball
		b\x=b\x+b\xs : b\y=b\y+b\ys			; Update each balls' position.
		;
		; Reverse direction if ball gets to the edge of the bitmap.
		;
		If b\x<15 Or b\x>(width-20) Then b\xs=-b\xs
		If b\y<15 Or b\y>(height-20) Then b\ys=-b\ys
	Next
End Function

Function RenderBalls()						; This function renders the stars to the screen.
	For b.ball=Each ball
		DrawImage BallImage,b\x,b\y
	Next
End Function

