;
; CREATE BITMAP FONT - Written By Rob Hutchinson 16.08.2000
; (C)opyright Rob Hutchinson - rob@satanicdreams.com
; www.satanicdreams.com
;
; Written in Blitz Basic BETA V0.42
;
; Takes a set number of bitmaps and joins them all into one long
; bitmap image and saves it out. To be used as an "anim image"
; font.
;
; See the file: "NeededFiles.dat" in the same directory as this
; source code. This holds the names of the files to be loaded
; in to create the font file.
;

Const width=1024,height=768,depth=32	; Change this depth if you like.
Graphics width,height,depth				; May crash otherwise.

Text 0,0,"Working! Please wait..."

Type fontdata
	Field fileaccess$
End Type

imageswidth=100						; The dimensions of each image.
imagesheight=100					;
datfile=ReadFile("NeededFiles.dat") ; The file containing the names of
									; each character in order.
saveitto$="BananaFont.bmp"			; The file name to save the final image to.

totalfiles=0
If datfile<>False
	While Not Eof(datfile)
		f.fontdata=New fontdata
		f\fileaccess=ReadLine(datfile)
		totalfiles=totalfiles+1
	Wend
EndIf
CloseFile datfile

; --====--

imw=(width/imageswidth)
imw=imw*imageswidth
imh=(height/imagesheight)
imh=imh*imagesheight
bitmapfont=CreateImage(imw,imh) : HandleImage bitmapfont,0,0
SetBuffer ImageBuffer(bitmapfont)
Cls

positionx=0
positiony=0
For f.fontdata=Each fontdata
	tempimage=LoadImage(f\fileaccess+".bmp") : HandleImage tempimage,0,0
	DrawImage tempimage,positionx,positiony
	positionx=positionx+imageswidth
	If positionx+imageswidth>width
		positionx=0
		positiony=positiony+imagesheight
	EndIf
	FreeImage tempimage
Next

SetBuffer BackBuffer()
Repeat
	Cls
	DrawImage bitmapfont,0,0
	Flip
Until KeyDown(1)	

SaveImage bitmapfont,saveitto$
End