; ***********************************************************************
; bebegooey V001004. )pJAy(                 Icq# 64115056 (maya)
; ***********************************************************************
;
; **********************************************************************************************************************
; Instructions:
; **********************************************************************************************************************
; window(win#,title$, x , y , w , h , wincol , titlebarcolour , moveable? , closeable? , hideoncreate?)
; button (win#, but# , x , y , width , height , label$ , type , justify , value , minvalue , maxvalue , colour)
; ---------------------------------------------------------------------------------------------------------------------------------------------
; Colours are defined by the Setcolset function (bottom of code) - Current range is from 0 (transparent) to 14
; ---------------------------------------------------------------------------------------------------------------------------------------------
; Type of button:
; 0 - plain box, no clicking  1 - standard click/release  2 - standard toggle on/off  3 - Grouped  4 - TextInput  5 - NumberInput 
; 6 - Horizontal scroller  7 - Vertical Scrollbar8 - Show window  9 - Hide window  10 - MultiText (clickchange)
; ---------------------------------------------------------------------------------------------------------------------------------------------
; Grouping T3 : minvalue is 1st button - maxvalue is last button
; Text input T4 : Label is default text  - maxvalue is maximum length in chararcters
; Numeric Input T5 : Value is default - minvalue & maxvalue control limits
; ShowWindow T6 : minvalue=window from - maxvalue=window to 
; HideWindow T7 : minvalue=window from - maxvalue=window to 
; Horizontal Scrollbar T8 : as defined 
; Vertical Scrollbar T9 : as defined 
; MultiText T10 : Label=Text - All text to be flipped through should begin and end with  '' - e.g: "anexampleofMultiText" -
;	- minvalue=Default  start - maxvalue=amount of words-1 (would be 3 If using example above)
; ---------------------------------------------------------------------------------------------------------------------------------------------
; Justification of Label & display of value :
; Label : 1- Left 2-Centered 3-Right 4-OutLeft 5-Outright 6-Above 7-Below 8-BasCentered  
; Display of Button value : add another figure to the first.  e.g.:  
; 	Justification of '2' will give just the label centrered in the button
; 	Justification of '25' will give the label centered + display the value on the right hand side 
; ---------------------------------------------------------------------------------------------------------------------------------------------
; * Tips :
;; Please use only positive values for window/button widths/heights definitions.
; Setting a buttons' x value to -1 centers it in its window.
; Plan any 'decorative' nonclick buttons beforehand as they need to be drawn before other buttons
; There is no current implementation for negative or non-integer values
; Do your own colorset definitions!
; You can make text only buttons (no surround box) by setting the button colour to 0
; Optimally change the variables: maxbut, maxwin, maxwinsizex, maxwinsizey to suit your interface -
;            - if the maximum width of your windows if 200pixels then set maxwinsizex to 200 etc,.
; Buy Radioheads' Kid A.
; Labels are not drawn for scrollbars, but you can do your own.
; Hold right mouse button when clicking scrollbars to inc/decrement
; **********************************************************************************************************************



; These are system variables - remember not to duplicate in your own programs.
Const maxbut=20,maxwin=5,maxwinsizex=256,maxwinsizey=256
Dim col(3,2), windef(maxwin+2,10),wint$(maxwin+2),butdef(maxwin+2,maxbut+2,16),winon(maxwin+2)
Dim butt$(maxwin+2,maxbut+2),buttonon(maxwin+2,maxbut+2),draworder(maxwin+2)
Global width=800,height=600	; Graphics resolution
Graphics width,height               	; Start graphics
Global mouse=LoadImage("mousepointer.bmp"), winimage=CreateImage(maxwinsizex+1,maxwinsizey+1,maxwin+2),chk
Global mx,my,lastselbut,lastselwin,butdown,windown,winhit,buthit,selbuttype,movewindow,winx,winy,windowedit,buttonedit,edittxt$,buttontxt$
Global fnt = LoadFont("Arial bold",15),dbfnt = LoadFont("arial",14) ; system & debug font

SetFont fnt
SetBuffer BackBuffer()
; ** Demonstration globals & variable settings **
Global bg=LoadAnimImage("tiles.bmp",32,32,0,4)
Global scrollspeedx , scrollspeedy , tile


; 
; ********************************************************************************
; *** Window definitions
; ********************************************************************************
; Input Window
window(3,"Alphanumeric & Numeric Input",150,350,254,130,3,6,1,1,0)
button(3,1,2,18,124,110,"",0,2,0,0,0,4)
button(3,2,4,20,120,18,"Alphanumeric Input",0,2,0,0,0,4)
button(3,3,4,40,120,18,"Max Length 28",0,8,0,0,0,0)
button(3,4,16,57,98,18,"BebeGoey",4,2,0,0,28,5)
button(3,5,4,80,120,18,"Max Length 8",0,8,0,0,0,0)
button(3,6,16,97,98,18,"Oh My!",4,2,0,0,8,5)
button(3,7,128,18,124,110,"",0,2,0,0,0,4)
button(3,8,130,20,120,18,"Numeric Only Input",0,2,0,0,0,4)
button(3,9,142,57,98,18,"100",5,2,100,0,1000,5)
button(3,10,130,40,120,18,"Max Value 1000",0,8,0,0,0,0)
button(3,11,142,97,98,18,"",5,2,50,50,80,5)
button(3,12,130,80,120,18,"Between 50 & 80",0,8,0,0,0,0)
;
;* Button Example Window
window(4,"Click 'n' Drag Me!",32,32,256,256,3,6,1,1,0)
button(4,1,2,18,124,90,"",0,2,0,0,0,4)
button(4,2,4,20,120,18,"Button Types",0,2,0,0,0,4)
button(4,3,16,42,98,18,"Clickable",1,2,0,0,0,5)
button(4,4,16,64,98,18,"Toggleable",2,2,0,0,0,5)
button(4,5,16,86,98,18,"NonClickable",0,2,0,0,0,5)
button(4,6,130,18,124,90,"",0,2,0,0,0,2)
button(4,7,132,20,120,18,"Text Justification",0,2,0,0,0,2)
button(4,8,144,42,98,18,"Left",1,1,0,0,0,3)
button(4,9,144,64,98,18,"Centre",1,2,0,0,0,3)
button(4,10,144,86,98,18,"Right",1,3,0,0,0,3)
button(4,11,2,112,252,92,"",0,2,0,0,0,5)
button(4,12,4,114,248,18,"TextLabel Positioning",0,2,0,0,0,7)
button(4,13,4,148,98,18,"Above",1,6,0,0,0,7)
button(4,14,145,148,98,18,"Left",1,4,0,0,0,7)
button(4,15,120,168,98,18,"Right",1,5,0,0,0,7)
button(4,16,4,168,98,18,"Below",1,7,0,0,0,7)
button(4,17,2,206,252,48,"",0,2,0,0,0,6)
button(4,18,4,208,248,18,"MultiClick Buttons",0,2,0,0,7,4)
button(4,19,6,230,244,18,"MODE: FreehandMODE: LineMODE: CircleMODE: Box",10,2,0,0,3,8)
; ** Scrollbackground  Control Window
window(2,"Grouped Buttons",580,10,136,86,2,3,1,0,1)
button(2,4,56,22,18,18,"0",3,2,1,4,7,4)
button(2,5,76,22,18,18,"1",3,2,0,4,7,4)
button(2,6,96,22,18,18,"2",3,2,0,4,7,4)
button(2,7,116,22,18,18,"3",3,2,0,4,7,4)
button(2,8,2,22,50,18,"SpeedX",0,8,0,0,0,0)
button(2,9,56,44,18,18,"0",3,2,1,9,12,5)
button(2,10,76,44,18,18,"1",3,2,0,9,12,5)
button(2,11,96,44,18,18,"2",3,2,0,9,12,5)
button(2,12,116,44,18,18,"3",3,2,0,9,12,5)
button(2,13,2,44,50,18,"SpeedY",0,8,0,0,0,0)
button(2,14,56,66,18,18,"0",3,2,1,14,17,6)
button(2,15,76,66,18,18,"1",3,2,0,14,17,6)
button(2,16,96,66,18,18,"2",3,2,0,14,17,6)
button(2,17,116,66,18,18,"3",3,2,0,14,17,6)
button(2,18,2,90,136,18,"",2,2,0,0,0,0)
button(2,19,2,66,50,18,"Tile",0,8,0,0,0,0)
; ShowWindow & HideWindow examples
window(1,"Control Panel",330,12,140,150,5,13,1,0,0)
button(1,1,2,20,136,78,"",0,2,0,0,0,2)
button(1,2,4,22,132,18,"Show ScrollPanel",8,2,0,2,2,4)
button(1,3,4,42,132,18,"Close ScrollPanel",9,2,0,2,2,4)
button(1,4,4,75,132,18,"ShowDebugInfo?",2,2,0,2,2,4)
button(1,5,-1,120,116,26,"",0,2,1,0,0,6)
button(1,6,-1,125,57,18,"Quit",1,2,0,2,2,6)
;
window(5,"Showvalue & Scrollbars",480,220,150,176,5,3,1,0,0)
button(5,1,2,20,85,42,"",0,2,0,0,0,2)
button(5,2,4,22,72,18,"Value=",2,25,0,0,0,4)
button(5,3,4,42,72,18,"AreYouClickingYet?",10,25,0,0,3,4)
button(5,4,2,150,124,18,"Horiz",6,25,20,10,100,4)
button(5,5,94,20,38,100,"Vert",7,25,20,1,50,4)
button(5,6,2,75,94,18,"A Phat vertical",0,8,0,0,0,0)
button(5,7,2,90,94,18,"scrollbar...",0,8,0,0,0,0)
button(5,8,2,130,146,18,"..& a slim horizontal one",0,8,0,0,0,0)


drawwindow(0) ; MUST call this to draw all needed windows before your program!
; *********************************************************************************************
; ** End window definitions
; *********************************************************************************************

; ** Main Loop **
Repeat
	x=x-scrollspeedx 
	y=y-scrollspeedy  
	TileBlock bg,x,y,tile ; draw background
	winhandle() ; Window routines - returns lastselwin & lastselbut variables for your programs to work on
	drawgoey() ; Draws your windows
	If lastselwin=1 And lastselbut=6 Then End ; clicked on 'quit' button?
	If lastselwin=2 ; window 2 selected?
		If lastselbut=4 Then scrollspeedx=0 ; button 4 clicked? 
		If lastselbut=5 Then scrollspeedx=1 ; button 5 clicked?... etc.,
		If lastselbut=6 Then scrollspeedx=2 
		If lastselbut=7 Then scrollspeedx=3 
		If lastselbut=9 Then scrollspeedy=0 
		If lastselbut=10 Then scrollspeedy=1 
		If lastselbut=11Then scrollspeedy=2 
		If lastselbut=12 Then scrollspeedy=3 
		If lastselbut=14 Then tile=0 
		If lastselbut=15 Then tile=1
		If lastselbut=16 Then tile=2
		If lastselbut=17 Then tile=3
	EndIf
	If butdef(1,4,7)=1 Then debugtxt() ; if degub toggle button is on then display debug info

	DrawImage mouse,mx,my ; draw mouse pointer
	Flip
Forever

End

; ******************************************************************************************************************************************************
Function winhandle()
	mx=MouseX() : my=MouseY() : lmb=MouseDown(1) : rmb=MouseDown(2)
	If windowedit=0 And buttonedit=0 Then GetKey() ; when not editing - clear key buffer
	winhit=0 : buthit=0
	If movewindow=0
		For dwin=1 To maxwin
			winhit=0
			win=draworder(dwin)
			If winon(win)>0
				wx=windef(win,0) : wy=windef(win,1)
				If RectsOverlap(mx,my,1,1,wx,wy,windef(win,2),windef(win,3))
					winhit=win
					For but=1 To maxbut+2
						If buttonon(win,but)=1
							x=butdef(win,but,0):y=butdef(win,but,1):w=butdef(win,but,2):h=butdef(win,but,3)
							If  RectsOverlap(mx,my,1,1,x+wx,y+wy,w+1,h+1) Then buthit=but : 
						EndIf
					Next
					Goto escbc
				EndIf
			EndIf
		Next
	EndIf
	.escbc
	If lmb=1 ; mouse clicked?
		If butdown=maxbut+1 And movewindow=0 And windef(windown,6)=1 Then winx=mx-windef(windown,0) : winy=my-windef(windown,1) : movewindow=windown
		If movewindow>0 Then windef(windown,0)=mx-winx : windef(windown,1)=my-winy
		If winhit>0 And windown=0 Then chgdraworder(winhit)
		If buthit>0 And winhit>0 ; mouse over buttons?
			If windown=0 And butdown=0 ; first time mouseclick over button?
				If (windowedit>0 And windowedit<>windown) And (buttonedit>0 And butdown<>buttonedit)
					drw=windowedit
					windowedit=0 : buttonedit=0
					butchg=1
				EndIf
				windown=winhit : butdown=buthit : GetKey()
				selbuttype=butdef(windown,butdown,4)
				If selbuttype=1 Or selbuttype>7 Then butdef(windown,butdown,7)=1 : butchg=1
				If selbuttype=2 Then butdef(windown,butdown,7)=1-butdef(windown,butdown,7) : butchg=1
				If selbuttype=3
					grpfr=butdef(windown,butdown,8) : grpto=butdef(windown,butdown,9)
					For grp=grpfr To grpto
						butdef(windown,grp,7)=0
					Next
					butdef(windown,butdown,7)=1 : butchg=1
				EndIf
				If selbuttype=4 Then windowedit=windown : buttonedit=butdown : edittxt$=butt$(windown,butdown) : butchg=1
				If selbuttype=5 Then windowedit=windown : buttonedit=butdown : edittxt$=Str$(butdef(windown,butdown,7)) : butchg=1
			EndIf
			If butdown>0 And windown>0 ; mouseclicked over button?
				If (buthit<>butdown Or winhit<>windown) ; mouse not over clicked button?
					chk=1
					If (selbuttype=1 Or selbuttype>7) And butdef(windown,butdown,7)=1 Then butdef(windown,butdown,7)=0 : butchg=1
				EndIf
				If buthit=butdown And winhit=windown ; mouse over clicked button?
					If selbuttype=6 Then cval=butdef(windown,butdown,7): hscrollbarhandle(windown,butdown,mx,rmb) :If cval<>butdef(windown,butdown,7) Then butchg=1
					If selbuttype=7 Then cval=butdef(windown,butdown,7): vscrollbarhandle(windown,butdown,my,rmb) :If cval<>butdef(windown,butdown,7) Then  butchg=1
					If (selbuttype=1 Or selbuttype>7) And butdef(windown,butdown,7)=0 Then butdef(windown,butdown,7)=1 : butchg=1
				EndIf
			EndIf			
		EndIf 
	EndIf
	If lmb=0 ; mouse not (or 'un') clicked
		If movewindow>0 Then butdef(movewindow,maxbut+1,7)=0 : butchg=1: movewindow=0
		If windowedit>0 And buttonedit>0
			If butdef(windowedit,buttonedit,4)=4
				butchg=editbuttontxt(windowedit,buttonedit)
				If Asc(Right$(butt$(windowedit,buttonedit),1))=13
				butt$(windowedit,buttonedit)=Left$(butt$(windowedit,buttonedit),Len(butt$(windowedit,buttonedit))-1)
				windowedit=0 : buttonedit=0
				EndIf
			EndIf
			If butdef(windowedit,buttonedit,4)=5
				butchg=editbuttonnum(windowedit,buttonedit)
				If Asc(Right$(butt$(windowedit,buttonedit),1))=13
					butt$(windowedit,buttonedit)=Left$(butt$(windowedit,buttonedit),Len(butt$(windowedit,buttonedit))-1)
					If butdef(windowedit,buttonedit,4)=5
						butdef(windowedit,buttonedit,7)=butt$(windowedit,buttonedit)
						If butdef(windowedit,buttonedit,7)<butdef(windowedit,buttonedit,8) Then butdef(windowedit,buttonedit,7)=butdef(windowedit,buttonedit,8)
						If butdef(windowedit,buttonedit,7)>butdef(windowedit,buttonedit,9) Then butdef(windowedit,buttonedit,7)=butdef(windowedit,buttonedit,9)
						butt$(windowedit,buttonedit)=butdef(windowedit,buttonedit,7)
					EndIf
					windowedit=0 : buttonedit=0
				EndIf
			EndIf
		EndIf
		If butdown>0 And windown>0 ; mouse previously clicked over button?
			If buthit=butdown And winhit=windown 
				If selbuttype=1 Or selbuttype>7 Then butdef(windown,butdown,7)=0 : butchg=1 
				lastselbut=butdown : lastselwin=windown 
				If selbuttype=8
					For win=butdef(windown,butdown,8) To butdef(windown,butdown,9)
						showwindow(win)
					Next
				EndIf
				If selbuttype=9
					For win=butdef(windown,butdown,8) To butdef(windown,butdown,9)
						hidewindow(win)
					Next
				EndIf
				If selbuttype=10
					butdef(windown,butdown,8)=butdef(windown,butdown,8)+1
					If butdef(windown,butdown,8)>butdef(windown,butdown,9) Then butdef(windown,butdown,8)=0
				EndIf
			EndIf
			butdown=0 : windown=0
		EndIf
		If lastselbut=maxbut+2 Then winon(lastselwin)=0
	EndIf
	If butchg=1 Then drawwindow(winhit) : butchg=0
End Function
; ******************************************************************************************************************************************************
Function drawgoey()
	For win=maxwin To 1 Step -1
		cwin=draworder(win)	
		If winon(cwin)=1 Then DrawImage winimage,windef(cwin,0),windef(cwin,1),cwin
	Next
End Function
; ******************************************************************************************************************************************************
Function debugtxt()
	SetFont dbfnt
	Color 255,255,255
	Text 0,0,"Winover="+winhit+" Butover="+buthit+ " Value="+butdef(winhit,buthit,7)
	Text 0,13,"ClickWin="+lastselwin+" Clickbut="+lastselbut+" Value="+butdef(lastselwin,lastselbut,7)
	Text 0,27,"Windown="+windown+" Butdown="+butdown+" Value="+butdef(windown,butdown,7)
	Text 0,41,"Draworder"
	For x=1 To maxwin
		If draworder(x)>0
			Text (cx*15)+60,41,draworder(x)
			cx=cx+1
		EndIf
	Next
	Text 0,55,"EditWindow "+windowedit+" EditButton "+buttonedit+ " Text "+butt$(windowedit,buttonedit)
	SetFont fnt
End Function
; ******************************************************************************************************************************************************
Function tdbox(x,y,w,h,txt$,justify,cl,inv)
	If cl>0
		setcolset(cl)
		Color col(1,0),col(1,1),col(1,2)
		Rect x,y,w,h,1
		If inv=0 Then Color col(2,0),col(2,1),col(2,2)
		If inv=1 Then Color col(3,0),col(3,1),col(3,2)
		Line x,y,x+w,y
		Line x,y,x,y+h
		If inv=0 Then Color col(3,0),col(3,1),col(3,2)
		If inv=1 Then Color col(2,0),col(2,1),col(2,2)
		Line x+w,y,x+w,y+h
		Line x,y+h,x+w+1,y+h
	EndIf
	If cl=0 Then inv=2
	If txt$<>"" Then pjtext(x,y,w,h,txt$,justify,cl,inv)
End Function
; ******************************************************************************************************************************************************
Function showvalue(win,bt,wch)
	txt$=Str$(butdef(win,bt,wch))
	tdbox(butdef(win,bt,0),butdef(win,bt,1),butdef(win,bt,2),butdef(win,bt,3),txt$,butdef(win,bt,10),0,butdef(win,bt,7))
End Function
; ******************************************************************************************************************************************************
Function pjtext(x,y,w,h,txt$,justify,cl,inv)
	sw=StringWidth(txt$)+2
	sh=StringHeight(txt$)
	If sw>w And inv<>2 Then justify=3
	If inv<>2 Then Viewport x+1,y,w-1,h
	If justify>3 And justify<9 Then Viewport 0,0,width,height
	Color col(3,0),col(3,1),col(3,2)
	ah=0
	If inv=1 Then ah=1
	If justify=1 : Text x+2+ah,y+(h/2)+ah,txt$,0,1 : EndIf
	If justify=2 : Text x+(w/2)+ah,y+(h/2)+ah,txt$,1,1 : EndIf
	If justify=3 : Text ah+(x+w)-sw,ah+y+(h/2),txt$,0,1 : EndIf
	If justify=4 : Text x-sw-2,y+(h/2),txt$,0,1 : EndIf
	If justify=5 : Text x+w+2,y+(h/2),txt$,0,1 : EndIf
	If justify=6 : Text x+(w/2),y-(sh/2),txt$,1,1 : EndIf
	If justify=7 : Text x+(w/2),y+h+(sh/2),txt$,1,1 : EndIf
	If justify=8 
		If inv=0 Then Color col(2,0),col(2,1),col(2,2)
		If inv=1 Then Color col(3,0),col(3,1),col(3,2)
		If inv=2 Then Color 10,10,10
		Text x+(w/2)+1,y+(h/2)+1,txt$,1,1
		If inv=0 Then Color col(3,0),col(3,1),col(3,2)
		If inv=1 Then Color col(2,0),col(2,1),col(2,2)
		If inv=2 Then Color 255,255,255
		Text x+(w/2),y+(h/2),txt$,1,1 
	EndIf
	If inv<>2 Then Viewport 0,0,width,height
End Function
; ******************************************************************************************************************************************************
Function button(win,but,x,y,w,h,butstr$,typ,justify,val,min,max,col)
	buttonon(win,but)=1
	butt$(win,but)=butstr$
	If justify<0 Or justify>99 Then justify=2
	If justify>9
		just$=Str$(justify)
		justl$=Left$(just$,1)
		justr$=Right$(just$,1)
		justify=justl$ : jusr=justr$
	End If
	If x=-1 Then x=(windef(win,2)/2)-w/2
	butdef(win,but,0)=x : butdef(win,but,1)=y : butdef(win,but,2)=w : butdef(win,but,3)=h : butdef(win,but,4)=typ
	butdef(win,but,5)=col : butdef(win,but,6)=justify : butdef(win,but,7)=val : butdef(win,but,8)=min : butdef(win,but,9)=max
	butdef(win,but,10)=justr
	If typ=5 Then butt$(win,but)=Str$(val)
End Function
; ******************************************************************************************************************************************************
Function window(win,title$,x,y,w,h,col,tlcol,mov,close,hid)
	If win<1 Or win>maxwin Or winon(win)=1 Then Goto inwinend
	draworder(win)=win
	If hid=0 Then winon(win)=1
	wint$(win)=title$
	windef(win,0)=x : windef(win,1)=y : windef(win,2)=w : windef(win,3)=h
	windef(win,5)=col  : windef(win,6)=mov : windef(win,7)=close
	If title$<>"" Then button(win,maxbut+1,0,0,windef(win,2),18,wint$(win),1,8,0,0,0,tlcol)
	If close=1 Then button(win,maxbut+2,windef(win,2)-16,2,14,14,"X",1,8,0,0,0,tlcol)
	.inwinend
End Function
; ******************************************************************************************************************************************************
Function drawwindow(win)
	If win>maxwin Or win<0 Or windowmove>0 Then Goto drwwinend
	fr=win : tw=win
	If win=0 Then fr=1 : tw=maxwin
	For win=fr To tw
		If winon(win)=1
			SetBuffer ImageBuffer(winimage,win)
			;cls
			tdbox(0,0,windef(win,2),windef(win,3),"",2,windef(win,5),0)
			For bt=1 To maxbut+2
				If buttonon(win,bt)=1 ; is button 'on'
					If butdef(win,bt,4)>-1 And butdef(win,bt,4)<4
						tdbox(butdef(win,bt,0),butdef(win,bt,1),butdef(win,bt,2),butdef(win,bt,3),butt$(win,bt),butdef(win,bt,6),butdef(win,bt,5),butdef(win,bt,7))
						If butdef(win,bt,10)>0 Then showvalue(win,bt,7)
					EndIf
					If butdef(win,bt,4)>7 And butdef(win,bt,4)<10
						tdbox(butdef(win,bt,0),butdef(win,bt,1),butdef(win,bt,2),butdef(win,bt,3),butt$(win,bt),butdef(win,bt,6),butdef(win,bt,5),butdef(win,bt,7))
						If butdef(win,bt,10)>0 Then showvalue(win,bt,7)
					EndIf
					If butdef(win,bt,4)=4 Or butdef(win,bt,4)=5
						If win=windowedit And bt=buttonedit
							tdbox(butdef(win,bt,0),butdef(win,bt,1),butdef(win,bt,2),butdef(win,bt,3),"",butdef(win,bt,6),butdef(win,bt,5),0)
							tdbox(butdef(win,bt,0)+1,butdef(win,bt,1)+1,butdef(win,bt,2)-2,butdef(win,bt,3)-2,butt$(win,bt)+"|",butdef(win,bt,6),butdef(win,bt,5),1)
						Else
							tdbox(butdef(win,bt,0),butdef(win,bt,1),butdef(win,bt,2),butdef(win,bt,3),butt$(win,bt),butdef(win,bt,6),butdef(win,bt,5),0)
							tdbox(butdef(win,bt,0)+1,butdef(win,bt,1)+1,butdef(win,bt,2)-2,butdef(win,bt,3)-2,butt$(win,bt),butdef(win,bt,6),butdef(win,bt,5),1)
						EndIf
					EndIf			
					If butdef(win,bt,4)=10 ; 'multi' toggle button
						num=butdef(win,bt,8)+1
						txt$=butt$(win,bt)
						pos=1
						For wrd=1 To num
							i=Instr(txt$,"",pos)
							If i>0  Then nextpos=Instr(txt$,"",i+1) :length=nextpos-(pos+1):  but$=Mid$(txt$,i+1,length)
							pos=i+length+1
						Next 
						tdbox(butdef(win,bt,0),butdef(win,bt,1),butdef(win,bt,2),butdef(win,bt,3),"",butdef(win,bt,6),butdef(win,bt,5),butdef(win,bt,7))
						tdbox(butdef(win,bt,0)+1,butdef(win,bt,1)+1,butdef(win,bt,2)-2,butdef(win,bt,3)-2,but$,butdef(win,bt,6),butdef(win,bt,5),butdef(win,bt,7))
						If butdef(win,bt,10)>0 Then showvalue(win,bt,8)
					EndIf
					If butdef(win,bt,4)=6 ; Horizontal scrollbar *WIP*
						val=butdef(win,bt,7):min=butdef(win,bt,8) : max=butdef(win,bt,9) : x=butdef(win,bt,0) : y=butdef(win,bt,1) : w=butdef(win,bt,2)
						sections#=(max-min)+1
						secsize#=((w-8.0)/sections#) : maxpos=x+w-(8+secsize#) : minpos=x+4
						tdbox(x,y,w,butdef(win,bt,3),"",butdef(win,bt,6),butdef(win,bt,5),0)
						tdbox(x+2,y+8,w-4,butdef(win,bt,3)-16,"",butdef(win,bt,5),butdef(win,bt,6),1)
						val=val-min
						pos=x+(secsize#*(val-1))+2
						If pos<minpos Then pos=minpos
						If pos>maxpos Then pos=maxpos
						tdbox(pos,y+4,secsize#+4,butdef(win,bt,3)-8,"",butdef(win,bt,6),butdef(win,bt,5),0)
						If butdef(win,bt,10)>0 Then showvalue(win,bt,7)
					EndIf
					If butdef(win,bt,4)=7 ; Vertical scrollbar *WIP*
						val=butdef(win,bt,7):min=butdef(win,bt,8) : max=butdef(win,bt,9) : x=butdef(win,bt,0) : y=butdef(win,bt,1) :h=butdef(win,bt,3)
						sections#=(max-min)+1
						secsize#=((h-8.0)/sections#) : maxpos=y+h-(8+secsize#) : minpos=y+4
						tdbox(x,y,butdef(win,bt,2),h,"",butdef(win,bt,6),butdef(win,bt,5),0)
						tdbox(x+8,y+2,butdef(win,bt,2)-16,h-4,"",butdef(win,bt,5),butdef(win,bt,6),1)
						val=val-min
						pos=y+(secsize#*(val-1))+2
						If pos<minpos Then pos=minpos
						If pos>maxpos Then pos=maxpos
						tdbox(x+4,pos,butdef(win,bt,2)-8,secsize#+4,"",butdef(win,bt,6),butdef(win,bt,5),0)
						If butdef(win,bt,10)>0 Then showvalue(win,bt,7)
					EndIf
				EndIf
			Next
		EndIf
	Next
	SetBuffer BackBuffer()	
	.drwwinend
End Function
; ******************************************************************************************************************************************************
Function chgdraworder(win)
	If win<>draworder(1)
		For w=1 To maxwin
			If draworder(w)=win Then Goto gotit
		Next
		.gotit
		For sw=w To 2 Step -1 : draworder(sw)=draworder(sw-1) :Next
		draworder(1)=win 
	EndIf
End Function
; ******************************************************************************************************************************************************
Function editbuttontxt(window,button)
	txt$=butt$(window,button)
	keydwn=GetKey()
	If KeyHit(71) Then keydwn=55
	If KeyHit(72) Then keydwn=56
	If KeyHit(73) Then keydwn=57
	If KeyHit(75) Then keydwn=52
	If KeyHit(76) Then keydwn=53
	If KeyHit(77) Then keydwn=54
	If KeyHit(79) Then keydwn=49
	If KeyHit(80) Then keydwn=50
	If KeyHit(81) Then keydwn=51
	If KeyHit(82) Then keydwn=48
	If KeyHit(83) Then keydwn=46
	Select keydwn
		Case 8
			If Len(txt$)>butdef(window,button,8) Then txt$=Left$(txt$,Len(txt$)-1)
		Default
			If Len(txt$)<butdef(window,button,9) And (keydwn>31 And keydwn<127) Then txt$=txt$+Chr$(keydwn)
			If keydwn=13 Then txt$=txt$+Chr$(13)
	End Select		
	If butt$(window,button)<>txt$ Then butt$(window,button)=txt$ : Return 1
End Function 
; ******************************************************************************************************************************************************
Function editbuttonnum(window,button)
	txt$=butt$(window,button)
	keydwn=GetKey()
	If KeyHit(71) Then keydwn=55
	If KeyHit(72) Then keydwn=56
	If KeyHit(73) Then keydwn=57
	If KeyHit(75) Then keydwn=52
	If KeyHit(76) Then keydwn=53
	If KeyHit(77) Then keydwn=54
	If KeyHit(79) Then keydwn=49
	If KeyHit(80) Then keydwn=50
	If KeyHit(81) Then keydwn=51
	If KeyHit(82) Then keydwn=48
	If KeyHit(83) Then keydwn=46
	Select keydwn
		Case 8
			If Len(txt$)>0 Then txt$=Left$(txt$,Len(txt$)-1)
		Default
			If Len(txt$)<10 And (keydwn>46 And keydwn<58) Then txt$=txt$+Chr$(keydwn)
			If keydwn=13 Then txt$=txt$+Chr$(13)
	End Select		
	If butt$(window,button)<>txt$ Then butt$(window,button)=txt$ : Return 1
End Function
; ******************************************************************************************************************************************************
Function clearwindow(win)
	winon(win)=0
	For bt=0 To maxbut+2
		buttonon(win,bt)=0
	Next
End Function
; ******************************************************************************************************************************************************
Function hidewindow(win)
	winon(win)=0
	drawwindow(win)
End Function
; ******************************************************************************************************************************************************
Function showwindow(win)
	winon(win)=1
	drawwindow(win)
End Function
; ******************************************************************************************************************************************************
Function hscrollbarhandle(win,bt,mx,rmb)
	If rmb=1 Then lmb=MouseHit(1) : If lmb=0 Then Goto skpith:
	mx=mx-4
	winx=windef(win,0) : butx=butdef(win,bt,0) : cval=butdef(win,bt,7)
	min=butdef(win,bt,8) : max=butdef(win,bt,9) : w#=butdef(win,bt,2)
	posx#=mx-(winx+butx)
	If posx#<0 Then posx#=0
	sections=(max-min)+1
	secsize#=((w#-6.0)/sections)
	val#=Abs(posx#/secsize#)
	If val#<0 Then val#=0
	If val#>sections-1 Then val#=sections-1
	aval=val+min
	If rmb=0
		butdef(win,bt,7)=val#+min
	Else
		If aval<cval Then butdef(win,bt,7)=cval-1
		If aval>cval Then butdef(win,bt,7)=cval+1
	EndIf
	.skpith
End Function
; ******************************************************************************************************************************************************
Function vscrollbarhandle(win,bt,my,rmb)
	If rmb=1 Then lmb=MouseHit(1) : If lmb=0 Then Goto skpitv:
	my=my-4
	winy=windef(win,1)  : buty=butdef(win,bt,1)
	min=butdef(win,bt,8) : max=butdef(win,bt,9) : h#=butdef(win,bt,3) : cval=butdef(win,bt,7)
	posy#=my-(winy+buty)
	If posy#<0 Then posy#=0
	sections=(max-min)+1
	secsize#=((h#-6.0)/sections)
	val#=Abs(posy#/secsize#)
	If val#<0 Then val#=0
	If val#>sections-1 Then val#=sections-1
	aval=val+min
	If rmb=0
		butdef(win,bt,7)=val#+min
	Else
		If aval<cval Then butdef(win,bt,7)=cval-1
		If aval>cval Then butdef(win,bt,7)=cval+1
	EndIf
	.skpitv
End Function
; ******************************************************************************************************************************************************
Function setcolset(cs)
	If cs=0 Then col(1,0)=0:col(1,1)=0:col(1,2)=0:col(2,0)=0:col(2,1)=0:col(2,2)=0:col(3,0)=1:col(3,1)=1:col(3,2)=1
	If cs=1 Then col(1,0)=160:col(1,1)=160:col(1,2)=160:col(2,0)=220:col(2,1)=220:col(2,2)=220:col(3,0)=80:col(3,1)=80:col(3,2)=80
	If cs=2 Then col(1,0)=160 :col(1,1)=100 :col(1,2)=100 :col(2,0)=220 :col(2,1)=180 :col(2,2)=180 :col(3,0)=80 :col(3,1)=30 : col(3,2)=30
	If cs=3 Then col(1,0)=100 :col(1,1)=160 :col(1,2)=100 :col(2,0)=180 :col(2,1)=220 :col(2,2)=180 :col(3,0)=30 :col(3,1)=80 : col(3,2)=30
	If cs=4 Then col(1,0)=100 :col(1,1)=100 :col(1,2)=160 :col(2,0)=180 :col(2,1)=180 :col(2,2)=220 :col(3,0)=30 :col(3,1)=30 : col(3,2)=80
	If cs=5 Then col(1,0)=160 :col(1,1)=160 :col(1,2)=100 :col(2,0)=220 :col(2,1)=220 :col(2,2)=180 :col(3,0)=80 :col(3,1)=80 : col(3,2)=30
	If cs=6 Then col(1,0)=160 :col(1,1)=100 :col(1,2)=160 :col(2,0)=220 :col(2,1)=180 :col(2,2)=220 :col(3,0)=80 :col(3,1)=30 : col(3,2)=80
	If cs=7 Then col(1,0)=100 :col(1,1)=160 :col(1,2)=160 :col(2,0)=180 :col(2,1)=220 :col(2,2)=220 :col(3,0)=30 :col(3,1)=80 : col(3,2)=80
	If cs=8 Then col(1,0)=200 :col(1,1)=128 :col(1,2)=0 :col(2,0)=255 :col(2,1)=180 :col(2,2)=0 :col(3,0)=128 :col(3,1)=64 : col(3,2)=0
	If cs=9 Then col(1,0)=0 :col(1,1)=200 :col(1,2)=128 :col(2,0)=0 :col(2,1)=255 :col(2,2)=180 :col(3,0)=0 :col(3,1)=128 : col(3,2)=64
	If cs=10 Then col(1,0)=128 :col(1,1)=0 :col(1,2)=200 :col(2,0)=180 :col(2,1)=0 :col(2,2)=255 :col(3,0)=64 :col(3,1)=0 : col(3,2)=128
	If cs=11 Then col(1,0)=200 :col(1,1)=0 :col(1,2)=0 :col(2,0)=255 :col(2,1)=80 :col(2,2)=80 :col(3,0)=100 :col(3,1)=30 : col(3,2)=30
	If cs=12 Then col(1,0)=0 :col(1,1)=200 :col(1,2)=0 :col(2,0)=80 :col(2,1)=255 :col(2,2)=80 :col(3,0)=30 :col(3,1)=100 : col(3,2)=30
	If cs=13 Then col(1,0)=0 :col(1,1)=0 :col(1,2)=200 :col(2,0)=80 :col(2,1)=80 :col(2,2)=255 :col(3,0)=30 :col(3,1)=30 : col(3,2)=100
	If cs=14 Then col(1,0)=160 :col(1,1)=160 :col(1,2)=160 :col(2,0)=220 :col(2,1)=220 :col(2,2)=220 :col(3,0)=80 :col(3,1)=80 : col(3,2)=80
End Function
; ******************************************************************************************************************************************************
