;
; Tetris clone...
;
; Copyright (c) 2000, Andr Rieussec
; to contact me : andre.rieussec@free.fr
;
; It took me about a week to program this from scratch, while I was at work !
; I've started commenting all of the code but I didn't finish... If you really
; need some comments on some part of the code though, just let me know.
; I know the code could be cleaned up by adding a few more functions to clear
; the main loop. There are two Goto in the code, many people are against Goto
; but I like Goto so I'll keep using Goto whenever I need it in a program.
; 
; There's a known bug which happens when you move a shape sideways when it's
; about To land on a block. The shape sometimes just stays in the air like it
; didn't move To the side And landed instead. I'm being too lazy right now to
; look And fix it so just call that a feature.
;
; Also, a couple things could be added like a hall of fame, and lines appearing
; on the opponents side when the player removes lines in 2 players games. The
; main menu could also be worked out a little more because it's really quick
; and dirty. The last thing is the difficulty level, I don't think any human
; being can go past level 5...
;
; Anyways, this little game is still pretty enjoyable and I hope you'll have
; fun with it !
;

;
; Controls :
; 
; In the main menu, use the Up and Down arrows and Enter
;
; In the game,
;  player 1:
;  F : rotate
;  C : move left
;  B : move right
;  V : drop
;
;  player 2:
;  Up    : rotate
;  Left  : move left
;  Right : move right
;  Down  : drop
;
;  Esc will return to the main menu
;

; set 640x480 graphics mode
Graphics 640, 480 

; array that'll contain all 7 different Tetris shapes
Dim shapes(7, 4, 2)
; each player's game "board" where the shapes will fall
Dim boards(2, 10, 20)
; each player's shape currently falling
Dim currentshapes(2, 4, 2)
; temporary array that will hold the result of a shape's rotation
Dim temp#(4,2)

; Background image
Global imgBackground = LoadImage("background.bmp")
; Block sprites used to make the shapes
Global imgBlocks = LoadAnimImage("blocks.bmp", 20, 20, 0, 7)
; Game Over image
Global imgGameOver = LoadImage("gameover.bmp")

Global imgMenuBG = LoadImage("menubg.bmp")

Global imgMenuArrows = LoadAnimImage("menuarrows.bmp", 80, 60, 0, 2)

Global fntArial = LoadFont("Arial", 14)

Global moveLeft
Global moveRight
Global moveDown
Global moveRotate


; Filling the shapes array with the datas at the end of the program
Restore shapes
For i = 1 To 7
	Read x1, y1, x2, y2, x3, y3, x4, y4
	shapes(i, 1, 1) = x1
	shapes(i, 1, 2) = y1
	shapes(i, 2, 1) = x2
	shapes(i, 2, 2) = y2
	shapes(i, 3, 1) = x3
	shapes(i, 3, 2) = y3
	shapes(i, 4, 1) = x4
	shapes(i, 4, 2) = y4
Next

; all of the player related information that's not an array goes in this type
Type player
	; coordinates, in blocks, of the falling shape
	Field x, y
	; index in the shapes array of the falling shape and the next one to come
	Field shape, nextshape
	; score, number of lines removed and the difficulty level
	Field score, lines, level
	; screen coordinates of the game board
	Field boardx, boardy
	; this field contains the index of the player's board and currently falling shape
	Field board
	; the current position of the shape between two blocks
	Field position
	; this field contains the player's board background picture number
	Field imgbuff
	; these are the player's controls scancodes
	Field kleft, kright, kdown, krotate
	; the following fields allow for a smooth horizontal motion of the shapes
	Field lrspeed, lrcount
	; this is used to limit how often a shape can be rotated
	Field rtcount
	; next shape coordinates and back picture
	Field nsx, nsy, nsimg
	Field scorex, scorey, linesx, linesy, levelx, levely
	Field inx, iny
End Type

; no need to explain...
.beginning

choice = Menu()

If choice = 3 Then Goto quitgame

; all of the game setup. See below
ResetGame(choice)

; the main loop
While Not KeyDown(1)

	; there are only two players... so far	
	For p.player = Each player

		; the display is limited to the player's board
		Viewport p\boardx, p\boardy, 200, 400
		Origin p\boardx, p\boardy
		
		; drawing the background...
		DrawBlock p\imgbuff, 0, 0
		
		; ...and the blocks that aren't falling
		For i = 1 To 10
			For j = 1 To 20
				If boards(p\board, i, j) > 0 Then DrawBlock imgBlocks, (i - 1) * 20, (j - 1) * 20, boards(p\board, i, j) - 1
			Next
		Next
		
		CheckPossibleMoves(p)

		PlayerInput(p)

		; is it time to have the shape go down 1 block ?
		If p\position <= p\level
		
			; yup! And the moveDown flag tells us if it can keep falling
			If moveDown = 0 Then
				p\y = p\y + 1
			Else
				; if the shape touched an obstacle or the botton of the board, we redraw it at its current position
				DrawShape((p\x - 1) * 20, (p\y - 1) * 20 - (p\position / 2), p\shape, p\board)

				; the following code checks if any of the blocks making the shape is still above the top of the board
				noSpace = 0
				For i = 1 To 4
					If (p\y + currentshapes(p\board, i, 2)) < 1
						noSpace = 1
					EndIf
				Next

				; if that's the case then...
				If noSpace = 1 Then
					; the game's over :(
					GameOver(p\board)
					; let's try again !
					Goto beginning
				EndIf
				
				; since the shape is no longer falling, we put it in the board
				For i = 1 To 4
					boards(p\board, p\x + currentshapes(p\board, i, 1), p\y + currentshapes(p\board, i, 2)) = p\shape
				Next
			
				; and take the next shape...
				p\shape = p\nextshape
				; and find a new next shape...
				p\nextshape = Rnd(1, 8)
				; the currentshapes array is uptated with the new shape to fall
				For i = 1 To 4
					currentshapes(p\board, i, 1) = shapes(p\shape, i, 1)
					currentshapes(p\board, i, 2) = shapes(p\shape, i, 2)
				Next
				; and finally the shape's coordinates are also updated
				p\x = 5
				p\y = -1

				; remove the full lines from the board
				RemoveLines(p)

				p\level = (p\lines / 20) + 1
				If p\level > 10 Then p\level = 10
				
				p\score = p\score + 5

				; this is especially in case the shape was dropped with the "down" key, we don't want the next shape to drop too
				FlushKeys()
			EndIf
			
			; p\position is reset
			p\position = 20
		Else
		
			; if the shape is still between two blocks, its position is updated
			p\position = p\position - p\level
		EndIf

		; and the shape is drawn in the backbuffer		
		DrawShape((p\x - 1) * 20 + p\lrcount, (p\y - 1) * 20 - p\position, p\shape, p\board)

		DisplayNextShape(p)
	; next player
	Next

	; resetting the wievport and origin
	Origin 0, 0
	Viewport 0, 0, 640, 480

	; and finally let's display the changes !
	Flip
	
; looping back
Wend

Goto beginning

.quitgame

; all good things have to end...
End

;********************************************************************************************
Function PlayerInput(p.player)
	; if the player presses the "down" key, the shape will immediately go down 1 block
	If KeyDown(p\kdown) Then 
		p\position = 0
	EndIf
	
	; if p\lrcount = 0 the shape's not moving sideways...
	If Abs(p\lrcount) <= 2
		p\lrcount = 0
	
		; so we can check for keypresses
		If KeyDown(p\kleft) And moveLeft = 0 Then
			; the shape will move by 20 pixels
			p\lrcount = 20
			; in 2 pixels decrements towards the left
			p\lrspeed = -2
			; its game board coordinates already put it at its destination.
			p\x = p\x - 1
		EndIf
		
		; same thing if the "right" key is pressed
		If KeyDown(p\kright) And moveRight = 0 Then
			p\lrcount = -20
			p\lrspeed = 2
			p\x = p\x + 1
		EndIf

		; checking if the "rotate" key is pressed
		If KeyDown(p\krotate) And moveRotate = 0 And p\rtcount <= 0 Then
			; if so, we rotate the shape by 90 degrees. This allow for a very simple optimization !
			i = currentshapes(p\board, 1, 2)
			currentshapes(p\board, 1, 2) = 0 - currentshapes(p\board, 1, 1)
			currentshapes(p\board, 1, 1) = i
		
			i = currentshapes(p\board, 2, 2)
			currentshapes(p\board, 2, 2) = 0 - currentshapes(p\board, 2, 1)
			currentshapes(p\board, 2, 1) = i

			i = currentshapes(p\board, 3, 2)
			currentshapes(p\board, 3, 2) = 0 - currentshapes(p\board, 3, 1)
			currentshapes(p\board, 3, 1) = i

			i = currentshapes(p\board, 4, 2)
			currentshapes(p\board, 4, 2) = 0 - currentshapes(p\board, 4, 1)
			currentshapes(p\board, 4, 1) = i
			
			p\rtcount = 10
		ElseIf p\rtcount > 0 Then
			p\rtcount = p\rtcount - 1
		EndIf

	Else
		; updating p\lrcount to move a shape sideways
		p\lrcount = p\lrcount + p\lrspeed
	EndIf
End Function

;********************************************************************************************
Function CheckPossibleMoves(p.player)
	; these flags will be used to tell what moves are possible
	moveLeft = 0
	moveRight = 0
	moveDown = 0
	moveRotate = 0
	
	; we go through each 4 blocks of the falling shape...
	For i = 1 To 4
		If (p\y + currentshapes(p\board, i, 2)) > 0 Then
			; ...if one of them is against the left edge of the board or has a block on its left
			If ((p\x + currentshapes(p\board, i, 1)) <= 1) Then
				; then we can't move left
				moveLeft = 1
			ElseIf boards(p\board, p\x + currentshapes(p\board, i, 1) - 1, p\y + currentshapes(p\board, i, 2)) > 0 Then
				moveLeft = 1
			EndIf
	
			; ...if one of them is against the right edge of the board or has a block on its right
			If ((p\x + currentshapes(p\board, i, 1)) >= 10) Then
				; then we can't move right
				moveRight = 1
			ElseIf boards(p\board, p\x + currentshapes(p\board, i, 1) + 1, p\y + currentshapes(p\board, i, 2)) > 0 Then
				moveRight = 1
			EndIf
	
			; ...if one of them is at the bottom of the board or is right above a block
			If ((p\y + currentshapes(p\board, i, 2)) >= 20) Then
				; then we can't go down
				moveDown = 1
			ElseIf ((p\y + currentshapes(p\board, i, 2)) >= 1 And boards(p\board, p\x + currentshapes(p\board, i, 1), p\y + currentshapes(p\board, i, 2) + 1) > 0) Then
				moveDown = 1
			EndIf
		EndIf

		; ...if the rotated block is outside the board or over another block
		If (p\x + currentshapes(p\board, i, 2)) < 1 Or (p\x + currentshapes(p\board, i, 2)) > 10 Or (p\y - currentshapes(p\board, i, 1)) > 20 Then
			; then it can't be rotated
			moveRotate = 1
		ElseIf (p\y - currentshapes(p\board, i, 1)) > 0 Then
			If boards(p\board, p\x + currentshapes(p\board, i, 2), p\y - currentshapes(p\board, i, 1)) > 0 Then
				moveRotate = 1
			EndIf
		EndIf

	Next
End Function


;********************************************************************************************
Function DisplayNextShape(p.player)
	xmin = 0
	xmax = 0
	ymin = 0
	ymax = 0
	
	For i = 1 To 4
		If xmin > shapes(p\nextshape, i, 1) Then xmin = shapes(p\nextshape, i, 1)
		If xmax < shapes(p\nextshape, i, 1) Then xmax = shapes(p\nextshape, i, 1)
		If ymin > shapes(p\nextshape, i, 2) Then ymin = shapes(p\nextshape, i, 2)
		If ymax < shapes(p\nextshape, i, 2) Then ymax = shapes(p\nextshape, i, 2)
	Next

	posx = p\nsx + (100 - (Abs(xmax - xmin) * 20 + 20)) / 2 + (0 - xmin) * 20
	posy = p\nsy + (100 - (Abs(ymax - ymin) * 20 + 20)) / 2 + (0 - ymin) * 20

	Origin 0, 0
	Viewport 0, 0, 640, 480

	DrawBlock p\nsimg, p\nsx, p\nsy
			
	DrawBlock imgBlocks, posx + shapes(p\nextshape, 1, 1) * 20, posy + shapes(p\nextshape, 1, 2) * 20, p\nextshape - 1
	DrawBlock imgBlocks, posx + shapes(p\nextshape, 2, 1) * 20, posy + shapes(p\nextshape, 2, 2) * 20, p\nextshape - 1
	DrawBlock imgBlocks, posx + shapes(p\nextshape, 3, 1) * 20, posy + shapes(p\nextshape, 3, 2) * 20, p\nextshape - 1
	DrawBlock imgBlocks, posx + shapes(p\nextshape, 4, 1) * 20, posy + shapes(p\nextshape, 4, 2) * 20, p\nextshape - 1

	SetFont fntArial
	Color 0, 0, 0
	Rect p\inx, p\iny, 53, 46
	Color 0, 255, 0
	Text p\scorex, p\scorey, p\score
	Text p\linesx, p\linesy, p\lines
	Text p\levelx, p\levely, p\level
	
	Origin p\boardx, p\boardy
	Viewport p\boardx, p\boardy, 200, 400
End Function

;********************************************************************************************
Function RemoveLines(p.player)
	nlines = 0

	For i = 1 To 20
		holes = 0

		For j = 1 To 10
			If boards(p\board, j, i) = 0 Then
				holes = holes + 1
			EndIf
		Next

		If holes = 0 Then
			nlines = nlines + 1
			For k = i - 1 To 1 Step -1
				For j = 1 To 10
					boards(p\board, j, k + 1) = boards(p\board, j, k)
				Next
			Next

			For j = 1 To 10
				boards(p\board, j, 1) = 0
			Next
		EndIf
	Next
	
	Select nlines
	Case 1
		p\score = p\score + 100
	Case 2
		p\score = p\score + 200
	Case 3
		p\score = p\score + 400
	Case 4
		p\score = p\score + 1000
	End Select
	
	p\lines = p\lines + nlines
	
End Function

;********************************************************************************************
Function GameOver(board)
	For i = 0 To 9
		For j = 0 To 19
			DrawBlock imgBlocks, i * 20, j * 20, Rnd(0, 6)
		Next
	Next
	
	DrawBlock imgGameOver, 40, 180
	
	Flip

	FlushKeys()	
	WaitKey()
	
End Function

;********************************************************************************************
Function DrawShape(x, y, shapenum, board)
	DrawBlock imgBlocks, x + currentshapes(board, 1, 1) * 20, y + currentshapes(board, 1, 2) * 20, shapenum - 1
	DrawBlock imgBlocks, x + currentshapes(board, 2, 1) * 20, y + currentshapes(board, 2, 2) * 20, shapenum - 1
	DrawBlock imgBlocks, x + currentshapes(board, 3, 1) * 20, y + currentshapes(board, 3, 2) * 20, shapenum - 1
	DrawBlock imgBlocks, x + currentshapes(board, 4, 1) * 20, y + currentshapes(board, 4, 2) * 20, shapenum - 1
End Function

;********************************************************************************************
Function ResetGame(players)

	For p.player = Each player
		FreeImage p\imgbuff
		FreeImage p\nsimg
	Next

	Delete Each player

	SetBuffer BackBuffer()
	DrawBlock imgBackground, 0, 0

	For i = 1 To 2
		For j = 1 To 10
			For k = 1 To 20
				boards(i, j, k) = 0
			Next
		Next
	Next
	; player 1
	p.player = New player
	p\boardx = 40
	p\boardy = 40
	p\x = 5
	p\y = -1
	p\shape = Rnd(1, 8)
	p\nextshape = Rnd(1, 8)
	p\score = 0
	p\lines = 0
	p\level = 1
	p\board = 1
	p\position = 20
	For i = 1 To 4
		currentshapes(p\board, i, 1) = shapes(p\shape, i, 1)
		currentshapes(p\board, i, 2) = shapes(p\shape, i, 2)
	Next
	
	p\kleft = 46
	p\kright = 48
	p\kdown = 47
	p\krotate = 33
	
	p\lrspeed = 5
	p\lrcount = 0
	p\rtcount = 0

	p\nsx = 250
	p\nsy = 118
	
	p\scorex = 300
	p\scorey = 81
	p\linesx = 300
	p\linesy = 96
	p\levelx = 300
	p\levely = 66
	
	p\inx = 295
	p\iny = 65

	p\imgbuff = CreateImage(200, 400)
	GrabImage(p\imgbuff, p\boardx, p\boardy)
	p\nsimg = CreateImage(100, 100)
	GrabImage(p\nsimg, p\nsx, p\nsy)

	If players <> 1 Then
		; player 2
		p.player = New player
		p\boardx = 400
		p\boardy = 40
		p\x = 5
		p\y = -1
		p\shape = Rnd(1, 8)
		p\nextshape = Rnd(1, 8)
		p\score = 0
		p\lines = 0
		p\level = 1
		p\board = 2
		p\position = 20
		For i = 1 To 4
			currentshapes(p\board, i, 1) = shapes(p\shape, i, 1)
			currentshapes(p\board, i, 2) = shapes(p\shape, i, 2)
		Next
	
		p\kleft = 203
		p\kright = 205
		p\kdown = 208
		p\krotate = 200
		
		p\lrspeed = 5
		p\lrcount = 0
		p\rtcount = 0
		
		p\nsx = 290
		p\nsy = 340

		p\scorex = 340
		p\scorey = 303
		p\linesx = 340
		p\linesy = 318
		p\levelx = 340
		p\levely = 288

		p\inx = 336
		p\iny = 287

		p\imgbuff = CreateImage(200, 400)
		GrabImage(p\imgbuff, p\boardx, p\boardy)
		p\nsimg = CreateImage(100, 100)
		GrabImage(p\nsimg, p\nsx, p\nsy)
	Else
		For i = 0 To 9
			For j = 0 To 19
				DrawBlock imgBlocks, 400 + i * 20, 40 + j * 20, Rnd(0, 6)
			Next
		Next
	EndIf

	imgTemp = CreateImage(640, 480)
	GrabImage(imgTemp, 0, 0)
	SetBuffer FrontBuffer()
	VWait
	DrawBlock imgTemp, 0, 0
	SetBuffer BackBuffer()
	FreeImage imgTemp

End Function

;********************************************************************************************
Function Menu()
	SetBuffer FrontBuffer()
	i = 1

	VWait
	DrawBlock imgMenuBG, 0, 0
	DrawImage imgMenuArrows, 150, 110 + 40, 0
	DrawImage imgMenuArrows, 410, 110 + 40, 1

	While Not KeyDown(28)
		j = i
		If KeyDown(208) Then
			If i = 3 Then
				i = 1
			Else
				i = i + 1
			EndIf
		EndIf

		If KeyDown(200) Then
			If i = 1 Then
				i = 3
			Else
				i = i - 1
			EndIf
		EndIf

		If i <> j Then
			j = i
			If j = 3 Then j = 4
			VWait
			DrawBlock imgMenuBG, 0, 0
			DrawImage imgMenuArrows, 150, 110 + j * 40, 0
			DrawImage imgMenuArrows, 410, 110 + j * 40, 1
			Delay 100
			FlushKeys()
		EndIf
	Wend
	
	Return i
End Function


;********************************************************************************************
Function FlushKeys()
	While GetKey():Wend
	For k=1 To 255:KeyHit(k):Next
End Function

.shapes
Data  0, -2,  0, -1,  0,  0,  0,  1	; straight Line
Data  0, -1,  0,  0,  0,  1,  1,  1	; L shape
Data  0, -1,  0,  0,  0,  1, -1,  1	; flipped L shape
Data  0,  0,  1,  0, -1,  1,  0,  1	; S shape
Data -1,  0,  0,  0,  0,  1,  1,  1	; flipped S shape
Data -1,  0,  0,  0,  1,  0,  0,  1	; triangle shape
Data  0,  0,  0,  1,  1,  0,  1,  1 ; square shape