AppTitle "Delta"									

Const Width = 400, Height = 300

Graphics Width, Height
SetFont LoadFont("helvetica", 14, True, True)
SetBuffer BackBuffer()
Const Version$ = "1.0B"
Const ScreenX = 305														; Actual Screen Size X
Const ScreenY = 253														; Actual Screen Size Y
Const ScreenOffsetX = 46
Const ScreenOffsetY = 22

Viewport ScreenOffsetX, ScreenOffsetY, ScreenX, ScreenY 				; Set Visible Screen Size
Origin ScreenOffsetX, ScreenOffsetY 									; Set Origin for X,Y	

; Menu Required
Global GameMenuDisplay
Global GameMenuTimer
Global PanelMenuTimer
Global PanelMenuDisplay
Global CurrentDisplay 

; Player Settings for Game
Global PlayerDisplayTimer												; Timer to Display Seatbelt Message/On Death
Global CurrentPlayer													; Current Player
Global CurrentPlayerActive												; Is current player active?
Global GameOver
Global TempMapPosition													; Temp Enemy Launcher

; GFX Setup
Global gPlayer    = LoadAnimImage("gfx\player.bmp", 24, 24, 0, 7)	; Load the player animation.
Global gEnemy1    = LoadAnimImage("gfx\enemy1.bmp", 24, 24, 0, 6)		; Load the enemy1 animation.    
Global gEnemy2    = LoadAnimImage("gfx\enemy2.bmp", 24, 24, 0, 6)		; Load the enemy2 animation.    
Global gEnemy3    = LoadAnimImage("gfx\enemy3.bmp", 24, 24, 0, 6)		; Load the enemy2 animation.    
Global gExplosion = LoadAnimImage("gfx\explosion.bmp", 24, 24, 0, 7)	; Load the explosion animation.
Global gWeapon    = LoadAnimImage("gfx\weapon.bmp", 24, 18, 0, 22)		; Load the explosion animation.
Global gBullet    = LoadImage("gfx\bullet.bmp")  						; player bullet
Global gStar1     = LoadImage("gfx\stars1.bmp")  						; Star background
Global gStar2     = LoadImage("gfx\stars2.bmp")  						; Star background
Global gTitle     = LoadImage("gfx\title.bmp")							; Delta Title
Global gLargeText = LoadAnimImage("gfx\textmain.bmp", 12, 14, 0, 40)	; Large Text
Global gScoreText = LoadAnimImage("gfx\textscore.bmp", 8, 8, 0, 10)		; Score Text
Global gGameMenu  = LoadAnimImage("gfx\gamemenu.bmp", 24, 21, 0, 6)		; User Settings

;Animation Frames
Global GeneralTimer7#													; General Anim Timer
Global StarFieldTimer#													; Movement of stars.

; Global for Text Characters
Global LargeChar$  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ.@0123456789 _"
Global ScoreChar$ = "0123456789"

Dim GameMenuSettings(3)

; Score Storage
Dim HighScore(5, 1)
Dim HighScoreName$(5)														; High Score Stuff
Dim Score(2)	
Dim Lives(2)												
Global EntryPosition
Global EntryString$
Global EntryCurrent


; Game Types
Type Player
	Field x#, y#, frame#, speed#											; Player Movement
	Field maxbullets, numbullets, hitcounter							; Firing and Hits													 
End Type

Type Bullet
	Field x, y, frame, value 
End Type

Type Enemy
	Field x, y, frame#
	Field wave, enemy%
End Type

Type Explosion
	Field x, y, frame#
End Type

Type WeaponMenu
	Field baseicon, value, maxvalue 
End Type

; ------------------------------------------------------------------
; Player Functions
Function CreatePlayer()
	p.Player = New Player
	ResetPlayer(p)
	For Build = 1 To GameMenuSettings(1) + 1
		Lives(Build) = 1
	Next 
End Function

Function ResetPlayer( p.Player )
	p\x# = 34
	p\y# = 73
	p\frame# = 0
	p\speed# = 1
	p\maxbullets = 1
	p\numbullets = 0
	p\hitcounter = 0
End Function

Function UpdatePlayer( p.Player )
	; Check for collision
	For e.Enemy = Each Enemy
		If ImagesCollide( gPlayer, p\x#, p\y#, 0, e\enemy, e\x, e\y, 0 )
			CurrentPlayerActive = 2
			PlayerDisplayTimer = 0
			Lives(CurrentPlayer) = Lives(CurrentPlayer) - 1
			If Lives(CurrentPlayer) < 1
				CurrentPlayerActive = 3   ;Game Over
			End If
			CreatePlayerExplosion( p )
		End If
	Next	
	; up
	If (GameMenuSettings(2) = 0 And KeyDown(200)) Or (GameMenuSettings(2) = 1 And JoyYDir() < 0)
		p\y# = p\y# - p\speed#
		If p\y# < 32
			p\y# = 32
		EndIf
	EndIf
	; down
	If (GameMenuSettings(2) = 0 And KeyDown(208)) Or (GameMenuSettings(2) = 1 And JoyYDir() > 0)
		p\y# = p\y# + p\speed#
		If p\y# > 202
			p\y# = 202
		EndIf
	EndIf
	; left
	If (GameMenuSettings(2) = 0 And KeyDown(203)) Or (GameMenuSettings(2) = 1 And JoyXDir() < 0)
		p\x# = p\x# - p\speed#
		If p\x# < 0
			p\x# = 0
		EndIf
	EndIf
	; right
	If (GameMenuSettings(2) = 0 And KeyDown(205)) Or (GameMenuSettings(2) = 1 And JoyXDir() > 0)
		p\x# = p\x# + p\speed#
		If p\x# > (ScreenX - 24)
			p\x# = ScreenX - 24
		EndIf
	EndIf
	; fire
	If (GameMenuSettings(2) = 0 And KeyHit(29)) Or (GameMenuSettings(2) = 1 And JoyDown(1))
		If p\numbullets < p\maxbullets
			CreatePlayerBullet(p)
		End If
	EndIf
	; Update Player Anim Frame
	p\frame# = p\frame# + .1
	If p\frame# > 7
		p\frame# = 0
	End If
		
	DrawImage gPlayer, p\x#, p\y#, Floor(p\frame#)
End Function

Function CreatePlayerBullet( p.Player )
	b.Bullet = New Bullet									
	b\x = p\x + 18							
	b\y = p\y + 5
	b\frame = gBullet
	b\value = 25
	p\numbullets = p\numbullets + 1								
End Function

Function UpdatePlayerBullet( p.Player )
	For b.Bullet = Each Bullet
		b\x = b\x + 5
		
		StillActive = 1									
		; Check for collision
		For e.Enemy = Each Enemy
			If ImagesCollide( b\frame, b\x, b\y, 0, e\enemy, e\x, e\y, 0 )
				CreateEnemyExplosion(e)
				p\hitcounter = p\hitcounter - 1
				Score(CurrentPlayer) = Score(CurrentPlayer) + b\value
				StillActive = 0
				Delete e
			End If
		Next							
		; Update counter for weapon selector
		If (p\hitcounter = 0 And StillActive = 0)
			For w.WeaponMenu = Each WeaponMenu
				w\value = w\value + 1
				Exit
			Next
		End If
		; Move/Remove Bullet
		If b\x > ScreenX Or StillActive = 0								
			Delete b
			p\numbullets = p\numbullets - 1
		Else
			DrawImage b\frame, b\x, b\y
		End If
	Next
End Function

Function CreatePlayerExplosion(p.Player)
	f.Explosion = New Explosion									
	f\x = p\x						
	f\y = p\y
	f\frame# = 0
End Function


; ------------------------------------------------------------------
; Explosion - Player and Enemy
Function UpdateExplosion()
	For f.Explosion = Each Explosion
		DrawImage gExplosion, f\x, f\y, Floor(f\frame#)

		f\frame# = f\frame# + .1
		If f\frame# > 7
			Delete f
		End If
	Next 
End Function


; ------------------------------------------------------------------
; Enemy
Function LaunchEnemy(p.Player)
	If TempMapPosition > 300
		CreateEnemy (p)
		CurrentWave = CurrentWave + 1
		TempMapPosition = 0
	End If
End Function

Function CreateEnemy(p.Player)
	p\hitcounter = 0				; Reset Player HitCounter
	
	random = Rnd(2)					; Temp Select Enmey Sprite
	Select random
		Case 0
			sprite% = gEnemy1%
		Case 1
			sprite% = gEnemy2%
		Case 2
			sprite% = gEnemy3%
	End Select
	
	For Build = 0 To 5      
		e.Enemy = New Enemy	
		e\x = Width + (	Build * 32 )						
		e\y = ( Height / 2 ) - 12
		e\frame# = Build
		e\enemy% = sprite%
		p\hitcounter = p\hitcounter + 1
	Next 		
End Function

Function UpdateEnemy()
	For e.Enemy = Each Enemy
		e\x = e\x - 2 
		If(e\x < 100)
			e\y = e\y - 1
		End If
		e\frame# = e\frame#	+ .2
		If e\frame#>6
			e\frame#=0
		End If								
		If(e\x > -24) 
			DrawImage e\enemy%, e\x, e\y, Floor(e\frame#)
		Else
			Delete e
		End If
	Next
End Function

Function CreateEnemyExplosion( e.Enemy )
	f.Explosion = New Explosion									
	f\x = e\x						
	f\y = e\y
	f\frame# = 0
End Function


; ------------------------------------------------------------------
; Weapon Menu
Function CreateWeaponMenu()
	Repeat
		Read icon
		
		If icon = 999 Then Exit
		Read value, maxvalue
		w.WeaponMenu = New WeaponMenu
		
		w\baseicon = icon
		w\value = value 
		w\maxvalue = maxvalue
	Forever 		
End Function

Function ResetWeaponMenu()
	Build = 1
	For w.WeaponMenu = Each WeaponMenu 
		w\value = 0
		If Build = 2 
			w\value = 1
		End If
		Build = Build + 1
	Next
End Function

; ------------------------------------------------------------------
; Starfield Background
Function UpdateBackground()
	TileImage gStar1, 0 - StarFieldTimer#, 0
	TileImage gStar2, 0 - StarFieldTimer# * 2, 0

	StarFieldTimer# = StarFieldTimer# + .5
	If StarFieldTimer# > 200
		StarFieldTimer# = 0
	End If
End Function

; ----------------------------------------------------------------------
; Intro Display Panels

; 0 - TitleScreen
Function Panel0()
	DisplayText ("MCMLXXXVII", 0, 13, 0, 0, 1)
	DrawImage gTitle, 70 ,60
	DisplayText ("BY", 0, 164, 0, 0, 1)
	DisplayText ("STAVROS", 0, 175, 0, 0, 1)
	DisplayText ("FASOULAS", 0, 186, 0, 0, 1)
	DisplayText ("@1987 THALAMUS", 0, 232, 0, 0, 1)
	DisplayText (Version$, ScreenX - Len(Version$) * 12, ScreenY - 10, 0, 0, 0)
End Function

; 1 - High Score
Function Panel1()
	ShowHighScore
End Function

; 2 - Demo
Function Panel2()
	DisplayText("DEMO" , 0, 13, 0, 0, 1)
	DisplayText ("SHOOT ALIENS AND", 0, 124, 0, 0, 1)
	DisplayText ("COLLECT WEAPONRY", 0, 135, 0, 0, 1)	
		
	If PanelMenuDisplay = 1
		DisplayText ("GAME", 0, 192, 0, 0, 1)				
		DisplayText ("OVER", 0, 203, 0, 0, 1)
	End If
	
	DisplayText ("@1987 THALAMUS", 0, 232, 0, 0, 1) 
	; Display Icons
	For Build = 0 To 7
		DrawImage gWeapon,(Build * 40), 160, 14
	Next
	
	PanelMenuTimer = PanelMenuTimer + 1
	If PanelMenuTimer > 50
		PanelMenuTimer = 0
		PanelMenuDisplay = Not PanelMenuDisplay
	End If	
End Function


; ----------------------------------------------------------------------
; General
Function Main()
	ResetMenuRequired
		
	While Not KeyHit(1) 		; Pressing 'Esc' will quit
		UpdateBackground
		
		If StartGame = 0
			;Update Required Menu
			Select CurrentDisplay
				Case 0					; Intro
					Panel0
				Case 1					; High Score
					Panel1
				Case 2					; Demo
					Panel2
			End Select
			
			; Menu Counter to rotate screens
			RotateDisplayTimer = RotateDisplayTimer + 1
			If RotateDisplayTimer > 500 
				CurrentDisplay = CurrentDisplay + 1
				PanelMenuTimer = 0
				PanelMenuDisplay = 1
				If CurrentDisplay > 2
					CurrentDisplay = 0
				End If
				RotateDisplayTimer = 0
			End If
			
			; Display Game Menu
				If KeyHit(59)	; F1
					GameMenuDisplay = 1
					GameMenuSettings(1) = Not GameMenuSettings(1)
					GameMenuTimer = 0
				End If
				If KeyHit(60)	; F2
					GameMenuDisplay = 1
					GameMenuSettings(1) = Not GameMenuSettings(1)
					GameMenuTimer = 0
				End If
				If KeyHit(61)	; F3
					GameMenuDisplay = 1
					GameMenuSettings(2) = Not GameMenuSettings(2)
					GameMenuTimer = 0
				End If
				If KeyHit(62)	; F4
					GameMenuDisplay = 1
					GameMenuSettings(2) = Not GameMenuSettings(2)
					GameMenuTimer = 0
				End If
				If KeyHit(63)	; F5
					GameMenuDisplay = 1
					GameMenuSettings(3) = Not GameMenuSettings(3)
					GameMenuTimer = 0
				End If
				If KeyHit(64)	; F6
					GameMenuDisplay = 1
					GameMenuSettings(3) = Not GameMenuSettings(3)
					GameMenuTimer = 0
				End If
			
			; Display Icons			
			If GameMenuDisplay = 1
				For Build = 1 To 3
					DrawImage gGameMenu, (Build - 1) * 28, 6, GameMenuSettings(Build) + (Build-1)*2
				Next  
				
				; Turn Off?
				GameMenuTimer = GameMenuTimer + 1
				If GameMenuTimer > 500
					GameMenuDisplay = 0
				End If
			End If
			; Start Game
			If KeyHit(29)
				StartGame = 1
			End If
		Else
			StartGame = 0
			InitPlayer
			Game
			ResetMenuRequired
		End If

		; Flip Screen
		Flip													
		Cls
	Wend
End Function

Function Game()
	CreatePlayer
	
	ResetGameRequired
	CurrentPlayer = 1
	GameOver =  0
	
	While Not KeyHit(1) Or GameOver = 1				; Pressing 'Esc' will quit to the menu.
		UpdateBackground
		
		For p.Player = Each Player
			UpdatePlayerBullet(p)		; Display Rest When Required
			If CurrentPlayerActive<4 Then						
				LaunchEnemy(p)
			End If
			UpdateEnemy
			UpdateExplosion
			
			Select CurrentPlayerActive
			; Player Intro Message
			Case 0
				IntroPlayer
			Case 1
				UpdatePlayer(p)
			; Player Died
			Case 2
				KillPlayer
			;Game Over
			Case 3
				GameOver
			;High Score
			Case 4
				EnterHighScore
			End Select
		Next
		; Update All 

		UpdateDisplay()											
		Flip													
		Cls
		TempMapPosition = TempMapPosition + 1
		
		; Update General Timer
		GeneralTimer7# = GeneralTimer7# + .1
		If GeneralTimer7# > 7
			GeneralTimer7# = 0
		End If
	Wend
End Function

Function ResetGameRequired()
	CurrentPlayerActive = 0
	
	PlayerDisplayTimer = 1
	TempMapPosition = 0
	
	InitSprites
	ResetWeaponMenu
	For p.Player = Each Player
		ResetPlayer(p)
	Next
	FlushKeys()
End Function

Function ResetMenuRequired()
	FlushKeys
	
	CurrentDisplay = 0
	RotateDisplayTimer = 0	
	StartGame = 0
	GameMenuDisplay = 0
	GameMenuTimer = 0
	CurrentDisplay = 0
End Function

Function FlushKeys()
	While GetKey()
	Wend
	
	For k = 1 To 255
		KeyHit(k)
	Next
End Function

Function DisplayText(message$, x, y, size, col, centre)
	Addx = 0
	
	; Centre Text?
	If centre = 1
		x = (ScreenX / 2) - ( Len (message$) * 12) / 2
	End If
	
	Select size
		Case 0		; Large Text
			checktext$ = LargeChar$
			Addx = 12
			Img = gLargeText
		Case 1		; Score Text
			checktext$ = ScoreChar$
			Addx = 8
			Img = gScoreText
	End Select
	
	For Build=1 To Len(message$)
		Char = Instr(checktext$, Mid$(message$, Build, 1)) - 1
		If Char >= 0 And Char < 40 
			DrawImage Img, x, y, Char
		End If
		x = x + Addx
	Next
End Function

Function ShowHighScore()
	Addy = 0
	DisplayText ("TOP SCORES", 0, 13, 0, 0, 1)
	
	; Score Scores
	For Build = 1 To 4
		DisplayText ( Str(Build) + "." + Right("000000" + HighScore(Build,1), 6) + " " + HighScoreName$(Build), 49, 70 + Addy, 0, 0, 0)
		Addy = Addy + 43
	Next
	
	DisplayText ("@1987 THALAMUS", 0, 232, 0, 0, 1)
End Function

Function UpdateDisplay()
	If CurrentPlayer = 1 
		DrawImage gPlayer, 73, 0, Floor(GeneralTimer7#)
		DrawImage gPlayer, 282, 0, 0	
	Else
		DrawImage gPlayer, 282, 0, Floor(GeneralTimer7#)	
		DrawImage gPlayer, 73, 0, 0	
	End If

	For Build = 0 To 1
		DisplayText (Str(Build + 1) + " UP",(Build * 209), 2, 0, 0, 0)
		DisplayText (Right("000000" + Score(Build + 1), 6), (Build * 209), 13, 1, 0, 0)
		DisplayText (Lives(Build + 1), 55 + (Build * 209), 6, 0, 0, 0)
	Next
	
	; Update weapon list
	Build = 0
	For w.WeaponMenu = Each WeaponMenu
		If w\value = 0
			DrawImage gWeapon,(Build * 40), 235, 14
		Else
			DrawImage gWeapon,(Build * 40), 235, (w\baseicon + w\value - 1)
		End If
		Build = Build + 1
	Next
End Function

Function IntroPlayer()
	If PlayerDisplayTimer < 200
		DisplayText ("FASTEN", 0, 95, 0, 0, 1)
		DisplayText ("YOUR", 0, 106, 0, 0, 1)
		DisplayText ("SEATBELT", 0, 117, 0, 0, 1)
		DisplayText ("PLAYER " + Str(CurrentPlayer), 0, 128, 0, 0, 1)
		PlayerDisplayTimer = PlayerDisplayTimer + 1
	Else
		PlayerDisplayTimer = 0
		CurrentPlayerActive = 1
	End If
End Function

Function KillPlayer()
	If PlayerDisplayTimer < 200
		; Continue Update until finished
		PlayerDisplayTimer = PlayerDisplayTimer + 1
	Else
		Rotate2Players
		ResetGameRequired
	End If	
End Function

Function GameOver()
	If PlayerDisplayTimer < 200
		DisplayText ("GAME", 0, 106, 0, 0, 1)
		DisplayText ("OVER", 0, 117, 0, 0, 1)
		DisplayText ("PLAYER " + Str(CurrentPlayer), 0, 128, 0, 0, 1)
		;Continue Update Until finished
		PlayerDisplayTimer = PlayerDisplayTimer + 1
	Else
		If Score(CurrentPlayer) > HighScore(4,1)
			UpdateHighScore
		Else
			Rotate2Players
			ResetGameRequired
		End If
	End If	
End Function

Function EnterHighScore()
	If KeyHit(200)
		EntryCurrent = EntryCurrent + 1
		If EntryCurrent > 39
			EntryCurrent = 1
		End If
	End If
	If KeyHit(208)
		EntryCurrent = EntryCurrent - 1
		If EntryCurrent < 1
			EntryCurrent = 39
		End If
	End If
	If KeyHit(29)
		EntryString$ = EntryString$ + Mid(LargeChar$, EntryCurrent, 1)
		EntryCurrent = 39
		If Len(EntryString$) > 8
			HighScoreName$(EntryPosition) = EntryString$
			HighScore(EntryPosition,0) = 0
			Rotate2Players
			ResetGameRequired
		End If
	End If
	DisplayText ( EntryPosition + "." + Right("000000" + HighScore(EntryPosition,1), 6) + " " + EntryString$ + Mid(LargeChar$, EntryCurrent, 1), 49, 70, 0, 0, 0)
	DisplayText ( "_", 155 + Len(EntryString$) * 12, 70, 0, 0, 0)	
End Function

Function UpdateHighScore()
	; Sort List
FlushKeys
	HighScore(0,1) = Score(CurrentPlayer)
	HighScore(0,0) = 1
	For lop=1 To 4
		If HighScore(0,1) > HighScore(lop,1) 
			tempS = HighScore(lop,1):HighScore(lop,1)=HighScore(0,1):HighScore(0,1)=tempS
			tempL = HighScore(lop,0):HighScore(lop,0)=HighScore(0,0):HighScore(0,0)=tempL
			tempN$ = HighScoreName$(lop):HighScoreName$(lop)=HighScoreName$(0):HighScoreName$(0)=tempN$
		End If
	Next
	For Find = 1 To 4
		If HighScore(Find, 0) = 1
			EntryPosition = Find
			HighScore(Find, 0) = 0
		End If
	Next 
	;HighScore(EntryPosition, 0) = 0
	EntryString$ = ""
	EntryCurrent = 39
	PlayerDisplayTimer = 0
	CurrentPlayerActive = 4
End Function

Function Rotate2Players()
	If GameMenuSettings(1) = 1
		CurrentPlayer = CurrentPlayer + 1
		If CurrentPlayer > 2
			CurrentPlayer = 1
		End If
		; Ensure Player with no lives not selected
		If CurrentPlayer = 1 And Lives(1) = 0
			CurrentPlayer = 2
		End If
		If CurrentPlayer = 2 And Lives(2) = 0
			CurrentPlayer = 1
		End If
	End If
	; Game Over
	If Lives(1) = 0 And Lives(2) = 0
		GameOver = 1
	End If
End Function

; ----------------------------------------------------------------------
; Initialise Functions
Function InitialiseAll()
	InitWeaponMenu				; Create Weapon Bar
	InitSprites
	InitPlayer
	InitHighScoreList
	InitGameMenySettings
End Function

Function InitWeaponMenu()
	For w.WeaponMenu = Each WeaponMenu
		Delete w
	Next
	
	Restore .StoredData
	CreateWeaponMenu
End Function

Function InitPlayer()
	; Players
	For p.Player = Each Player
		Delete p
	Next
	For Build = 1 To 2
		Score(Build) = 0
		Lives(Build) = 0
	Next 
End Function

Function InitSprites()
	; Enemy
	For e.Enemy = Each Enemy
		Delete e
	Next
	; Bullets
	For b.Bullet = Each Bullet
		Delete b
	Next
End Function

Function InitHighScoreList()
	For build = 1 To 4
		Read value, name$
		HighScore(build,1) = value
		HighScoreName$(build) = name$
	Next
End Function

Function InitGameMenySettings()
	; 1 - Players: 1/2
	; 2 - Control: Keys/Joystick
	; 3 - Music: Off/On
	For Build = 1 To 3
		GameMenuSettings(Build) = 0
	Next 	
End Function

; ----------------------------------------------------------------------
; Start

InitialiseAll
Main
End


.StoredData
; WeaponData
; Icon, Value, MaxVaue
Data 15,0,7		; Counter
Data  0,1,4		; Speed
Data  4,0,3	 	; Bullet
Data  7,0,1		; Unknown1
Data  8,0,1		; Unknown2
Data  9,0,1		; Unknown3
Data 10,0,1		; Unknown4
Data 11,0,3		; Unknown5
Data 999

; Score List
Data 100,"STAVROS"
Data 50,"ANDREW"
Data 30,"GARY"
Data 10,"THALAMUS"