;
; PLOTTING 3 - Written By Rob Hutchinson 17/08/2000.
; (C)opyright Rob Hutchinson - rob@satanicdreams.com
; www.satanicdreams.com
;
; Written in Blitz Basic BETA V0.42
;
; Yet another boring modification to the sin/cos pixels.
;

Const width=1024,height=768,depth=16				;
Graphics width,height;,depth						; Setup the display.
SetBuffer BackBuffer()								;

Type Pixel											; Type to hold the pixels.
	Field x#,y#										; x,y positions
    Field co#,si#									; offsets.
	Field i#,z#										; movements.
End Type

MaximumPix=10										; maximum number of points.

For i=0 To MaximumPix								; Setup each point.
	p.Pixel=New Pixel								; add a new pixel.
	p\x=(width/2)									;
	p\y=(height/2)
	p\co=Rnd(1.50)
	p\si=Rnd(1.50)
	p\i=Rnd(width)
	p\z=Rnd(height)
Next

Color 255,255,255									; Set color to white.

Repeat												; keep doing this until esc.
	Cls												; Clear screen
	
	For p.Pixel=Each Pixel							; visit each pixel.
		xx=(width/2)+(Cos(p\i)*(width/2))			; Get x
		yy=(height/2)+(Sin(p\z)*(height/2))			; Get y
		Line xx,yy,nxx,nyy							; draw from this point to previous.
		p\i=p\i+p\co								;
		p\z=p\z+p\si								; update......
		If p\i=360 Then p\i=0
		If p\z=360 Then p\z=0
		nxx=xx
		nyy=yy
	Next
	Flip											; double buffer.
Until KeyDown(1)

End