; Just a very simple 'fly around in vast space' demo - adapted from my racer demo
; KrayZ 25.Sep.2000
; entitize@crosswinds.net

AppTitle "DEEP SPACE"

Graphics 800,600

; Double buffer
SetBuffer BackBuffer()

Const rots = 360
Const MaxAcc = 0.3
Const MaxSpeed = 4
Const MaxStars = 600
Const MaxLayers = 3

Dim PlrShipRotFrames(rots)

Type TPlrShip
	Field xp#,yp#
	Field wx#,wy#
	Field xv#,yv#
	Field angle#
	Field speed#
	Field acc#,accstep#
	Field width, height
End Type

Type TPlanet
  Field wx#,wy#
End Type

Type Star
  Field x#,y#,z#
  Field dx#,dy#
End Type



Global st#=360.0/rots

Global PlrShip.TPlrShip=New TPlrShip
PlrShip\xp=GraphicsWidth()/2						; PlrShip's initial X pos
PlrShip\yp=GraphicsHeight()/2						; PlrShip's initial Y pos
PlrShip\wx=200
PlrShip\wy=200
PlrShip\xv=0										; XVelocity of PlrShip (direction travelling)
PlrShip\yv=0										; YVelocity of PlrShip (direction)
PlrShip\angle=180									; Set angle to 180 as the bmp is the wrong way round - which is basically an angle flip
PlrShip\speed=0				
PlrShip\acc=0
PlrShip\accstep=0.02
PlrShip\width=25
PlrShip\height=40

Global plnt.TPlanet=New TPlanet
plnt\wx=400
plnt\wy=400

StarsCreate()


; For handling the PlrShip's rotation at the centre of the PlrShip image
AutoMidHandle True

Global PlrShipimg = LoadImage("media\plrship.bmp")
Global planet = LoadImage("media\planetx.bmp")

PlrShipCreate()


ctr=30

; *****************
; *** MAIN LOOP ***
; *****************
While Not(KeyDown(1))
	Cls
	PlrShipUpdate()
	plnt\wx=plnt\wx+(-PlrShip\xv*PlrShip\speed)
	plnt\wy=plnt\wy+(-PlrShip\yv*PlrShip\speed)
	DrawImage planet, plnt\wx-PlrShip\wx,plnt\wy-PlrShip\wy
	StarsDraw()
	PlrShipDraw()

	DrawStats()	
	Flip
Wend
End

; Mainly for debugging/testing purposes
Function DrawStats()
	Locate GraphicsWidth()/2, 10
	Write "ACC: "+PlrShip\acc
	Locate GraphicsWidth()/2, 25
	Write "ACCSTEP: "+PlrShip\accstep
	Locate GraphicsWidth()/2, 40
	Write "SPEED: "+PlrShip\speed
	Locate GraphicsWidth()/2, 500
	Write "WX: "+PlrShip\wx
	Locate GraphicsWidth()/2, 515
	Write "WY: "+PlrShip\wy
End Function




; *******************
; *** PLAYER SHIP ***
; *******************

; Create the PlrShip rotation frames
; Borrowed from spacies.bb
Function PlrShipCreate()
	an#=0
	For k=0 To rots-1
		PlrShipRotFrames(k)=CopyImage( PlrShipimg )
		RotateImage PlrShipRotFrames(k),an
		an=an+st
	Next
End Function


; Move the PlrShip
Function PlrShipUpdate() 
	PlrShip\angle=PlrShip\angle+(JoyXDir())		
	; Get the velocites of the PlrShip depending on the angle
	PlrShip\xv = Sin(PlrShip\angle)								
	PlrShip\yv = -Cos(PlrShip\angle)
	; Keep the angle within the limits of the array bounds
	If PlrShip\angle<0 Then PlrShip\angle=rots-1
	If PlrShip\angle>rots-1 Then PlrShip\angle=0
	; Accelerate PlrShip
	If JoyYDir()<0 Then 
		PlrShip\acc=PlrShip\acc+PlrShip\accstep
		PlrShip\speed=PlrShip\speed+PlrShip\acc
		If PlrShip\acc>MacAcc Then PlrShip\acc=MaxAcc
		If PlrShip\speed>MaxSpeed Then PlrShip\speed=MaxSpeed
		PlrShip\wx=PlrShip\wx+(PlrShip\xv*PlrShip\speed)
		PlrShip\wy=PlrShip\wy+(PlrShip\yv*PlrShip\speed)
	End If
	; Player not accelerating and speed>0 so slow the PlrShip down
	If (Not JoyYDir()<0) And (PlrShip\speed>0.0) Then
	  	PlrShip\speed=PlrShip\speed-PlrShip\accstep
		If PlrShip\speed<0 Then 
			PlrShip\speed=0.0
			PlrShip\acc=0.0
		End If
		PlrShip\wx=PlrShip\wx+(PlrShip\xv*PlrShip\speed)
		PlrShip\wy=PlrShip\wy+(PlrShip\yv*PlrShip\speed)
	End If
End Function

Function PlrShipDraw()
    ; Draw the PlrShip
	DrawImage PlrShipRotFrames(PlrShip\angle), PlrShip\xp, PlrShip\yp
End Function



; *****************
; *** THE STARS ***
; *****************

Function StarsCreate()
For ctr=1 To MaxStars
 s.Star=New Star
 s\x=Rnd(GraphicsWidth())
 s\y=Rnd(GraphicsHeight())
 s\z=Rnd(MaxLayers)+1
 s\dx=0
 s\dy=0
Next
End Function

Function StarsDraw()
	For s.Star=Each Star
	    s\dx=-(PlrShip\xv*(PlrShip\speed/2))
		s\dy=-(PlrShip\yv*(PlrShip\speed/2))
  		s\x=s\x+(s\dx*s\z)
		s\y=s\y+(s\dy*s\z)
  		If s\x<0 Then 
    		s\x=GraphicsWidth()+1
    		s\y=Rnd(GraphicsHeight())
  		EndIf
		If s\x>GraphicsWidth()+1 Then
			s\x=-1
    		s\y=Rnd(GraphicsHeight())
		End If
		If s\y<0 Then
		 	s\x=Rnd(GraphicsWidth())
			s\y=GraphicsHeight()+1	  
		End If
		If s\y>GraphicsHeight()+1 Then
			s\x=Rnd(GraphicsWidth())
			s\y=-1
		End If
  		Color s\z*(255/(MaxLayers+1)), s\z*(255/(MaxLayers+1)), s\z*(255/(MaxLayers+1))
  		Plot s\x, s\y
 	Next
End Function









