; Just a very simple 'drive a car around the screen' demo
; KrayZ 25.Sep.2000
; entitize@crosswinds.net

AppTitle "RACER"

Graphics 800,600

SetBuffer BackBuffer()

Const rots = 360
Const MaxAcc = 0.3
Const MaxSpeed = 4

Type Tcar
	Field xp#,yp#
	Field xv#,yv#
	Field angle#
	Field speed#
	Field acc#,accstep#
	Field width, height
End Type

Global st#=360.0/rots
Global carimg = LoadImage("media\car.bmp")

Global car.Tcar=New Tcar
car\xp=150										; Car's initial X pos
car\yp=50										; Car's initial Y pos
car\xv=0										; XVelocity of car (direction travelling)
car\yv=0										; YVelocity of car (direction)
car\angle=180									; Set angle to 180 as the bmp is the wrong way round - which is basically a flip
car\speed=0				
car\acc=0
car\accstep=0.02
car\width=25
car\height=40

Dim CarRotFrames(rots)

; For handling the car's rotation at the centre of the car image
AutoMidHandle True


CarCreate()


ctr=30

; *****************
; *** MAIN LOOP ***
; *****************
While Not(KeyDown(1))
	Cls
	CarUpdate()
	CarDraw()
	Locate GraphicsWidth()/2, 10
	Write "ACC: "+car\acc
	Locate GraphicsWidth()/2, 25
	Write "ACCSTEP: "+car\accstep
	Locate GraphicsWidth()/2, 40
	Write "SPEED: "+car\speed
	Flip
Wend
End


; Create the car rotation frames
; Borrowed from spacies.bb
Function CarCreate()
	an#=0
	For k=0 To rots-1
		CarRotFrames(k)=CopyImage( carimg )
		RotateImage CarRotFrames(k),an
		an=an+st
	Next
End Function


; Move the car
Function CarUpdate() 
	car\angle=car\angle+(JoyXDir()*(car\speed/2))		
	; Get the velocites of the car depending on the angle
	car\xv = Sin(car\angle)								
	car\yv = -Cos(car\angle)
	; Keep the angle within the limits of the array bounds
	If car\angle<0 Then car\angle=rots-1
	If car\angle>rots-1 Then car\angle=0
	; Accelerate car
	If JoyYDir()<0 Then 
		car\acc=car\acc+car\accstep
		car\speed=car\speed+car\acc
		If car\acc>MacAcc Then car\acc=MaxAcc
		If car\speed>MaxSpeed Then car\speed=MaxSpeed
		car\xp=car\xp+(car\xv*car\speed)
		car\yp=car\yp+(car\yv*car\speed)
	End If
	; Player not accelerating and speed>0 so slow the car down
	If (Not JoyYDir()<0) And (car\speed>0.0) Then
	  	car\speed=car\speed-car\accstep
		If car\speed<0 Then 
			car\speed=0.0
			car\acc=0.0
		End If
		car\xp=car\xp+(car\xv*car\speed)
		car\yp=car\yp+(car\yv*car\speed)
	End If
End Function

Function CarDraw()
    ; Draw the car
	DrawImage CarRotFrames(car\angle), car\xp, car\yp
End Function