; This source is PD - use or alter in any way you wish
; as long as you put YOUR name on it...

; Initial options routine
; Allows the user to select an available screen mode to run
; your program on, from a list of acceptable sizes/depths you specify

; If none of the modes are available on the user's system,
; the user will be informed and the program will exit

; by Curt Esser
; camge@amigaonline.net
; created and tested on Blitz v1.1 Demo version

; ---------  Initialize  ---------------------------------------

AppTitle "ScreenMode"

; attempt to load our font:

Global BoldFont%=LoadFont("MSserif",20,1,0,0)

If BoldFont
   SetFont BoldFont
EndIf

Type GraphMode      ;a structure for graphics modes
   Field gwide%     ;the pixel width
   Field ghigh%     ;the pixel height 
   Field gdeep%     ;the screen depth in bits
   Field md$        ;for printing the specs
   Field tip$       ;the tip text for this mode 
End Type

Global fh%=FontHeight()  ;store the height of the current font
Global Leftlen%          ;the pixel length of the longest mode name               
Global Rightlen%         ;the pixel length of the longest tip text
Global ModesFound% = 0   ;how many are available on this system
Global MaxModes% = 6             ;maximum number of modes to show
Dim OKmodes.GraphMode(MaxModes)    ; an array to store the found modes

For i = 1 To MaxModes
  OKmodes(i) = New GraphMode
Next
; now, we will specify the modes we want to allow the player to
; be able to choose and see if they are available:
; list the modes in order of preference, IE the most preferred one first
; and so on, since only the number of modes that will fit on the
; screen will be shown... 

AddMode(1024,768,24,"Recommended for best results")
AddMode(1024,768,32,"Usable on 450 mhz + systems")
AddMode(1024,768,16,"Usable on 300 mhz + systems")
AddMode(1024,768,48,"should NOT show")  ;purposly unavailable mode, for checking...
AddMode(800,600,16,"OK for 200 mhz +")
AddMode(640,480,24,"Not recommended")
AddMode(640,480,16,"For slow systems")

Graphics 640,480         ;this mode should be available on ALL systems...

ClsColor 150,150,160     ;clear the screen to the background color 
Cls

;load the graphics:
 
Logo%   = LoadImage ("smode.bmp")                  ;the title graphics
Bdrop%  = LoadImage ("BackDrop.bmp")               ;the backdrop
Global Arrows% = LoadAnimImage ("Arrows.bmp",9,17,0,4)    ;the selection arrows

If Logo                         ;if the title pic was loaded
   MaskImage Logo,255,255,255   ;set the transparent colour
EndIf


If Bdrop                 ;if the backdrop loaded
  Viewport 10,8,620,464  ;clip drawing to the inside of the "window"
  TileBlock Bdrop,0,0    ;and fill it with the image
  Viewport 0,0,640,480   ;reset drawing to the full screen size
EndIf

If Logo
   DrawImage Logo,25,20  ;and paste the title on the screen
EndIf

; this stuff draws the 3d borders around the screen...

Color 240,240,255

Rect 0,0,640,1  
Rect 0,0,1,480

Rect 630,8,1,464
Rect 10,472,620,1

Color 190,190,210

Rect 1,1,639,1
Rect 1,1,1,479

Rect 631,7,1,466
Rect 9,473,622,1

Color 50,50,50

Rect 0,479,640,1
Rect 639,0,1,480

Rect 10,8,620,1
Rect 9,8,1,464

Color 70,70,90

Rect 1,478,639,1
Rect 638,1,1,479

Rect 9,7,622,1
Rect 8,7,1,466


Color 0,0,0

Global offset = fh + 5                      ;the spacing between lines of test

txtX = 120
txtY = 120
TextEngrave (txtX,txtY,"Please select the screenmode you would like to use",90,90,90)
txtY = txtY + offset
TextEngrave (txtX,txtY,"Use the arrows or your joystick to select",90,90,90)
txtY = txtY + offset
TextEngrave (txtX,txtY,"and [ENTER] or the Fire button to confirm",90,90,90)
txtY = txtY + offset
TextEngrave (txtX,txtY,"If you have a joypad, you can also use",90,90,90)
txtY = txtY + offset
TextEngrave (txtX,txtY,"your [SELECT] and [START] buttons",90,90,90)



txtX = 320 - (Leftlen + 50 + Rightlen)/2
cntX = txtX + 50 + Leftlen
txtY = 465 - (ModesFound * (fh + 5))
Global arrY = txtY
Global larX = txtX -20
Global rarX = cntX + Rightlen + 10


If ModesFound

  For i = 1 To ModesFound                    ;this shows the usable modes on the screen
  
    TextEngrave (txtX,txtY,OKmodes(i)\md$,60,60,160)   ;we print them in two columns
    TextEngrave (cntX,txtY,OKmodes(i)\tip$,60,60,160)
 
    txtY = txtY + offset

  Next

  item% = 1

  ShowSel (item)

Else

   RuntimeError "Sorry, your system doesn't support the required Graphics modes"

EndIf

stick% = JoyType()   ;see if a joystick/pad is connected

Repeat   ;check for user's input

   kp% = GetKey()                      ;check the keyboard first

   If stick And (Not (kp))             ;check the stick if no keyboard input
      If JoyYDir() <0 Then kp = 28     ;stick up
      If JoyYDir() >0 Then kp = 29     ;stick down
      If JoyDown(9) Then kp = 29       ;select button
      If JoyDown(1) Then kp = 13       ;fire button 1
      If JoyDown(10) Then kp = 13      ;start button      
   EndIf

   Select kp
      Case 28   ;arrow up
         If item = 1
            item = ModesFound
         Else
            item = item - 1
         EndIf
         ShowSel (item)

      Case  29   ;arrow down
         If item = ModesFound
            item = 1
         Else
            item = item + 1
         EndIf
         ShowSel (item) 
      Case 13    ;Enter
         ;End
         GotIt = 1
 
   End Select
   Delay 100

Until GotIt

Graphics OKmodes(item)\gwide, OKmodes(item)\ghigh,OKmodes(item)\gdeep

Bdrop%  = LoadImage ("BackDrop.bmp")               ;the backdrop

If Bdrop                 ;if the backdrop loaded
  TileBlock Bdrop,0,0    ;and fill it with the image
EndIf

TextEngrave (20,10,"You Selected a screen of",60,60,160)
TextEngrave (20,40,OKmodes(item)\md$,60,60,160)
TextEngrave (20,90,"Your program would start now...",60,60,160)
TextEngrave (20,200,"Click your mouse to exit",255,60,60)

WaitMouse

End

; ----------- Functions -----------------------------------------

; adds a screen mode to the acceptable modes list if it is available

Function AddMode(mwidth%,mheight%,mdepth%,mtip$)
   If ModesFound < MaxModes
     If FindGfxMode(mwidth,mheight,mdepth) 
       ModesFound                 = ModesFound + 1
       OKmodes(ModesFound)\gwide  = mwidth
       OKmodes(ModesFound)\ghigh  = mheight
       OKmodes(ModesFound)\gdeep  = mdepth
       temp$                      = mwidth+"x"+mheight+"x"+mdepth
       OKmodes(ModesFound)\md$    = temp$
       OKmodes(ModesFound)\tip$   = mtip$
     
       TxtWd%  = StringWidth (temp$) ;check the pixel width of the strings
       TxtWd2% = StringWidth (mtip$)

       If TxtWd > Leftlen
          Leftlen = TxtWd
       EndIf
     
       If TxtWd2 > Rightlen
          Rightlen = TxtWd2
       EndIf
     EndIf
   EndIf
Return

End Function

; ---------------------------------------------------------------

Function TextEngrave (txtX%,txtY%,prt$,ered%,egreen%,eblue%)  ;this "engraves" the text string 

   Color 200,200,200
   Text txtX,txtY,prt$
   Text txtX,txtY-1,prt$
  
   Color 0,0,0
   Text txtX-2,txtY-2,prt$
   Text txtX-2,txtY-1,prt$

   Color ered,egreen,eblue
   Text txtX-1,txtY-1,prt$

   Return

End Function

; ----------------------------------------------------------------

Function ShowSel (sel%) 
   arY = arrY
   For zz = 1 To ModesFound
      If zz = sel
         limg = 2
         rimg = 3
      Else
         limg = 0
         rimg = 1
      EndIf 
      DrawImage Arrows,larX,arY,limg
      DrawImage Arrows,rarX,arY,rimg
      arY = arY + offset
   Next
Return

End Function
