; *****************************
; * MORPHIN DOTS              *
; *****************************
; * CODING BY TRACER          *
; * TRACERBB@HOTMAIL.COM      *
; *****************************

Global numdots = 1440										; How many dots are in the ball?
Global numobjs = 18											; Number of objects.
Global distance  = 400										; Needed for perspective.
Global vx#													; X location.
Global vy#													; Y location.
Global vz#													; Z location.
Global obj = 1												; Start object.

; Arrays used by 3d code.
Dim points(numdots, 3)										; Contains the next object to morph to.
Dim tpoint(numdots, 3)										; Contains the current (being morphed) object.

Graphics 640,480											; Go to graphics mode.
SetBuffer BackBuffer()										; Double buffering.

object(obj)													; Get first object.
; Put first object into displayed object array.
For t = 1 To numdots	
	tpoint(t,1) = points(t,1)
	tpoint(t,2) = points(t,2)
	tpoint(t,3) = points(t,3)
Next
; Loop until esc is pressed.
While Not KeyDown(1)
	Color 255,255,255
	Text 320,0,"MORPHING DOT OBJECTS",640
	Text 320,15,"Coding by TRACER for the Blitz CD",640
	Text 320,30,"Contact me at: tracerbb@hotmail,com",640
	
	If cnt > 999
		obj = obj + 1
		If obj > numobjs Then obj = 1
		object(obj)
		cnt = 0
	EndIf
	morphing()
	cnt = cnt + 1
	threed()												; Call the threed thing.
	dummy = MouseX()										; Removes the mouse from fullscreen.
	Flip													; Flip the screen.
	Cls														; Clear the screen.
Wend

Function threed()
	vx# = vx# + 0.5											; X rotation speed of ball.
	vy# = vy# + 0.5											; Y rotation speed of ball.
	vz# = vz# + 0.5											; Z rotation speed of ball.

	For n = 1 To numdots
		x3d = tpoint(n, 1)
		y3d = tpoint(n, 2)
		z3d = tpoint(n, 3)
       
		ty# = ((y3d * Cos(vx#)) - (z3d * Sin(vx#)))
		tz# = ((y3d * Sin(vx#)) + (z3d * Cos(vx#)))
		tx# = ((x3d * Cos(vy#)) - (tz# * Sin(vy#)))
		tz# = ((x3d * Sin(vy#)) + (tz# * Cos(vy#)))
		ox# = tx#
		tx# = ((tx# * Cos(vz#)) - (ty# * Sin(vz#)))
		ty# = ((ox# * Sin(vz#)) + (ty# * Cos(vz#)))
		nx  = Int(512 * (tx#) / (distance - (tz#))) + 320
		ny  = Int(240 - (512 * ty#) / (distance - (tz#)))
      
		setcolor(tz#)
		Rect nx,ny,1,1
	Next
End Function

; This function looks at the z-value of the pixel
; and sets the color accoordingly.
Function setcolor(t#)
	If t# <= 200 And t# >= 75
		Color 250,250,250
	EndIf
	If t# <= 75 And t# >= 50
		Color 225,225,225
	EndIf
	If t# <= 50 And t# >= 25
		Color 200,200,200
	EndIf
	If t# <= 25 And t# >= 0
		Color 175,175,175
	EndIf
	If t# <= 0 And t# >= -25
		Color 150,150,150
	EndIf
	If t# <= -25 And t# >= -50
		Color 125,125,125
	EndIf
	If t# <= -50 And t# >= -75
		Color 100,100,100
	EndIf
	If t# <= -75 And t# >= -200
		Color 50,50,50
	EndIf
End Function

Function object(obj)
	Select obj
		Case 1
			; line
			For t = 1 To numdots
				points(t,1) = Rnd(-50,50)
				points(t,2) = 0
				points(t,3) = 0
			Next
		Case 2
			; sphere
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(t) * 10)
				y0 = (Cos(xd) * 10) * (Sin(t) * 10)
				z0 = Sin(xd) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 3
			; cone thing
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(t) * 10)
				y0 = (Cos(xd) * 10) * (Sin(t) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 4
			; twist
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(xd) * 10)
				y0 = (Cos(xd) * 10) * (Sin(xd) * 10)
				z0 = Sin(xd) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 5
			; cylinder
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(xd) * 10)
				y0 = (Cos(xd) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 6
			; hat kinda thing
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(xd) * 10)
				y0 = (Cos(t) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 7
			; bend plain kinda thing
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(t)* 10) * (Cos(t) * 10)
				y0 = (Cos(t) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 8
			; curl
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(t)* 10) * (Cos(t) * 10)
				y0 = (Cos(t) * 10) * (Sin(t) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 9
			; round torus like thing
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(t) * 10)
				y0 = (Cos(t) * 10) * (Sin(t) * 10)
				z0 = Sin(xd) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 10
			; wavey plain
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(t) * 10)
				y0 = (Cos(t) * 10) * (Sin(xd) * 10)
				z0 = Sin(xd) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 11
			; round torus like thing
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(t)* 10) * (Cos(t) * 10)
				y0 = (Cos(xd) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 12
			; squished pillow kinda thing :)
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(t) * 10)
				y0 = (Sin(xd) * 10) * (Sin(t) * 10)
				z0 = Sin(xd) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 13
			; plain
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(xd) * 10)
				y0 = (Sin(xd) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 14
			; hmm
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(xd) * 10)
				y0 = (Sin(t) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 15
			; cool
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Sin(xd)* 10) * (Cos(xd) * 10)
				y0 = (Sin(xd) * 10) * (Sin(t) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 16
			; yo
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(t)* 10) * (Cos(t) * 10)
				y0 = (Sin(t) * 10) * (Sin(xd) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 17
			; plain
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(t) * 10)
				y0 = (Sin(t) * 10) * (Sin(xd) * 10)
				z0 = Cos(xd) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
		Case 18
			; bo-tie
			For t= 1 To numdots
				xd = Rnd(-90,90)
				x0 = (Cos(xd)* 10) * (Cos(xd) * 10)
				y0 = (Cos(t) * 10) * (Sin(t) * 10)
				z0 = Sin(t) * 100
				points(t,1) = x0
				points(t,2) = y0
				points(t,3) = z0
			Next
	End Select
End Function

Function morphing()
	For t = 1 To numdots
		If points(t,1) > tpoint(t,1)
			tpoint(t,1) = tpoint(t,1) + 1
		EndIf
		If points(t,1) < tpoint(t,1)
			tpoint(t,1) = tpoint(t,1) - 1
		EndIf
		If points(t,2) > tpoint(t,2)
			tpoint(t,2) = tpoint(t,2) + 1
		EndIf
		If points(t,2) < tpoint(t,2)
			tpoint(t,2) = tpoint(t,2) - 1
		EndIf
		If points(t,3) > tpoint(t,3)
			tpoint(t,3) = tpoint(t,3) + 1
		EndIf
		If points(t,3) < tpoint(t,3)
			tpoint(t,3) = tpoint(t,3) - 1
		EndIf
	Next
End Function
