AppTitle "Ms BlitzMan Map Editor"
; Ms BlitzMan Map editor Version 1.0
; Mark Incitti   September 2000
; mark@incitti.com

; Controls
; F1:  plonking mode (smoothly connects to surrounding maptiles)
; F2:  dot mode
; F3:  power pill mode
; F4:  select a tile
; F5:  draw cage
; F6:  draw closed border
; F7:  fill all empty spots with dots
; F8:  Swap with the undo buffer
; F9:  cycle back 10 maps
; F10: cycle back 1 map
; F11: cycle forward 1 map
; F12: cycle forward 10 maps
; Cursor Right/Left: cycle through 7 color registers 1,2 and 4 used
; Keypad 7 + 9 decrease/increase Red component of current register
; Keypad 4 + 6 decrease/increase Green component of current register
; Keypad 1 + 3 decrease/increase Blue component of current register
; Esc:  Quit, and prompt for save
; Keyboard 1,2,3...,9,0  - copy current map to that buffer
; SHIFT+Keyboard 1,2,3...,9,0  - paste from that buffer 
; mouse to move cursor
; Left Mouse Button - plonk or paste, select tile when in F4 mode
; Right Mouse Button - remove tile / unplonk
;
; Notes:
;       after running and saving, you must manually copy tempmaps.bin to allmaps.bin
; 		and temppal.bmp to palette.bmp, making backups of the originals, of course
;


;********************************************************************************************
Const gdsz=10
Const cagex=9
Const cagey=8
Const width=23+1
Const height=16+1+5
Const nummaps = 100
Const numbackups = 10
Const copypal = 0 ; copy palette with map. 1 yes, 0 no

Type object
	Field x,y,vx,vy,sx,sy
End Type
me.object = New object

Type rgb
	Field col  ; colors 0-7  4-r, 2-g, 1-b
	Field x,y
End Type

Global mn  ; current map number
Global c.rgb ; colour points
Dim coltable(7,3,nummaps)   ; 7 colors, 3 - r,g,b, nummaps palettes
Dim bcoltable(7,3,15) ; back up 10 checkpoints
Dim character(512); look up table for char to draw (0-52)
Dim bitsum(128) ;1,2,4,8,16,etc
Dim maps(width,height,nummaps )
Dim bmaps(width,height,15) ; copy 10 checkpoints


; bit sum numbers
;  1 | 2 | 4
;------------
; 128|256| 8
;------------
;  64| 32| 16

For t = 0 To 511
	character(t)=-1
Next
For t = 0 To 51
	Read number
	If t>0 Then number=number+256
	If t<48 Or t>50 Then character(number)=t ; reverse lookup map the characters, except cage chars (48-50)
	bitsum(t)=number
Next
Data 0,255,0,170
Data 130,10,40,160
Data 2,32,8,128
Data 138,168,162,42
Data 34,136,187,238
Data 62,143,227,248
Data 131,14,56,224
Data 254,251,239,191
Data 250,235,175,190
Data 234,171,174,186
Data 142,232,163,58
Data 139,184,226,46
Data 136,136,136,255   ; invisible tile!

For t = 52 To 60
	bitsum(t)=0
Next

Dim cagechar(7,5)
For tx=0 To 6
	For ty=0 To 4
	Read cagechar(tx,ty)
Next
Next
Data 0, 0, 0, 0,0
Data 0, 6,16, 5,0
Data 0,48, 0,17,0
Data 0,50, 0,17,0
Data 0,49, 0,17,0
Data 0, 7,16, 4,0
Data 0, 0, 0, 0,0

Graphics 320,240
SetBuffer BackBuffer()

; 0-51 blocks, 52 - dot, 53 - power,  54 - pointer
Global blockimages=LoadAnimImage("images/blocks.bmp",16,16,0,5*13)
Global paletteimg = LoadImage("images/palette.bmp") ; 7 pixels(bg,dot,centre,,trim,,, )

Gosub GetImageRGB
GetPalettes()
PaletteSwitch()

Gosub loadmapsbin
Gosub initvars


;********************************************************************************************
mn = 0
.start
While KeyDown(1) = 0 ; while not escape key 
	Gosub moveme
	Gosub selectfunc
	Gosub drawboard
	Flip
	Delay 100
Wend

Cls
SetBuffer FrontBuffer()
Cls
Locate 10,10
Print "Save maps to 'maps/tempmaps.bin'"
Locate 10,25
Print "y/n"
answer = 0
While answer = 0
	If KeyHit(21) Then answer = 1
	If KeyHit(49) Then answer = -1
	VWait
Wend
If answer = 1
	Locate 10,40:Print "Saving Maps"
	Gosub savemaps
EndIf
Locate 10,55
Print "Save palette to 'images/temppal.bmp'"
Locate 10,70
Print "y/n"
answer = 0
While answer = 0
	If KeyHit(21) Then answer = 1
	If KeyHit(49) Then answer = -1
	VWait
Wend
If answer = 1
	Locate 10,40:Print "Saving Palette"
	Gosub savepal
EndIf
Delay 1000
End  ;  mainloop
;********************************************************************************************



;********************************************************************************************
Function GetPalettes()
	Cls
	DrawImage paletteimg,0,0
	For y = 0 To nummaps-1
		For x = 0 To 7
			GetColor(x,y)
			coltable(x,0,y) = ColorRed()
			coltable(x,1,y) = ColorGreen()
			coltable(x,2,y) = ColorBlue()
		Next
	Next
End Function
;********************************************************************************************



;********************************************************************************************
Function PaletteSwitch()
	Cls
	For c.rgb = Each rgb
		Color coltable(c\col,0,mn),coltable(c\col,1,mn),coltable(c\col,2,mn)
		Plot c\x,c\y
	Next
	For row = 0 To 4 
		For frm = 0 To 12
			GrabImage blockimages,16*frm,row*16,frm+row*13
		Next
	Next
End Function
;********************************************************************************************



;********************************************************************************************
.GetImageRGB
	SetBuffer BackBuffer()
	Cls
	For row = 0 To 4
		For frm = 0 To 12
			DrawImage blockimages,16*frm,row*16,frm+row*13
		Next
	Next
	For y = 1 To 16*5
		For x = 1 To 16*13
			GetColor(x,y)
			cr = ColorRed()
			cb = ColorBlue()
			cg = ColorGreen()
			col = 0 
			If cr > 128 Then col = col Or 4 
			If cg > 128 Then col = col Or 2 
			If cb > 128 Then col = col Or 1 
			If col > 0
				c.rgb = New rgb
				c\col = col 
				c\x = x
				c\y = y
			EndIf
		Next
	Next
Return
;********************************************************************************************



;********************************************************************************************
.initvars
me\x=1
me\y=1
me\sx=gdsz*me\x
me\sy=gdsz*me\y
funct=1
singlechar=1
scrolltop=0
Return
;********************************************************************************************



;********************************************************************************************
.selectfunc
changed = 0
If KeyHit(59) Then funct=1  ; plonking
If KeyHit(60) Then funct=2  ; dots
If KeyHit(61) Then funct=3  ; power
If KeyHit(62) Then funct=4  ; pick a tile
If KeyHit(63) Then Copyit(12):Gosub makecage
If KeyHit(64) Then Copyit(12):Gosub makedots
If KeyHit(65) Then Copyit(12):Gosub makeborder
If KeyHit(66) 
	Swapit()
	changed = 1
EndIf
For key = 2 To 11
	If (KeyDown(42) Or KeyDown(54))
		If KeyHit(key) Then Pasteit(key):changed=1		
	Else
		If KeyHit(key) Then Copyit(key)
	EndIf
Next
If KeyHit(205)
	reg = reg + 1: If reg > 7 Then reg = 0
EndIf
If KeyHit(203)
	reg = reg - 1: If reg < 0 Then reg = 7
EndIf

If KeyHit(67) 
	mn = mn-10:If mn < 0 Then mn = mn + nummaps
	changed = 1
EndIf
If KeyHit(68)
	mn = mn-1:If mn < 0 Then mn = nummaps-1
	changed = 1
EndIf
If KeyHit(87) 
	mn = mn+1:If mn > nummaps-1 Then mn = 0
	changed = 1
EndIf
If KeyHit(88) 
	mn = mn+10:If mn > nummaps-1 Then mn = mn - nummaps
	changed = 1
EndIf
If KeyDown(73)
	coltable(reg,0,mn) = coltable(reg,0,mn) + 5:If coltable(reg,0,mn)>255 Then coltable(reg,0,mn)=0
	changed = 1
EndIf
If KeyDown(71)
	coltable(reg,0,mn) = coltable(reg,0,mn) - 5:If coltable(reg,0,mn)< 0 Then coltable(reg,0,mn)=255 
	changed = 1
EndIf

If KeyDown(77)
	coltable(reg,1,mn) = coltable(reg,1,mn) + 5:If coltable(reg,1,mn)>255 Then coltable(reg,1,mn)=0 
	changed = 1
EndIf
If KeyDown(75)
	coltable(reg,1,mn) = coltable(reg,1,mn) - 5:If coltable(reg,1,mn)< 0 Then coltable(reg,1,mn)=255 
	changed = 1
EndIf

If KeyDown(81)
	coltable(reg,2,mn) = coltable(reg,2,mn) + 5:If coltable(reg,2,mn)>255 Then coltable(reg,2,mn)=0 
	changed = 1
EndIf

If KeyDown(79)
	coltable(reg,2,mn) = coltable(reg,2,mn) - 5:If coltable(reg,2,mn)< 0 Then coltable(reg,2,mn)=255 
	changed = 1
EndIf
If changed = 1 Then PaletteSwitch()
Return
;********************************************************************************************



;********************************************************************************************
.moveme
x=MouseX():y=MouseY()
me\x=x/gdsz
If me\x<1 Then me\x= 1
If me\x>width+2 Then me\x=width+2
me\y=y/gdsz
If me\y<=1
	me\y=1
	If me\x > width 
		scrolltop = scrolltop - 1
		If scrolltop < 0 Then scrolltop = 0
	EndIf
EndIf
If me\y>=height-1
	me\y=height-1
	If me\x > width
		scrolltop = scrolltop + 1
		If scrolltop >54-height/2 Then scrolltop = 54 - height/2
	EndIf
EndIf
If me\x < width
	If MouseDown(2) Then Gosub pickup
	If MouseDown(1) Then Gosub paste
Else
	If me\y - Int(me\y/2)*2 = 1 Then me\y=me\y-1
	If MouseHit(2) Then singlechar = me\y/2 + scrolltop
	If MouseHit(1) Then singlechar = me\y/2 + scrolltop
EndIf
me\sx=me\x*gdsz
me\sy=me\y*gdsz
Return
;********************************************************************************************



;********************************************************************************************
.pickup
x=me\x
y=me\y
me\sx=me\x*gdsz
me\sy=me\y*gdsz

;erase it
maps(x,y,mn)=0

; adjust surrounding blocks
; start at top left,  clockwise
If  maps(x-1,y-1,mn) <51
	newchar=bitsum(maps(x-1,y-1,mn)) And (511-16) ;Not 16
	If character(newchar)<>-1
		maps(x-1,y-1,mn)=character(newchar)
	EndIf
EndIf

; above
If maps(x,y-1,mn) <51
	newchar=bitsum(maps(x,y-1,mn) ) And (511-32-64-16)
	If character(newchar)<>-1
		maps(x,y-1,mn)=character(newchar)
	EndIf
EndIf

; above right
If maps(x+1,y-1,mn)<51
	newchar=bitsum(maps(x+1,y-1,mn)) And (511-64)
	If character(newchar)<>-1
		maps(x+1,y-1,mn)=character(newchar)
	EndIf
EndIf

;right
If maps(x+1,y,mn)<51
	newchar=bitsum(maps(x+1,y,mn)) And (511-128-1-64)
	If character(newchar)<>-1
		maps(x+1,y,mn)=character(newchar)
	EndIf
EndIf

;bottom right
If maps(x+1,y+1,mn)<51
	newchar=bitsum(maps(x+1,y+1,mn)) And (511-1)
	If character(newchar)<>-1
		maps(x+1,y+1,mn)=character(newchar)
	EndIf
EndIf

; bottom
If maps(x,y+1,mn)<51
	newchar=bitsum(maps(x,y+1,mn)) And (511-7)
	If character(newchar)<>-1
   		maps(x,y+1,mn)=character(newchar)
	EndIf
EndIf

; bottom left
If maps(x-1,y+1,mn)<51
	newchar=bitsum(maps(x-1,y+1,mn)) And (511-4)
	If character(newchar)<>-1
   		maps(x-1,y+1,mn)=character(newchar)
	EndIf
EndIf

;left
If maps(x-1,y,mn)<51
	newchar=bitsum(maps(x-1,y,mn)) And (511-8-4-16)
	If character(newchar)<>-1
		maps(x-1,y,mn)=character(newchar)
	EndIf
EndIf
Return
;********************************************************************************************



;********************************************************************************************
.paste
x=me\x:y=me\y
me\sx=me\x*gdsz:me\sy=me\y*gdsz
;draw it
Select funct
	Case 1
		char=256
		; adjust surrounding blocks
		; above
		newchar=bitsum(maps(x,y-1,mn)) Or  32
		If character(newchar)<>-1
   			maps(x,y-1,mn)=character(newchar)
   			char=char Or 2
		EndIf
		
		;right
		tempchar = maps(x+1,y,mn)
		newchar=bitsum(maps(x+1,y,mn)) Or 128
		If character(newchar)<>-1
   			maps(x+1,y,mn)=character(newchar)
   			char=char Or 8
		EndIf
		
		; bottom
		newchar=bitsum(maps(x,y+1,mn)) Or 2
		If character(newchar)<>-1
			maps(x,y+1,mn)=character(newchar)
			char=char Or 32
		EndIf
		
		;left
		newchar=bitsum(maps(x-1,y,mn)) Or 8
		If character(newchar)<>-1
   			maps(x-1,y,mn)=character(newchar)
   			char=char Or 128
		EndIf

		; top left,  clockwise
		newchar=bitsum(maps(x-1,y-1,mn)) Or 16
		If character(newchar)<>-1
	   		maps(x-1,y-1,mn)=character(newchar)
   			maps(x,y-1,mn)=character(bitsum(maps(x,y-1,mn)) Or 64)
   			maps(x-1,y,mn)=character(bitsum(maps(x-1,y,mn)) Or 4)
   			char=char Or 1
		EndIf

		; above right
		newchar=bitsum(maps(x+1,y-1,mn)) Or 64
		If character(newchar)<>-1
			maps(x+1,y-1,mn)=character(newchar)
			maps(x,y-1,mn)=character(bitsum(maps(x,y-1,mn)) Or 56)
			maps(x+1,y,mn)=character(bitsum(maps(x+1,y,mn)) Or 1)
			char=char Or 4
		EndIf

		;bottom right
		newchar=bitsum(maps(x+1,y+1,mn)) Or 1
		If character(newchar)<>-1
			maps(x+1,y+1,mn)=character(newchar)
			maps(x,y+1,mn)=character(bitsum(maps(x,y+1,mn)) Or 4)
			maps(x+1,y,mn)=character(bitsum(maps(x+1,y,mn)) Or 64)
			char=char Or 16
		EndIf
		
		; bottom left
		newchar=bitsum(maps(x-1,y+1,mn)) Or 4
		If character(newchar)<>-1
			maps(x-1,y+1,mn)=character(newchar)
			maps(x,y+1,mn)=character(bitsum(maps(x,y+1,mn)) Or 1)
			maps(x-1,y,mn)=character(bitsum(maps(x-1,y,mn)) Or 16)
			char=char Or 64
		EndIf

		maps(x,y,mn)=character(char)
		If maps(x,y,mn)=-1 Then maps(x,y,mn)=2

	Case 2
		; dots
		Gosub pickup
		maps(x,y,mn)=52
	Case 3
		; power
		Gosub pickup
		maps(x,y,mn)=53
	Case 4
		; hard coded drop tile
		;Gosub pickup
		maps(x,y,mn)=singlechar
	End Select
Return
;********************************************************************************************



;********************************************************************************************
.makecage
xtemp=me\x:ytemp=me\y
;remove the blocks around cage area
For tx=0 To 6
	For ty=0 To 4
		me\x=tx+cagex:me\y=ty+cagey
		Gosub pickup
	Next
Next
;place the cage blocks down
For tx=0 To 6
	For ty=0 To 4
		maps(tx+cagex,ty+cagey,mn)=cagechar(tx,ty)
	Next
Next
;erase pac start space
me\x=cagex+3:me\y=cagey+8
Gosub pickup
maps(me\x,me\y,mn)=0
me\x=xtemp:me\y=ytemp
me\sx=me\x*gdsz
me\sy=me\y*gdsz
Return
;********************************************************************************************



;********************************************************************************************
.makedots
For x=2 To width-2
	For y=2 To height-2
		If maps(x,y,mn)=0
   			maps(x,y,mn)=52
		EndIf
	Next
Next
maps(cagex+2,cagey+2,mn)=0
maps(cagex+3,cagey+2,mn)=0
maps(cagex+4,cagey+2,mn)=0

;erase pac start space
xtemp=me\x:ytemp=me\y
me\x=cagex+3:me\y=cagey+8
Gosub pickup
maps(me\x,me\y,mn)=0
me\x=xtemp:me\y=ytemp
me\sx=me\x*gdsz
me\sy=me\y*gdsz

Return
;********************************************************************************************



;********************************************************************************************
.makeborder
tfunct=funct
xtemp=me\x:ytemp=me\y
funct=1
For tx=1 To width-1
	me\x=tx:me\y=1
	Gosub paste
	me\x=tx:me\y=height-1
	Gosub paste
Next
For ty=1 To height-1
	me\x=1:me\y=ty
	Gosub paste
	me\x=width-1:me\y=ty
Gosub paste
Next
funct=tfunct
me\x=xtemp:me\y=ytemp
me\sx=me\x*gdsz
me\sy=me\y*gdsz

Return
;********************************************************************************************



;********************************************************************************************
Function Pasteit(key)
For x=0 To width
	For y=0 To height
		maps(x,y,mn) = bmaps(x,y,key-2)
	Next
Next
If copypal = 1 
	For x = 0 To 7
		coltable(x,0,mn) = bcoltable(x,0,key-2)
		coltable(x,1,mn) = bcoltable(x,1,key-2)
		coltable(x,2,mn) = bcoltable(x,2,key-2)
	Next
EndIf
End Function
;********************************************************************************************



;********************************************************************************************
Function Copyit(key)
For x=0 To width
	For y=0 To height
		bmaps(x,y,key-2)=maps(x,y,mn)
	Next
Next
For x = 0 To 7
	bcoltable(x,0,key-2) = coltable(x,0,mn)
	bcoltable(x,1,key-2) = coltable(x,1,mn)
	bcoltable(x,2,key-2) = coltable(x,2,mn)
Next
End Function
;********************************************************************************************



;********************************************************************************************
Function Swapit()
For x=0 To width
	For y=0 To height
	    bmaps(x,y,11) = maps(x,y,mn) ; copy current into slot 12 / temp
		maps(x,y,mn) = bmaps(x,y,10) ; copy slot 11 into current
		bmaps(x,y,10)  = bmaps(x,y,11) ; copy slot 12 into 11
	Next
Next
For x = 0 To 7
	bcoltable(x,0,11) = coltable(x,0,mn)
	bcoltable(x,1,11) = coltable(x,1,mn)
	bcoltable(x,2,11) = coltable(x,2,mn)
	coltable(x,0,mn) = bcoltable(x,0,10)
	coltable(x,1,mn) = bcoltable(x,1,10)
	coltable(x,2,mn) = bcoltable(x,2,10)
	bcoltable(x,0,10) = bcoltable(x,0,11)
	bcoltable(x,1,10) = bcoltable(x,1,11)
	bcoltable(x,2,10) = bcoltable(x,2,11)
Next
End Function
;********************************************************************************************



;********************************************************************************************
.drawboard
Cls
For x=0 To width-1
	For y=0 To height-1
		kar=maps(x,y,mn)
		If kar >= 0
			DrawImage blockimages,x*(gdsz),y*gdsz,kar
			;If kar = 51 Then DrawImage blockimages,x*(gdsz),y*gdsz,54
		EndIf
	Next
Next
Locate 273,((gdsz+2)*0+8):Print "Map" + mn

Locate 273,((gdsz+2)*1+8):Print "f1":DrawImage blockimages,30*gdsz-3,(gdsz+2)*1+8,2
Locate 273,((gdsz+2)*2+8):Print "f2":DrawImage blockimages,30*gdsz-3,(gdsz+2)*2+8,52
Locate 273,((gdsz+2)*3+8):Print "f3":DrawImage blockimages,30*gdsz-3,(gdsz+2)*3+8,53
Locate 273,((gdsz+2)*4+8):Print "f4 ^"
Locate 273,((gdsz+2)*5+8):Print "f5 C"
Locate 273,((gdsz+2)*6+8):Print "f6 D"
Locate 273,((gdsz+2)*7+8):Print "f7 B"
Locate 273,((gdsz+2)*8+8):Print "f8 U"
Locate 273,((gdsz+2)*9+8):Print " 9<<"
Locate 273,((gdsz+2)*10+8):Print "10 <"
Locate 273,((gdsz+2)*11+8):Print"11 >"
Locate 273,((gdsz+2)*12+8):Print"12>>"

Locate 273,((gdsz+2)*14+8):Print "C"
Locate 273,((gdsz+2)*15+8):Print "R"
Locate 273,((gdsz+2)*16+8):Print "G"
Locate 273,((gdsz+2)*17+8):Print "B"
Locate 283,((gdsz+2)*14+8):Print reg
Locate 283,((gdsz+2)*15+8):Print coltable(reg,0,mn)
Locate 283,((gdsz+2)*16+8):Print coltable(reg,1,mn)
Locate 283,((gdsz+2)*17+8):Print coltable(reg,2,mn)

For t = 0 To 7
	Color coltable(t,0,mn) ,coltable(t,1,mn) ,coltable(t,2,mn)
	Rect 273+t*3,((gdsz+2)*13+12),3,3
Next

Color 255,255,0
Rect gdsz*30-1,funct*(gdsz+2)+10,gdsz,gdsz+1,0
If funct = 4
	For t = 0 To height/2
		DrawImage blockimages,26*gdsz,t*gdsz*2,scrolltop+t
	Next
	Locate 25*gdsz,gdsz*(singlechar-scrolltop)*2:Print">"
EndIf

DrawImage blockimages,me\sx,me\sy,55
Return
;********************************************************************************************



; load and save routines
;********************************************************************************************
.loadmapsbin
fh = OpenFile("maps/allmaps.bin")
For m = 0 To nummaps-1
	For y=0 To height-1
		chars$ = ReadLine(fh)
		For x=0 To width-1
			ch = Asc(Mid(chars$,x+1,1)) - 32
;			If ch <0 Then ch = 0
        	maps(x+1,y+1,m) = ch ; read in all the chars
		Next
	Next
Next
CloseFile fh
Return
;********************************************************************************************



;********************************************************************************************
.savemaps
Cls
Locate 10,10:Print "Saving maps"
Flip
chars$ = ""
fh = WriteFile("maps/tempmaps.bin")
For m = 0 To nummaps-1
	For y=0 To height-1
		For x=0 To width-1
			chars$ = chars$ + Chr$(maps(x+1,y+1,m)+32)
		Next
		WriteLine fh, chars$
		chars$ = ""
	Next
Next
CloseFile fh
Return
;********************************************************************************************



;********************************************************************************************
.savepal
Cls
For m = 0 To nummaps-1
For t = 0 To 7
	Color coltable(t,0,m) ,coltable(t,1,m) ,coltable(t,2,m)
	Plot t,m
Next
Next
GrabImage paletteimg,0,0
SaveImage paletteimg,"images/temppal.bmp" ;save image to bmp file
Return
;********************************************************************************************