AppTitle "Ms BlitzMan"
; Ms BlitzMan  Version 1.0
; Mark Incitti,  September 2000
; mark@incitti.com
; Last modified: September 29,2000

;--------------------------------------------------------------------------------------
; you can change these
Const invincible=0		; 0 normal, change to 1 for invincible *cheat*
Const numprizes=3		; (1,2,3...) Usually 2 or 3
Const prizeontime=511	; (127,255,511, or 1023) -power of 2 -1, Usually 511
Const MAXEXSPEED=120	; (20-200) amount of zoom time
Const PRIZEEXSPEED=50	; (0-200) extra zoom time from eating prize
Const speedkey=57		; zoom key 57=SPACE
Const speedkeyjoy=1		; zoom key Button 1 on joypad
Const pausekey=25		; pause key - 25=P
Const skiplevkey=0		; 0,63 to skip levels with F5 *cheat* 
Const eyespeed=32		; (1-32) 32 is 2 pixels per frame (eyes move 2X per frame)
Const prizespeed=15		; (1-32)
Const pointtime=110		; Length of time(# of frames) points are displayed
Const dtime=8			; (8, 16, 32) 60 frames/second  = 1000/60  = ~16

;--------------------------------------------------------------------------------------
; but don't change these
Const gdsz=10		; block spacing
Const numbrds=100	; number of boards/prizes
Const mapwidth=23	; number of tiles wide
Const mapheight=21	; number of tiles high
Const cagex=11		; location of cage gate x
Const cagey=8		; location of cage gate y
Const screenw=320	; screen width
Const screenh=240	; screen height
Const XOFF=45		; center the board horizontally

;--------------------------------------------------------------------------------------
;game states
Const dyingmode		=0
Const getreadymode	=1
Const playingmode	=2
Const gameovermode	=3
Const creditsmode	=4
Const startmode		=5
Const donemode		=6
Const nextboardmode	=7
Const pausemode		=8

;--------------------------------------------------------------------------------------
;ghost states
Const edible=1
Const deadly=2
Const eyes=3

;--------------------------------------------------------------------------------------
;ghost anim frame offsets
Const frmgb = 48	; blue
Const frmgw = 50	; white
Const frmge = 52	; eyes



Global score,highscore,startinglevel
Global timer,board,gmode,keyorjoy,lastboard,sklevel=1
Global restorezoom    ;restore zoom after death, 1=true
Global freeman        ;every XXXXX points get a free pac

Type ghost
	Field id       ; id number (0-5)
	Field act      ; activity - edible, deadly, or eyes
	Field bx
	Field by       ; big x,y  32*screen pos
	Field sx
	Field sy       ; screen   bx/32, by/32
	Field x
	Field y        ; x,y map coords sx,sy/gdsz
	Field vx
	Field vy       ; velocity  0-32?  
	Field gspeed   ; vel magnitude
	Field bluetimer; edible time
	Field frm      ; anim frame
	Field frmcnt   ; anim frm counter
	Field cage     ; flag
	Field intunnel ; flag  0-not in, 1 = u/d, -1 = l/r
	Field cagetimer; time in cage
	Field changed  ; tics since last changed direction
End Type

Type pacman
	Field bx
	Field by       ; big x,y  32*screen pos
	Field sx
	Field sy       ; screen   bx/32, by/32
	Field x
	Field y        ; x,y map coords sx,sy/gdsz
	Field vx
	Field vy       ; velocity  0-32 ,0-32
	Field cx
	Field cy       ; character x y
	Field frm      ; anim frame
	Field frmcnt   ; frm counter
	Field intunnel ; flag 0,1,-1
End Type

Type prizetype
	Field bx
	Field by       ; big x,y  0-10230 ,0-6400
	Field sx
	Field sy       ; screen   bx/32, by/32
	Field x
	Field y        ; x,y map coords sx/16,sy/16
	Field vx
	Field vy       ; velocity  0-32 ,0-32
	Field cx
	Field cy       ; character x y
	Field cage     ; flag 0,1
	Field frm      ; anim frame - only 1 frame
	Field frmcnt   ; frm counter - not used
	Field intunnel ; flag 0,1,-1
	Field bouncedir; +/- 1
	Field bouncehgt; 0 to -8
	Field points   ; 100,200,...10000  
End Type

Type pointstype
	Field v		; time on screen counter 
	Field x		
	Field y
	Field frm	
End Type

; color type for palette changes
Type rgb
	Field col  	; color 0-7, 4-r, 2-g, 1-b
	Field x,y
End Type	

Dim map(mapwidth,mapheight)		; the current map
Dim mapopen(mapwidth,mapheight)		; bitsum of the u/d/l/r bits of the current map
Dim maps(mapwidth,mapheight,numbrds)	; all the maps
Dim prizepoints(numbrds)		; points awarded for each prize
Dim coltable(7,3,numbrds)		; 7 colors, r,g,orb, 100 palettes
Dim gkol(6,3)				; 6 ghosts * rgb for each
Global c.rgb				; for ploting the map blocks in new colors

Restore points
For t = 0 To numbrds-1
  Read p:prizepoints(t)=p*10
Next
.points
Data 10  ,20  ,50  ,70  ,100
Data 200 ,500 ,300 ,200 ,100
Data 110 ,120 ,130 ,140 ,150
Data 160 ,170 ,180 ,190 ,200
Data 210 ,220 ,230 ,240 ,250
Data 260 ,270 ,280 ,290 ,300
Data 310 ,320 ,330 ,340 ,350
Data 360 ,370 ,380 ,390 ,400
Data 410 ,420 ,430 ,440 ,450
Data 460 ,470 ,480 ,490 ,500
Data 510 ,520 ,530 ,540 ,550
Data 560 ,570 ,580 ,590 ,600
Data 610 ,620 ,630 ,640 ,650
Data 660 ,670 ,680 ,690 ,700
Data 710 ,720 ,730 ,740 ,750
Data 760 ,770 ,780 ,790 ,800
Data 810 ,820 ,830 ,840 ,850
Data 860 ,870 ,880 ,890 ,900
Data 910 ,920 ,930 ,940 ,950
Data 960 ,970 ,980 ,990 ,1000


SeedRnd MilliSecs()	; reset the random number generator to random start

pac.pacman = New pacman
prize.prizetype = New prizetype




; set up the screen
Graphics screenw,screenh
; always draw to the hidden screen
SetBuffer BackBuffer()

; display booting up message
Color 255,200,200
Locate 40,100
Print "MsBlitzMan Version 1.0"
Locate 40,115
Print "Programmed in BlitzBasicPC"
Locate 40,130
Print "By Mark incitti (2000)"
Locate 40,160
Print "Loading Resources..."
Flip

; load in the graphics
Global ghostimages=LoadAnimImage("images/ghosts.bmp",16,16,0,56)	; rrlluudd*6, bbwwee
Global pacimages=LoadAnimImage("images/pac.bmp",16,16,0,16)			; rrrllluuudddxxxx
Global prizeimages=LoadAnimImage("images/prizes.bmp",16,16,0,100)	; cherries, strawberry,...
Global blockimages=LoadAnimImage("images/blocks.bmp",16,16,0,5*13)	; rgb version of blocks
Global pointimages=LoadAnimImage("images/points.bmp",16,16,0,106)	; 100,200,...9900,10000, 200,400,800,1600,3200,6400
Global miscimages=LoadImage("images/misc.bmp")						; misc - game over, get ready, Ms.Blitzman, paused, zoom
Global numberimages=LoadAnimImage("images/numbers.bmp",16,16,0,40)	; 0,1,2..8,9 in 4 different colors
Global paletteimg = LoadImage("images/palette.bmp")					; 7 pixels(bg,dot,centre,,trim,,, )

; grab the individual images from the miscimage
Global getreadyimage = CreateImage(32,16,1)
Global gameoverimage = CreateImage(32,16,1)
Global mspacimage = CreateImage(72,16,1)
Global pauseimage = CreateImage(32,16,1)
Global zoomimage = CreateImage(22,6,1)
DrawImage miscimages,0,0
GrabImage gameoverimage,0,0
GrabImage getreadyimage,32,0
GrabImage mspacimage,0,16
GrabImage pauseimage,0,32
GrabImage zoomimage,0,48


; load in the sounds
Global sounddot = LoadSound( "sounds/dot.wav" )
Global soundpower = LoadSound( "sounds/pill.wav" )
Global soundprize = LoadSound( "sounds/prize.wav" )
Global soundbounce = LoadSound( "sounds/bounce.wav" )
Global sounddeath = LoadSound( "sounds/death.wav" )
Global soundghost = LoadSound( "sounds/ghost.wav" )
Global soundbonus = LoadSound( "sounds/clap.wav" )
Global soundboarddone = LoadSound( "sounds/clap.wav" )
Global soundgameover = LoadSound( "sounds/over.wav" )
Global soundstartmusic = LoadSound( "sounds/start.wav" )
Global sounddeadly = LoadSound( "sounds/lp-hum.wav" )
Global soundeyes = LoadSound( "sounds/lp-eyes.wav" )
Global soundblue = LoadSound( "sounds/lp-blue.wav" )

; load all the maps
Gosub loadmaps

Cls
Locate 40,100:Print "Resources Loaded."
Flip
Delay 1000

; grab all the colored pixels from the block images
Gosub GetImageRGB

; fill coltable(7,3,100) with the color values from the palette image
GetPalettes()


gmode = creditsmode
keyorjoy = 0 	; keyboard=0, joystick=1 
highscore = 0 
lastboard = 24	; start from level 1 to 25
timer=0


.innerloop
If KeyHit(1) Then gmode=creditsmode	; end with esc
timer=timer+1
If (timer And 16384) = 16384 Then timer = 0
If (timer And 2047) = 2047 Then Gosub reverse
If (timer And 15) = 15 Then flashpill=flashpill+1:If flashpill>1 Then flashpill=0
If (timer And prizeontime) = prizeontime Then Gosub prizeon
Select gmode
	Case pausemode
;		Delay 50
		If SoundPlaying(soundeyes) Then PauseSound soundeyes:psnde = 1 Else psnde = 0
		If SoundPlaying(sounddeadly) Then PauseSound sounddeadly:psndd = 1 Else psndd = 0
		If SoundPlaying(soundblue) Then PauseSound soundblue:psndb = 1 Else psndb = 0
		While Not KeyHit(pausekey)
			Gosub drawall
			Gosub drawpause
			Flip
			Delay 50
		Wend
		If psnde = 1 Then ResumeSound soundeyes
		If psndd = 1 Then ResumeSound sounddeadly
		If psndb = 1 Then ResumeSound soundblue
		gmode = oldmode
	Case creditsmode
		Gosub soundoff
		Gosub credits
		gmode = startmode
	Case startmode
		;new game
		Gosub setupgame
		gmode = nextboardmode
	Case nextboardmode
		; get new map and reset variables each level
		Gosub setuplevel
		Gosub setpositions
		gmode = getreadymode
	Case getreadymode
		;every level and every life
		Gosub drawall
		Gosub drawgetready
		Flip
		If Not KeyDown(skiplevkey)
			If board=0 And looped=0 And played=0
				PlaySound soundstartmusic
				Delay 3500
			Else
				Delay 1500
			EndIf
		EndIf
		played=1
		gmode = playingmode
	Case playingmode
		stime = MilliSecs()
		Gosub moveall
		Gosub drawall
		Flip
		etime = MilliSecs() - stime
		;delay if needed
		If etime < dtime
			Delay (dtime-etime)
		EndIf
		If KeyHit(skiplevkey) Then gmode = nextboardmode   ; skip boards with f2
		If KeyHit(pausekey) Then oldmode = gmode: gmode = pausemode	; pause, remember current mode
	Case donemode
		; all the dots are eaten
		Gosub drawmap
		Gosub drawpac
		Gosub drawzoom
		Gosub drawscore
		Gosub drawpacsleft
		Gosub boardclear
		boarddone=0
		gmode = nextboardmode
	Case dyingmode
		Gosub death
		Gosub setpositions
		If pacmen > 0 Then gmode = getreadymode
		If pacmen = 0 Then gmode = gameovermode
	Case gameovermode
		Gosub soundoff
		Gosub drawmap
		Gosub drawpacsleft
		Gosub drawscore
		Gosub drawzoom
		Gosub drawgameover
		Flip
		PlaySound soundgameover
		Delay 3500
		If score > highscore Then highscore = score
		If board > lastboard Then lastboard = board:startinglevel=lastboard
		gmode = creditsmode
	End Select
Goto innerloop
End  ;  mainloop





;--------------------------------------------------------------------------------------
.drawall
Gosub drawmap
Gosub drawprize
Gosub drawghosts
Gosub drawpac
Gosub drawpoints
Gosub drawzoom
Gosub drawscore
Gosub drawpacsleft
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.moveall
slowdown = slowdown - 1: If slowdown <0 Then slowdown = 0
Select keyorjoy
	Case 0
		If KeyDown(speedkey) And exspeed>0
				Gosub movepac:Gosub gobble
				Gosub movepac:Gosub gobble
				exspeed=exspeed-1
		End If
	Case 1
		If JoyDown(speedkeyjoy) And exspeed>0
				Gosub movepac:Gosub gobble
				Gosub movepac:Gosub gobble
				exspeed=exspeed-1
		End If
End Select
Gosub movepac
Gosub gobble
Gosub movepac
Gosub gobble
pass = 0 ; for regular ghosts
Gosub moveghosts
pass = 0 ; for regular ghosts
Gosub moveghosts
pass = 1 ; for eyes to give 50% more speed
Gosub moveghosts
Gosub moveprize
Gosub checkcollisions
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.setupgame
;set game variables
played=0	;played start music?
board=startinglevel-1
looped=0	;looped through 100 boards?
score=0
bonuscount=1
Select sklevel
	Case 0
		pacmen=5
		freeman=20000
		restorezoom=1
		numghosts = 4
	Case 1
		pacmen=3
		freeman=30000
		restorezoom=1
		numghosts = 4
	Case 2
		pacmen=3
		freeman=50000
		restorezoom=1
		numghosts = 5
	Case 3
		pacmen=2
		freeman=80000
		restorezoom=0
		numghosts = 6
	Case 4
		pacmen=1
		freeman=100000
		restorezoom=0
		numghosts = 6
End Select
Createghosts(numghosts-1)
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
Function Createghosts(num)
;delete the current ghosts
For g.ghost = Each ghost
	Delete g
Next
;create new ghosts
For t=0 To num
	g.ghost= New ghost
	g\id = t
Next
End Function
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.setuplevel
Gosub soundoff
munched=0:pillstotal=0:prizeseaten=0
exspeed=MAXEXSPEED:flashpill=0
board=board+1:If board>numbrds-1 Then board=0:looped=looped+1
If looped=0 ; go to max and stay there
	; ghost speed
	For g.ghost = Each ghost
		t = g\id
		ts = Int(12-t/2+board/10)
		If ts < 10 Then ts = 10
		If ts > 32 Then ts = 32
		g\gspeed = ts
	Next

	; ghost edible speed
	ts = Int(8+board/10)
	If ts < 8 Then ts = 8
	If ts > 31 Then ts = 31
	edspeed = ts
	
	;ghost tunnel speed
	ts = Int(5+board/10)
	If ts < 5 Then ts = 5
	If ts > 32 Then ts = 32
	gtspeed = ts
	
	;pac speed
	ts = Int(12+board/10)
	If ts < 12 Then ts = 12
	If ts > 32 Then ts = 32
	pspeed = ts
	
	;pac tunnel speed
	ts = Int(12+board/10)
	If ts < 12 Then ts = 12
	If ts > 32 Then ts = 32
	ptspeed = ts
	
EndIf
PaletteSwitch()
Gosub setupmap
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.setpositions
timer=0:prizedir=0:gobble=0

For g.ghost=Each ghost
 g\x=cagex
 g\y=cagey+1
 g\sx=gdsz*g\x
 g\sy=gdsz*g\y
 g\vx=g\gspeed
 g\vy=0
 g\bluetimer=0
 g\bx=g\sx*32:g\by=g\sy*32
 g\frm=20:g\intunnel=0
 g\cage=0:g\act=deadly
 g\cagetimer = 80+g\id*100-board*2
 If g\cagetimer < 0 Then g\cagetimer=2
 If g\cagetimer > 500 Then g\cagetimer=500
Next

pac\x=cagex
pac\y=cagey+7
pac\sx=gdsz*pac\x
pac\sy=gdsz*pac\y
pac\bx=pac\sx*32
pac\by=pac\sy*32
pac\frm=4
pac\intunnel=0
pac\vx = -pspeed
pac\vy = 0

prize\cage = 1
prize\x=cagex
prize\y=cagey+1
prize\sx=gdsz*prize\x
prize\sy=gdsz*prize\y
prize\frm=board

FlushKeys()
Return
;--------------------------------------------------------------------------------------




;--------------------------------------------------------------------------------------
Function FlushKeys()
	While GetKey():Wend
	For k=1 To 255:KeyHit(k):Next
End Function
;--------------------------------------------------------------------------------------




;--------------------------------------------------------------------------------------
Function GetPalettes()
	Cls
	DrawImage paletteimg,0,0
	; grab the 7 colors from the 100 rows 
	For y = 0 To numbrds-1
		For x = 0 To 7
			GetColor(x,y)
			coltable(x,0,y) = ColorRed()
			coltable(x,1,y) = ColorGreen()
			coltable(x,2,y) = ColorBlue()
		Next
	Next
End Function
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
Function PaletteSwitch()
	Cls
	; plot the red, green, blue, yellow, purple, white, cyan
	; to the screen in their new colors
	For c.rgb = Each rgb
		Color coltable(c\col,0,board),coltable(c\col,1,board),coltable(c\col,2,board)
		Plot c\x,c\y
	Next
	; grab the newly colored images
	For row = 0 To 4 
		For frm = 0 To 12
			GrabImage blockimages,16*frm,row*16,frm+row*13
		Next
	Next
End Function
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.GetImageRGB
	; draw the block images
	; check each pixel, if it is r,g,b,y,p,c, or w 
	;   then create an rgb object
	; later used to plot the image in new colors
	SetBuffer BackBuffer()
	Cls
	For row = 0 To 4
		For frm = 0 To 12
			DrawImage blockimages,16*frm,row*16,frm+row*13
		Next
	Next
	For y = 1 To 16*5
		For x = 1 To 16*13
			GetColor(x,y)
			cr = ColorRed()
			cb = ColorBlue()
			cg = ColorGreen()
			col = 0 
			If cr > 128 Then col = col Or 4 
			If cg > 128 Then col = col Or 2 
			If cb > 128 Then col = col Or 1 
			If col > 0
				c.rgb = New rgb
				c\col = col 
				c\x = x
				c\y = y
			EndIf
		Next
	Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.soundoff
;shut off looping sounds
StopSound soundeyes
StopSound sounddeadly
StopSound soundblue
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.prizeon
If prizeseaten < numprizes 
	prizedir = prizedir + 1
	If prizedir > 8 Then prizedir = 0
	If prizedir = 1 And prize\x= cagex And prize\y= cagey+1
		; pop out of the cage
		prize\vx = prizespeed:If Rnd(1,10)>4 Then prize\vx=-prize\vx
		prize\vy = 0
		prize\sx = cagex * gdsz
		prize\sy = (cagey-1) * gdsz
		prize\bx = prize\sx * 32
		prize\by = prize\sy * 32
		prize\frm = board ; 0-100
		prize\points = prizepoints(board)
		prize\cage=0 
		prize\bouncedir = 1
		prize\bouncehgt = 0
	EndIf
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.moveprize
If prize\cage = 0
	; not in the cage
	If prize\x<1 Or prize\x>(mapwidth-2) Then prize\intunnel=-1
	If prize\y<1 Or prize\y>(mapheight-2) Then prize\intunnel=1
	If prize\intunnel=0
		If prize\vx<0 Or prize\vy<0
			prize\bx=prize\bx+prize\vx
			prize\by=prize\by+prize\vy
			prize\sx=(prize\bx / 32)
			prize\sy=(prize\by / 32)
			prize\x=prize\sx/gdsz
			prize\y=prize\sy/gdsz
			If map(prize\x,prize\y) < 52 ; crash ,change dir
				prize\bx=prize\bx-prize\vx
				prize\by=prize\by-prize\vy
				prize\x=prize\bx/(gdsz*32)
				prize\y=prize\by/(gdsz*32)
				pcngflg=10
			EndIf
		Else
			If prize\vy>0 ; moving down
				y=((prize\by/32)+gdsz)/gdsz
				x=prize\x
				If map(x,y) < 52
					pcngflg=10
				Else
					prize\by=prize\by+prize\vy
				EndIf
			Else ; prize\vx>0 moving right
				x =	((prize\bx/32)+gdsz)/gdsz
				y=prize\y
				If map(x,y) < 52
					pcngflg=10
				Else
					prize\bx=prize\bx+prize\vx
				EndIf
			EndIf
		EndIf
	Else
		; in tunnel
		If prize\intunnel=-1 
			; left right tunnel
			prize\bx=prize\bx+Sgn(prize\vx)*prizespeed 
			If prize\bx < 0 
				prize\bx = 32*(mapwidth-1)*gdsz
			ElseIf prize\bx > 32*(mapwidth-1)*gdsz
				prize\bx=0
			EndIf
			prize\sx=prize\bx/32
			prize\x=prize\sx/gdsz
			If prize\x>0 Or prize\x<=(mapwidth-2) Then prize\intunnel=0
		EndIf
		If prize\intunnel=1
			; up down tunnel
			prize\by=prize\by+Sgn(prize\vy)*prizespeed
			If prize\by < 0 
				prize\by = 32*(mapheight-1)*gdsz
			ElseIf prize\by > 32*(mapheight-1)*gdsz
				prize\by=0
			EndIf
			prize\sy=prize\by/32
			prize\y=prize\sy/gdsz
			If prize\y > 0 Or prize\y<=(mapheight-2) Then prize\intunnel=0
		EndIf
	EndIf
	prize\sx=prize\bx/32
	prize\sy=prize\by/32
	prize\x=prize\sx/gdsz
	prize\y=prize\sy/gdsz

	square=((prize\bx Mod (32*gdsz)) <33) And ((prize\by Mod (32*gdsz))<33)

	If square And Rnd(1,10) >6 And pcngflg=0 Then pcngflg = 10
	If pcngflg>0 Then pcngflg=pcngflg-1
	If pcngflg=9
		prize\sx=prize\x*gdsz
		prize\sy=prize\y*gdsz
		prize\bx=prize\sx*32
		prize\by=prize\sy*32
		Gosub changedirprize
	EndIf

	If square And prize\x=cagex And prize\y = cagey-1 And prizedir >1
		; go back in cage and wait
		prizedir = 8
		prize\cage=1
		prize\y=cagey+1
		prize\sy=prize\y*gdsz
	EndIf
	;\bouncehgt goes from 0 To -8 back to 0
	If prize\bouncehgt <= -16 Or prize\bouncehgt >=0 Then prize\bouncedir = -prize\bouncedir
	prize\bouncehgt = prize\bouncehgt + prize\bouncedir
	If prize\bouncehgt = 0 Then PlaySound soundbounce
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.changedirprize
pick2=-1:If Rnd(1,10) > 4 Then pick2=1
; select the destination according to the prizedir
Select (prizedir)
	Case 0
		; randon dir
		xdiff=1:ydiff=1
		If Rnd(1,10)>4 xdiff=-1
		If Rnd(1,10)>4 ydiff=-1
	Case 1
		; towards bottom right corner
		xdiff=1:ydiff=1
	Case 2
		; towards bottom left corner
		xdiff=-1:ydiff=1
	Case 3
		; towards top left corner
		xdiff=-1:ydiff=-1
	Case 4
		; towards top right corner
		xdiff=1:ydiff=-1
	Default ; 5,6,7,8
		; towards cage center
		xdiff=Sgn(cagex-prize\x):ydiff=Sgn((cagey+1)-prize\y)
End Select
Select mapopen(prize\x,prize\y)
	Case 0
		; how? you shouldn't be on this tile!
	Case 1;up
		prize\vy=-prizespeed:prize\vx=0
	Case 2;right
		prize\vx=prizespeed:prize\vy=0
	Case 4;down
		prize\vy=prizespeed:prize\vx=0
	Case 8;left
		prize\vx=-prizespeed:prize\vy=0
	Case 3
		If prize\vy>0 Then prize\vx=prizespeed:prize\vy=0 Else prize\vx=0:prize\vy=-prizespeed
	Case 5;u d
	Case 6;r d
		If prize\vy<0 Then prize\vx=prizespeed:prize\vy=0  Else prize\vx=0:prize\vy=prizespeed
	Case 10;l r
	Case 12;d l
		If prize\vy<0 Then prize\vx=-prizespeed:prize\vy=0 Else prize\vx=0:prize\vy=prizespeed
	Case 9;l u
		If prize\vy>0 Then prize\vx=-prizespeed:prize\vy=0 Else prize\vx=0:prize\vy=-prizespeed
	Case 7;urd
		If prize\vx<0;going r , turn u or d
			prize\vx=0:prize\vy=ydiff*prizespeed; up or d
			If prize\vy = 0 Then prize\vy=pick2*prizespeed
		Else
			If xdiff = 1 Then prize\vx=prizespeed:prize\vy=0; right
		EndIf
	Case 11
		If prize\vy>0
			prize\vy=0:prize\vx=xdiff*prizespeed; l or r
			If prize\vx = 0 Then prize\vx=pick2*prizespeed
		Else
			If ydiff = -1  Then prize\vy=-prizespeed:prize\vx=0; u
		EndIf
	Case 13
		If prize\vx>0
			prize\vx=0:prize\vy=ydiff*prizespeed  ;  up or down
			If prize\vy = 0 Then prize\vy=pick2*prizespeed
		Else
			If xdiff = -1 Then prize\vx=-prizespeed:prize\vy=0; l
		EndIf
	Case 14
		If prize\vy<0
			prize\vy=0:prize\vx=xdiff*prizespeed    ; l or r
			If prize\vx = 0 Then prize\vx=pick2*prizespeed
		Else
			If ydiff = 1 Then prize\vy=prizespeed:prize\vx=0; d
		EndIf
	Case 15
		If Rnd(1,10) > 4; keep going 40% of time
			If prize\vx = 0 ; going up or down
				If (Rnd(1,10) > 4 Or xdiff = 0) Then xdiff = pick2
				prize\vx = xdiff*prizespeed:prize\vy=0
			Else ; going l or r
				If (Rnd(1,10) > 4 Or ydiff = 0) Then ydiff = pick2
				prize\vy = ydiff*prizespeed:prize\vx=0
			EndIf
		EndIf
End Select
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.movepac
If slowdown > 0 Then slowmo=2 Else slowmo = 1 ;go half speed when digestimg
wdirx=0:wdiry=0
Select keyorjoy
	Case 0
		If KeyDown(203)=1 Then wdirx = -1
		If KeyDown(205)=1 Then wdirx = 1
		If KeyDown(200)=1 Then wdiry = -1
		If KeyDown(208)=1 Then wdiry = 1
	Case 1
		wdirx=JoyXDir():wdiry=JoyYDir()
End Select
square=((pac\sx Mod gdsz)=0) And ((pac\sy Mod gdsz)=0)
If square=True Or (pac\vx=0 And pac\vy=0)
	If wdirx=-1 And ((mapopen(pac\x,pac\y) And 8) = 8)
		pac\vx=-pspeed
		pac\vy=0
	EndIf
	If wdirx=1 And ((mapopen(pac\x,pac\y) And 2) = 2) 
		pac\vx=pspeed
		pac\vy=0
	EndIf
	If wdiry=-1 And ((mapopen(pac\x,pac\y) And 1) = 1)
		pac\vy=-pspeed
		pac\vx=0
	EndIf
	If wdiry=1 And ((mapopen(pac\x,pac\y) And 4) = 4)
		pac\vy=pspeed
		pac\vx=0
	EndIf
Else 
	If wdirx=-1 And pac\vx <>0
		pac\vx=-pspeed
		pac\vy=0
	EndIf
	If wdirx=1 And pac\vx <>0
		pac\vx=pspeed
		pac\vy=0
	EndIf
	If wdiry=-1 And pac\vy <>0
		pac\vy=-pspeed
		pac\vx=0
	EndIf
	If wdiry=1 And pac\vy <>0
		pac\vy=pspeed
		pac\vx=0
	EndIf
EndIf

If pac\intunnel=0
	If pac\x<1 Or pac\x>(mapwidth-2) Then pac\intunnel=-1
	If pac\y<1 Or pac\y>(mapheight-2) Then pac\intunnel=1

	If pac\vx<0 Or pac\vy<0
		pac\bx=pac\bx+(pac\vx/slowmo)
		pac\by=pac\by+(pac\vy/slowmo)
		pac\sx=pac\bx/32
		pac\sy=pac\by/32
		pac\x=pac\sx/gdsz
		pac\y=pac\sy/gdsz
		If map(pac\x,pac\y)<52 ; crash ,change dir
			pac\bx=pac\bx-pac\vx/slowmo
			pac\by=pac\by-pac\vy/slowmo
			pac\x=pac\bx/(gdsz*32)
			pac\y=pac\by/(gdsz*32)
			If pac\vy<0 Then pac\frm=8 Else pac\frm=5
			pac\vx=0:pac\vy=0
		EndIf
	Else
		;down or right
		If pac\vy>0
			;moving down
			y=((pac\by/32)+gdsz)/gdsz
			x=pac\x
			If map(x,y)<52  
				pac\vy=0:pac\vx=0
				pac\frm=11
			Else
				;pac\bx=pac\bx+(pac\vx/slowmo)
				pac\by=pac\by+(pac\vy/slowmo)
				;pac\sx=pac\bx/32
				pac\sy=pac\by/32
				;pac\x=pac\sx/gdsz
				pac\y=pac\sy/gdsz
			EndIf
		ElseIf pac\vx>0
			; vx > 0 - moving right
			x = ((pac\bx/32)+gdsz)/gdsz
			y=pac\y
			If map(x,y)<52
				pac\vy=0:pac\vx=0
				pac\frm=2
			Else
				pac\bx=pac\bx+(pac\vx/slowmo)
				;pac\by=pac\by+(pac\vy/slowmo)
				pac\sx=pac\bx/32
				;pac\sy=pac\by/32
				pac\x=pac\sx/gdsz
				;pac\y=pac\sy/gdsz
			EndIf
		EndIf
	EndIf

Else 
	; in tunnel
	If pac\intunnel=-1
		;left right tunnel
		pac\bx=pac\bx+Sgn(pac\vx)*ptspeed
		If pac\bx < 0 
			pac\bx = 32*(mapwidth-1)*gdsz
		Else 
			If pac\bx > 32*(mapwidth-1)*gdsz Then pac\bx = 0
		EndIf
		pac\sx=pac\bx/32
		pac\x=pac\sx/gdsz
		If pac\bx>0 And pac\x<=(mapwidth-2) Then pac\intunnel=0
	EndIf
	If pac\intunnel=1
		; up down tunnel
		pac\by=pac\by+Sgn(pac\vy)*ptspeed
		If pac\by < 0 
			pac\by = 32*(mapheight-1)*gdsz
		Else 
			If pac\by > 32*(mapheight-1)*gdsz Then pac\by = 0
		EndIf
		pac\sy=pac\by/32
		pac\y=pac\sy/gdsz
		If pac\by>0 And pac\y<=(mapheight-2) Then pac\intunnel=0
	EndIf
EndIf

pac\sx=pac\bx/32
pac\cx=Int((((pac\bx+(pac\vx*2))/32)+4)/gdsz)
pac\sy=pac\by/32
pac\cy=Int((((pac\by+(pac\vy*2))/32)+4)/gdsz)
pac\x=pac\sx/gdsz
pac\y=pac\sy/gdsz

char= map(pac\cx,pac\cy)
gobble = 0
If Not(char = 255) And char>51 Then gobble = 1

If pac\vx>0 Then pac\frm=0+2
If pac\vx<0 Then pac\frm=3+2
If pac\vy<0 Then pac\frm=6+2
If pac\vy>0 Then pac\frm=9+2

If pac\vx <>0 Or pac\vy <>0
	;images are rrrllluuuddd
	pac\frmcnt=pac\frmcnt+2:If pac\frmcnt > 63 Then pac\frmcnt=0
	sc=Int(pac\frmcnt/16)
	Select sc
		Case 0
			pac\frm=pac\frm-1
		Case 1
			pac\frm=pac\frm-2
		Case 2
			pac\frm=pac\frm-1
		Case 3
			pac\frm=pac\frm
	End Select
End If
Return
;--------------------------------------------------------------------------------------




;--------------------------------------------------------------------------------------
.moveghosts
For g.ghost=Each ghost
	If (g\act = eyes) Or (pass = 0 )

		;enter the cage?
		If g\act=eyes And g\y=cagey-1 And g\x=cagex
			If ((g\sx Mod gdsz)=0) And g\cage=0
				StopSound soundeyes
				g\vx=0:g\vy=10   ;gspeed
				g\cage=1
			EndIf
		EndIf
	
		;exit cage ?
		If g\act<>eyes And g\y-1=cagey And g\x=cagex
			g\cagetimer = g\cagetimer-1
			If ((g\sx Mod gdsz)=0) And ( g\cagetimer <0)
				g\vx=0:g\vy=-g\gspeed
				g\cage=-1
				If Not SoundPlaying(sounddeadly) Then LoopSound sounddeadly
			EndIf
		EndIf

		;if not in cage - move
		If g\cage=0
			If g\x<1 Or g\x>(mapwidth-2) Then g\intunnel=-1
			If g\y<1 Or g\y>(mapheight-2) Then g\intunnel=1
			
			; not in tunnel
			If g\intunnel=0
			
				If g\vx<0 Or g\vy<0
					; moving up or left
					If g\act=eyes
						If g\vx<0 Then g\vx=-eyespeed Else g\vy=-eyespeed
					ElseIf g\act=edible
						If g\vx<0 Then g\vx=-edspeed Else g\vy=-edspeed
					EndIf
		
					g\bx=g\bx + g\vx  ; 0 - 32*mapwidth*gdsz
					g\by=g\by + g\vy  ; 0 - 32*mapheight*gdsz
					g\sx=g\bx/32
					g\sy=g\by/32
					g\x=g\sx/gdsz
					g\y=g\sy/gdsz
					If map(g\x,g\y)<52 ; crash ,change dir
						g\bx=g\bx - g\vx  ; 0 - 32*mapwidth*gdsz
						g\by=g\by - g\vy  ; 0 - 32*mapheight*gdsz
						g\x=g\bx/(gdsz*32)
						g\y=g\by/(gdsz*32)
						Gosub changedirg
						g\changed=10
						g\bx=g\bx + g\vx  ;0-32*mapwidth*gdsz
						g\by=g\by + g\vy  ;0-32*mapheight*gdsz
					EndIf
				Else
					If g\vy>0
						; moving down
						If g\act=eyes Then g\vy=eyespeed Else If g\act=edible Then g\vy=edspeed
						tsy=g\sy+gdsz
						y=tsy/gdsz
						x=g\x
						If map(x,y)<52
							Gosub changedirg  ; crash ,change dir
							g\changed=10
						EndIf
						g\bx=g\bx + g\vx  ;0-32*mapwidth*gdsz
						g\by=g\by + g\vy  ;0-32*mapheight*gdsz
					Else 
						; \vx>0 - moving right
						If g\act=eyes Then g\vx=eyespeed Else If g\act=edible Then g\vx=edspeed
						tsx=g\sx + gdsz
						x=tsx/gdsz
						y=g\y
						If map(x,y)<52
							Gosub changedirg ; crash ,change dir
							g\changed=10
						EndIf
						g\bx=g\bx + g\vx ;0-32*mapwidth*gdsz
						g\by=g\by + g\vy ;0-32*mapheight*gdsz
					EndIf
				EndIf
				g\sx=g\bx/32
				g\sy=g\by/32
				g\x=g\sx/gdsz
				g\y=g\sy/gdsz
		
				g\changed=g\changed-1
				If Not (g\changed > 0)
					If (( (g\sx) Mod (gdsz) ) =0) And (((g\sy) Mod (gdsz))=0)
						Select g\act
							Case deadly  ; 2
								If Rnd(10)  > 4 ; 50% of time change dir
									Gosub changedirg
									g\changed=5; don't change again until 10 steps away
				    			EndIf
							Case edible  ; 1
								If Rnd(10)  > 7 ; blue is dumb, don't change as much
									Gosub changedirg
									g\changed=5; don't change again until 10 steps away
				    			EndIf
							Case eyes    ; 3
								If Rnd(10)  > 2 ; eyes head home quickly
									Gosub changedirg
									g\changed=5; don't change again until 10 steps away
				    			EndIf
						End Select
					EndIf
				EndIf
			Else 
				; intunnel<>0
				If  g\intunnel=-1
					; left right
					g\bx=g\bx + Sgn(g\vx)*gtspeed 
					If g\bx < 0 
						g\bx = 32*(mapwidth-1)*gdsz
					ElseIf g\bx > 32*(mapwidth-1)*gdsz
						g\bx = 0
					EndIf
					g\sx=g\bx/32
					g\x=g\sx/gdsz
					If g\x>0 And g\x<=(mapwidth-2) Then g\intunnel=0
				EndIf
				If g\intunnel=1
					; up down
					g\by=g\by + Sgn(g\vy)*gtspeed 
					If g\by < 0 
						g\by = 32*(mapheight-1)*gdsz
					ElseIf g\by > 32*(mapheight-1)*gdsz 
						g\by = 0
					EndIf
					g\sy=g\by/32
					g\y=g\sy/gdsz
					If g\y>0 And g\y<=(mapheight-2) Then g\intunnel=0
				EndIf
			EndIf
		Else
			; inside cage stuff
			g\by=g\by + Sgn(g\vy)*8 ; move slowly in/out
			g\sy=g\by/32
			g\y=g\sy/gdsz
			If g\y<(cagey-1) Or g\y>cagey
				If g\cage=1
					g\act=deadly
					g\cagetimer = 20+g\id*(20-board/5)
					g\by=(cagey+1)*gdsz*32
					g\vy=0
					g\vx=g\gspeed
				Else
					g\by=(cagey-1)*gdsz*32
				EndIf
		  		g\cage=0
			EndIf
		EndIf
		
		; select anim frame
		;images are:	rrlluudd - red   
		;then		rrlluudd - pink  
		;then		rrlluudd - cyan 
		;then		rrlluudd - orange
		;then		rrlluudd - green
		;then		rrlluudd - yellow		
		;then		bbwwee
						
		g\frmcnt=g\frmcnt+1:If g\frmcnt>63 Then g\frmcnt=0

		If g\vy>0 Then g\frm=6+g\id*8
		If g\vy<0 Then g\frm=4+g\id*8
		If g\vx>0 Then g\frm=0+g\id*8
		If g\vx<0 Then g\frm=2+g\id*8
		
		If g\bluetimer > 0 Then g\bluetimer = g\bluetimer-1
		If g\act=edible
			If g\bluetimer = 0
				g\act = deadly
				g\vx = Sgn(g\vx) * g\gspeed
				g\vy = Sgn(g\vy) * g\gspeed
				StopSound soundblue
				LoopSound sounddeadly
			Else
				g\frm = frmgb   ; blue  32,33
				If g\bluetimer<160
					If (g\frmcnt And 4)=4 Then g\frm = frmgw ; white 34,35
				Else
					If g\bluetimer<360
						If (g\frmcnt And 32)=32 Then g\frm = frmgw ; white 34,35
					EndIf
				EndIf
			EndIf
		EndIf
		
		If g\frmcnt > 30 Then g\frm = g\frm+1
		
		If g\act=eyes
			g\frm= frmge ; eyes 36,37
			If (g\frmcnt And 16)=16 Then g\frm = g\frm + 1 ; blink
		EndIf
	EndIf
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.changedirg
xdiff=Sgn(pac\x-g\x)
ydiff=Sgn(pac\y-g\y)
t=g\id
;if pink,ink, or sue head towards prize 20% of time
If t > 3 And Rnd(15) > 11
	xdiff=Sgn(prize\x-g\x):ydiff=Sgn(prize\y-g\y)
EndIf

; if eyes, head towards cage
If g\act=eyes
	xdiff=Sgn(cagex-g\x):ydiff=Sgn((cagey-1)-g\y)
EndIf

; if blue then head away from pac
If g\act=edible Then xdiff=-xdiff:ydiff=-ydiff

pick2=-1:If Rnd(10)>4 Then pick2=1

Select mapopen(g\x,g\y)
	Case 0
		; how? you shouldn't be on this tile!
	Case 1
		; up
		g\vy=-g\gspeed:g\vx=0
	Case 2
		; right
		g\vx=g\gspeed:g\vy=0
	Case 4
		; down
		g\vy=g\gspeed:g\vx=0
	Case 8
		; left
		g\vx=-g\gspeed:g\vy=0
	Case 3
		; up or right
		If g\vy>0 Then g\vx=g\gspeed:g\vy=0 Else g\vx=0:g\vy=-g\gspeed
	Case 5
		; ghosts don't reverse on their own
		; up OR down
		; If Rnd > .95
		;  \vx=0:\vy=ydiff*\gspeed
		; EndIf
	Case 6
		; right or down
		If g\vy<0 Then g\vx=g\gspeed:g\vy=0 Else g\vx=0:g\vy=g\gspeed
	Case 10
		; right or left
 		If g\vy < 0  ; getting out of cage only
			g\vx=xdiff*g\gspeed:g\vy=0
			If g\vx=0 Then g\vx = g\gspeed
		EndIf
	Case 12
		; down or left
		If g\vy<0 Then g\vx=-g\gspeed:g\vy=0 Else g\vx=0:g\vy=g\gspeed
	Case 9
		; up or left
		If g\vy>0 Then g\vx=-g\gspeed:g\vy=0 Else g\vx=0:g\vy=-g\gspeed
	Case 7
		; up right down
		If g\vx<0
			; moving left hit wall, go u or d
			g\vx=0:g\vy=ydiff*g\gspeed; up or d
			If g\vy = 0 Then g\vy=pick2*g\gspeed
		Else
			; else cont up or down, or turn right
			If xdiff = 1 Then g\vx=g\gspeed:g\vy=0; right
		EndIf
	Case 11
		; up left right
		If g\vy>0
			; moving d hit wall, go l or r
			g\vy=0:g\vx=xdiff*g\gspeed; l or r
			If g\vx = 0 Then g\vx=pick2*g\gspeed
		Else
			; else moving l or r, cont or turn u
			If ydiff = -1 Then g\vy=-g\gspeed:g\vx=0; u
		EndIf
	Case 13
		; up left down
		If g\vx>0
			; moving r hit wall, go u or d
			g\vx=0:g\vy=ydiff*g\gspeed  ;  up or down
			If g\vy = 0 Then g\vy=pick2*g\gspeed
		Else
			; else moving up or down, cont or turn l
			If xdiff = -1 Then g\vx=-g\gspeed:g\vy=0; l
		EndIf
	Case 14
		; down left right
		If g\vy<0
			; moving u hit wall, go l or r
			g\vy=0:g\vx=xdiff*g\gspeed    ; l or r
			If g\vx = 0 Then g\vx=pick2*g\gspeed
		Else
			; else moving l or r, cont or turn d
			If ydiff = 1 Then g\vy=g\gspeed:g\vx=0; d
		EndIf
	Case 15
		; up right down or left open
		If g\vx = 0 ; going up or down
			If (Rnd(10) > 4 Or xdiff = 0) Then xdiff = pick2
			g\vx = xdiff*g\gspeed:g\vy=0
		Else ; going l or r
			If (Rnd(10) > 4 Or ydiff = 0) Then ydiff = pick2
			g\vy = ydiff*g\gspeed:g\vx=0
		EndIf
End Select
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.reverse
For g.ghost=Each ghost
	If g\act = deadly
		If g\vy <> 0 And g\cage=0 Then g\vy=-g\vy
		If g\vx <> 0 Then g\vx=-g\vx
	EndIf
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.turnblue
For g.ghost=Each ghost
	If g\act<>eyes
		;change direction if not blue
		If g\act<>edible
 			If g\vy <> 0 And g\cage=0 Then g\vy=-g\vy
			If g\vx <> 0 Then g\vx=-g\vx
		End If
		g\bluetimer = 1000-board*10
		g\frm=36
		g\act=edible
		If SoundPlaying(sounddeadly) Then StopSound sounddeadly
		If SoundPlaying(soundeyes) Then StopSound soundeyes
		If Not SoundPlaying(soundblue) Then LoopSound soundblue
	EndIf
Next
killed=0
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawghosts
For g.ghost=Each ghost
	DrawImage ghostimages,g\sx+XOFF,g\sy,g\frm
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawpac
If pac\sx > 4 And pac\sx < (mapwidth-1)*gdsz-4
	DrawImage pacimages,pac\sx+XOFF,pac\sy,pac\frm
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawpoints
For pts.pointstype=Each pointstype
	If pts\v > 0
		pts\v=pts\v-1
		DrawImage pointimages,pts\x+XOFF,pts\y,pts\frm
		If pts\v = 0 Then Delete pts
	EndIf
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawprize
If prize\cage = 0
	prizey=prize\sy+prize\bouncehgt/2+2:If prizey<0 Then prizey = 0
	DrawImage prizeimages,prize\sx+XOFF,prizey,prize\frm
Else
	;draw it in the cage
	DrawImage prizeimages,prize\sx+XOFF,prize\sy,prize\frm
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawpacsleft
t = 1
While ((t < 6) And (t < pacmen) )
   DrawImage pacimages,t*14+XOFF,gdsz*mapheight
   t = t + 1
Wend
;draw prize/board number
For t = 0 To 3
	If board+t-3 >= 0
		If board < 4 Then xofft = board Else xofft = 3
		DrawImage prizeimages,264-(xofft+t)*17+XOFF,gdsz*mapheight,t+board-3
	EndIf
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawscore
If score>=freeman*bonuscount
    PlaySound soundbonus
    bonuscount=bonuscount+1
    pacmen=pacmen+1
EndIf
If score > 999999 Then score = score - 999999:bonuscount=1

DrawImage numberimages,gdsz*13+10+XOFF,gdsz*mapheight,30+0 ; 0
score1=score /10
DrawImage numberimages,gdsz*12+8+XOFF,gdsz*mapheight, 30+(score1 - Int(score1/10)*10) ; 10s
score1=score1 /10
DrawImage numberimages,gdsz*11+6+XOFF,gdsz*mapheight, 30+(score1 - Int(score1/10)*10) ; 100s
score1=score1 /10
DrawImage numberimages,gdsz*10+4+XOFF,gdsz*mapheight, 30+(score1 - Int(score1/10)*10) ; 1 000s
score1=score1 /10
DrawImage numberimages,gdsz*9+2+XOFF,gdsz*mapheight, 30+(score1 - Int(score1/10)*10) ; 10 000s
score1=score1 /10
DrawImage numberimages,gdsz*8+XOFF,gdsz*mapheight, 30+(score1 - Int(score1/10)*10) ; 100 000s
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawzoom
DrawImage zoomimage,40+XOFF,0
Color 255,255,0
Rect 66+XOFF,1,exspeed,4
Color 255,0,0
Rect 65+XOFF,0,MAXEXSPEED+2,6,0
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawgetready
DrawImage getreadyimage,gdsz*cagex-8+XOFF,gdsz*(cagey+3)
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawgameover
DrawImage gameoverimage,gdsz*cagex-8+XOFF,gdsz*(cagey+3)
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawpause
For t = 0 To 10
	DrawImage pauseimage,gdsz*Rnd(2,mapwidth-4)+XOFF,gdsz*Rnd(2,mapheight-3)
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.checkcollisions
;check collisons with ghosts
sx=pac\sx
sy=pac\sy
For g.ghost=Each ghost
	Select g\act
		Case eyes
			; do nothing
		Case edible
			If Abs(sx-g\sx)<7 And Abs(sy-g\sy)<7
				;collision between pac and ghost t
				PlaySound soundghost
				StopSound soundblue
				LoopSound soundeyes
				g\act=eyes
				killed=killed+1
				score=score+200*(2^(killed-1))
				pts = New pointstype
				pts\v=pointtime
				pts\x=g\x*gdsz
				pts\y=g\y*gdsz
				pts\frm=killed+99
			End If
		Case deadly 
			If Abs(sx-g\sx)<4 And Abs(sy-g\sy)<4
				;collision between pac and ghost t
				If invincible = 0 Then gmode = dyingmode
			End If
	End Select
Next
;check collision with prize
If prize\cage = 0
	; check if pac and prize overlap
	; if so eat prize
	If RectsOverlap(sx+5,sy+5,6,6,prize\sx+5,prize\sy+5,6,6 )
		PlaySound soundprize
		score=score+prizepoints(board)
		prizeseaten = prizeseaten+1
		pts = New pointstype
		pts\v=pointtime
		pts\x=prize\sx
		pts\y=prize\sy
		pts\frm=prizepoints(board)/100-1
		; move back to cage
		prize\cage = 1
		prizedir = 8
		prize\y=cagey+1
		prize\x=cagex
		prize\sy=prize\y*gdsz
		prize\sx=prize\x*gdsz
		exspeed = exspeed + PRIZEEXSPEED
		If exspeed > MAXEXSPEED Then exspeed = MAXEXSPEED
	EndIf
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.gobble
x= pac\cx
y= pac\cy
If gobble=1
	munched=munched+1
	slowdown = 3
	If map(x,y)=53
		; power pellet
		PlaySound soundpower
		score=score+50
		Gosub turnblue
	ElseIf map(x,y)=52   
		; dot
		PlaySound sounddot
		score=score+10
	EndIf
	map(x,y)=255
EndIf
If munched=pillstotal
	gmode = donemode
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.boardclear
Gosub soundoff
Delay 300
PlaySound soundboarddone
Delay 100
For ft = 0 To 8
	If Int(ft/2)*2 = ft
		Gosub drawmap
	Else
		Cls
	EndIf
	Gosub drawpacsleft
	Gosub drawzoom
	Gosub drawscore
	Flip
	Delay 150
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.death
Gosub soundoff
PlaySound sounddeath
For pts.pointstype=Each pointstype
	Delete pts
Next
;animate the death
For ft = 0 To 3
	pac\frm = 12+ft
	Gosub drawmap
	Gosub drawpac
	Gosub drawscore
	Gosub drawzoom
	Gosub drawpacsleft
	Flip
	Delay 300
Next
;one less pacman
pacmen=pacmen-1
If restorezoom = 1
   exspeed = MAXEXSPEED
End If
Gosub drawmap
Gosub drawscore
Gosub drawzoom
Gosub drawpacsleft
Flip
Delay 300
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.loadmaps
fh = OpenFile("maps/allmaps.bin")
For m = 0 To numbrds-1
	For y=0 To mapheight
		chars$ = ReadLine(fh)
		For x=0 To mapwidth
			ch = Asc(Mid(chars$,x+1,1)) - 32
        		maps(x,y,m) = ch ; read in all the chars
		Next
	Next
Next
CloseFile fh
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.setupmap
; put 255s in the far right and bottom 
; array pos for the openmap() array
For x=0 To mapwidth
	map(x,mapheight)=255
Next
For y=0 To mapheight
	map(mapwidth,y)=255
Next
; copy map from the maps()
For x=0 To mapwidth-1
	For y=0 To mapheight-1
		character = maps(x,y,board)
		If (character=52) Or (character=53)
			pillstotal=pillstotal+1
		EndIf
		If character=0 Then character=255
		map(x,y) = character
	Next
Next
;create the mapopen array
For x=1 To mapwidth-2
	For y=1 To mapheight-2
		opu = 0:If (map(x,y-1)>51) Then opu =1 ; above open
		opd = 0:If (map(x,y+1)>51) Then opd =4 ; below open
		opl = 0:If (map(x-1,y)>51) Then opl =8 ; left open
		opr = 0:If (map(x+1,y)>51) Then opr =2 ; right open
		mapopen (x,y) = opu+opd+opl+opr ; 0,1,2,3,4...15
	Next
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.drawmap
Cls
If Rnd(30)>25 Then shinv = 1 Else shinv = 0
;Rect 0,0,320,240,0
For y = 0 To mapheight-1
	For x = 0 To mapwidth-1
		character = map(x,y)
		Select character
		Case 51
			If shinv = 1 Then DrawImage blockimages,x*gdsz+XOFF,y*gdsz,2
		Case 53
			; powerpill flashes on/off
			If flashpill = 1 Then DrawImage blockimages,x*gdsz+XOFF,y*gdsz,character
		Case 255
			; do nothing
		Default
			DrawImage blockimages,x*gdsz+XOFF,y*gdsz,character
   		End Select
	Next
Next
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.colorcycle
col=col+1
If col = 9
	col = 0
	Color 255,255,255
EndIf
If col = 1
	Color 255,0,0
EndIf
Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.credits
pac\sx=320:pac\sy=200
Createghosts(5)
For g.ghost=Each ghost
	g\sx=320:g\sy=200:g\frm=39
Next
Cls
; grab the ghost colors for printing their names
For t = 0 To 5
	DrawImage ghostimages,0,t*16,t*8
	GetColor 7,t*16+1
	gkol(t,0) = ColorRed()
	gkol(t,1) = ColorGreen()
	gkol(t,2) = ColorBlue()
Next
Cls

ctmr =0:If highscore>0 Then	ctmr=600 
timer = 0
resetcmtr=1200

While (Not (KeyHit(62) Or KeyHit(1)))  ; f4 (62) to start, ESC (1) to quit
Cls

DrawImage mspacimage,123,26
Color 240,240,180
Locate 96,40:Print" Mark Incitti  "
Locate 96,52:Print"  BlitzBasic   "
Locate 96,64:Print"     2000      "

col = timer
Color 255,0,0
For t = 0 To 18
	Gosub colorcycle
	Locate 90+t*7,9:Print"."
Next
For t = 1 To 8
	Gosub colorcycle
	Locate 216,t*7+8:Print"."
Next
For t = 18 To 0 Step -1
	Gosub colorcycle
	Locate 90+t*7,70:Print"."
Next 
For t = 8 To 1 Step -1
	Gosub colorcycle
	Locate 90,t*7+8:Print"."
Next
timer=timer+1:If timer > 8 Then timer = 0


; move g onto screen
If ctmr < 6
	For g.ghost=Each ghost
		If g\id = ctmr
			g\sx = g\sx - 2
			g\frmcnt = g\frmcnt + 4:If g\frmcnt >63 Then g\frmcnt = 0
			g\frm = g\id*8 + 2 + g\frmcnt/32 ; left
			If g\sx < 90
				g\sx = 90
				g\sy = g\sy - 2
	 			g\frm =  g\id*8 + 4 + g\frmcnt/32 ; up
				If g\sy < 90 + ctmr*16
		    	    g\sy = 90+ctmr*16
					g\frm =  g\id*8 + 6 ; down
					ctmr = ctmr+1
			 	EndIf
			EndIf
		EndIf
	Next
EndIf

If ctmr > 5 Then ctmr=ctmr+1

Color 240,50,50
If ctmr > 0 And ctmr <600
	Color gkol(0,0),gkol(0,1),gkol(0,2)
	Locate 130,90:Print "Blinky"
EndIf
If ctmr > 1 And ctmr <600
	Color gkol(1,0),gkol(1,1),gkol(1,2)
	Locate 130,106:Print "Pinky"
EndIf
If ctmr > 2 And ctmr <600
	Color gkol(2,0),gkol(2,1),gkol(2,2)
	Locate 130,122:Print "Inky"
EndIf
If ctmr > 3 And ctmr <600
	Color gkol(3,0),gkol(3,1),gkol(3,2)
	Locate 130,138:Print "Sue"
EndIf
If ctmr > 4 And ctmr <600
	Color gkol(4,0),gkol(4,1),gkol(4,2)
	Locate 130,154:Print "Winky"
EndIf
If ctmr > 5 And ctmr <600
	Color gkol(5,0),gkol(5,1),gkol(5,2)
	Locate 130,170:Print "Clyde"
EndIf

If ctmr > 198 + 205 And ctmr <600
	Color 255,255,0
	Locate 130,200:Print"Ms BlitzMan"
EndIf

If ctmr = 198 + 15
	For g.ghost=Each ghost
		g\frm = g\id*8 + 0 ;gstrchar
  	Next
EndIf
If ctmr = 198 + 100
	For g.ghost=Each ghost
		g\frm = g\id*8 + 6 ;gstdchar
  	Next
EndIf
If ctmr = 198 + 120
	For g.ghost=Each ghost
		g\frm = g\id*8 + 2 ;gstlchar
  	Next
EndIf
If ctmr = 198 + 196
	For g.ghost=Each ghost
		g\frm = g\id*8 + 6 ;gstdchar
  	Next
EndIf

If ctmr > 198 And ctmr < 198 + 204
	If ctmr < 198 + 160
		pac\sx=pac\sx-2
		pac\frm=5
	Else
		pac\sx = pac\sx+2
		pac\frm=2
	EndIf
	pac\frmcnt=pac\frmcnt+4:If pac\frmcnt > 63 Then pac\frmcnt=0
	sc=Int(pac\frmcnt/16)
	Select sc
		Case 0
			pac\frm=pac\frm-1
		Case 1
			pac\frm=pac\frm-2
		Case 2
			pac\frm=pac\frm-1
		Case 3
			pac\frm=pac\frm
	End Select
EndIf

If ctmr < 600
	For g.ghost=Each ghost
		If ctmr >= g\id 
			DrawImage ghostimages,g\sx,g\sy,g\frm
		EndIf
	Next
EndIf
If ctmr < 600 And ctmr > 198 Then DrawImage pacimages,pac\sx,pac\sy,pac\frm
 
If ctmr > 600 And ctmr < 850
	If (highscore > 0)
		Color 200,200,200
		Locate 80,120:Print "    High Score     "
		skol = Int(Rnd(0,3))*10 ; random digit color
		score = highscore
		DrawImage numberimages,180,140, skol ; 0 
		score1=score /10
		DrawImage numberimages,168,140, skol+(score1 - Int(score1/10)*10) ; 10s
		score1=score1 /10
		DrawImage numberimages,156,140, skol+(score1 - Int(score1/10)*10) ; 100s
		score1=score1 /10
		DrawImage numberimages,144,140, skol+(score1 - Int(score1/10)*10) ; 1 000s
		score1=score1 /10
		DrawImage numberimages,132,140, skol+(score1 - Int(score1/10)*10) ; 10 000s
		score1=score1 /10
		DrawImage numberimages,120,140, skol+(score1 - Int(score1/10)*10) ; 100 000s
	Else
		ctmr = 850
	EndIf
EndIf

If ctmr < 850
	For key = 59 To 63
		If KeyDown(key) Then ctmr = 850
	Next
EndIf

If ctmr > 849
	Color 180,240,180
	Locate 50,120:Print "F1: Starting Level - ":DrawImage prizeimages,238,120,startinglevel
	control$ = "F2: Control Type - "
	If keyorjoy = 0 
		control$ = control$ + "Keyboard"
	Else
		control$ = control$ + "Joystick"
	EndIf
	Locate 50,140:Print control$
	difficulty$ = "F3: Skill Level - "
	Select sklevel
		Case 0
			difficulty$ = difficulty$ + "Easy"
		Case 1
			difficulty$ = difficulty$ + "Normal"
		Case 2
			difficulty$ = difficulty$ + "Medium"
		Case 3
			difficulty$ = difficulty$ + "Hard"
		Case 4
			difficulty$ = difficulty$ + "Hard++"
	End Select
	Locate 50,160:Print difficulty$
	Locate 50,180:Print "F4: Start Game"

	Locate 50,210:Print "F5: Help"

	If KeyHit(59) Then ctmr=850:startinglevel = startinglevel + 1: If startinglevel > lastboard Then startinglevel = 0
	If KeyHit(60) Then ctmr=850:keyorjoy = keyorjoy + 1: If keyorjoy > 1 Then keyorjoy = 0
	If KeyHit(61) 
		ctmr=850
		sklevel = sklevel + 1
		If sklevel > 4 Then sklevel = 0
	EndIf
	If KeyHit(63)
		ctmr = 850
		Gosub helpscreen
	EndIf
End If


If ctmr > resetcmtr
	ctmr = 0
	pac\sx=320:pac\sy=200
	For g.ghost=Each ghost
		g\sx=320:g\sy=200:g\frm=39
	Next
EndIf

Flip
Wend

If KeyDown(1) Then End

Return
;--------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------
.helpscreen
Cls
Flip
Cls
Color 250,20,0
Locate 50,5:Print  "     Ms Blitzman Help"
Color 250,100,0
Locate 50,30:Print  "  Keyboard Controls:"
Color 250,200,0
Locate 50,50:Print "    Cursor Keys L/R/U/D"
Color 200,250,0
Locate 50,70:Print "    SPACEBAR for Zoom"
Color 100,250,0
Locate 50,100:Print "  Joystick Controls:"
Color  20,250,0
Locate 50,120:Print "        L/R/U/D"
Color  20,250,100
Locate 50,140:Print "   Fire Button for Zoom"
Color  20,250,200
Locate 50,160:Print "   ESC to Quit Playing"
Color  20,200,250
Locate 50,180:Print "Eat Prizes For Zoom Power"
Color  20,100,250
Locate 50,200:Print "    Hit F5 to Return"
Flip
While Not KeyHit(63)
Wend
Return
;--------------------------------------------------------------------------------------