;-------------------------------------------------------------
; Simple ASTAR DEMO
; by Aaron Koolen
;
; Feel free to use this code for whatever purposes you want
;
;
; Optimisations To be done:
;
; Faster replacement when an object needs it's key changing.
; At present it simply removes it and adds it again
;
;
; Do a global search for NOTE: to find places of importance
; for using the libraries in your own code
;-------------------------------------------------------------
Graphics 640,480

;------------------------------------------------
; NOTE: Here are the 2 libraries you must include
;------------------------------------------------
Include "pqueuelib.bb"
Include "astarlib.bb"

AS_Initialise()				; You must do this. It clears the priority queues,

;-------------------------------------------------------------
; NOTE: This ASTAR algorithm can draw as it searches. These fields must be defined to support this.
; Feel free to remove them, and associated code from the astarlib file
;-------------------------------------------------------------
Const BLOCK_SIZE = 20				; Size of the squares to draw
Global SLOWMO = 0					; If on will delay as it finds the path
Const DRAW_NODES = 1				; If on will draw nodes as it searches
Global SHOW_COSTS = 0				; if on will show the node costs (cost above, f (cost + heuristic) below)
Global DIST_CALC_METHOD = 0			; The method used to calculate the heuristic distance
									; 0 - Euclidean distance
									; 1 - Euclidean estimation
									; 2 - Manhattan abs(dx)+abs(dy)
									; 3 - Max dx,dy
;-------------------------------------------------------------

; Our stuff to show a nice name for the type of distance calculation formula we will use
Const MAX_DIST_CALC_METHODS = 4								
Dim distName$(MAX_DIST_CALC_METHODS)
distName(0) = "Euclidean - Sqr(dx*dx + dy*dy)"
distName(1) = "Rough Euclidean - dx*dx + dy*dy"
distName(2) = "Manhattan Abs(dx)+Abs(dy)"
distName(3) = "Max d - Max(dx,dy)"

fn = LoadFont("arial",12)
SetFont fn

;-------------------------------------------------------------
; Editor stuff
;-------------------------------------------------------------
Type Block
	Field r,g,b
End Type
Const MAX_BLOCKS = 10
Dim block.Block(MAX_BLOCKS)

Const MAP_WIDTH = 20
Const MAP_HEIGHT = 20
Const BLOCK_IMPASS = MAX_BLOCKS - 1
Const BLOCK_START = MAX_BLOCKS - 3
Const BLOCK_END = MAX_BLOCKS - 2
Dim map(MAP_WIDTH,MAP_HEIGHT)


;-------------------------------------------------------------
; MAP Stuff
Const MP_MAX_NODES = 32*32
Const MP_MAX_WIDTH = 32
Const MP_MAX_HEIGHT = 32

; Multiplier to make different blocks different costs
;
; NOTE this value, and costs in general are very closely tied with the heuristic algorithm.
; If your costs for edges is too small, so that the heuristic is much greater than your costs,
; then your costs will have little effect on it and you may find that obstacles and things with high
; costs don't matter and a path gets found straight through them.
Const COST_MULT = 3
Const MP_COST_IMPASS = COST_MULT*BLOCK_IMPASS+1

Global MP_width,MP_height

Dim MP_Map.PQ_Node(MP_MAX_WIDTH,MP_MAX_HEIGHT)			; My map is a grid of PQ_Nodes
Dim MP_xoff(8),MP_yoff(8)								; Just some directions used for finding neighbours


;-------------------------------------------------------------

	InitBlocks()

	going = 1
	Global curBlock = 1
	Global startX = 0
	Global startY = 0
	Global endX = 0
	Global endY = 0
	Global level = 0
	Global heuristic = 1			; heuristic multiplier
	drawCount = 2
	
	DrawHelp()
	Flip
	DrawHelp()
	While going
		VWait
		Flip
		oldbx = bx
		oldby = by
		x = MouseX()
		y = MouseY()
		bx = x / BLOCK_SIZE
		by = y / BLOCK_SIZE
		If bx < 0 Then bx = 0
		If by < 0 Then by = 0
		If bx >= MAP_WIDTH Then bx = MAP_WIDTH -1
		If by >= MAP_HEIGHT Then by = MAP_HEIGHT -1
		
		If oldbx <> bx Or oldby <> by Then	drawCount = 2
		If drawCount > 0 Then 
			drawCount = drawCount - 1
			DrawMap()
		EndIf
		Color 255,255,255
		Rect bx * BLOCK_SIZE, by * BLOCK_SIZE, BLOCK_SIZE-1,BLOCK_SIZE-1
		If KeyDown(1) Then going = 0
		If MouseDown(1) Then
			doIt = 1
			
			If bx = startX And by = startY Then
					map(startX,startY) = 0
					startX = -1
					startY = 0
			EndIf
			If bx = endX And by = endY Then
					map(endX,endY) = 0
					endX = -1
					endY = 0
			EndIf
			
			If curBlock = BLOCK_START
				If startX <> -1 Then 
					map(startX,startY) = 0
				EndIf
				startX = bx
				startY = by
			EndIf
			If curBlock = BLOCK_END
				If endX <> -1 Then 
					map(endX,endY) = 0
				EndIf
				endX = bx
				endY = by
			EndIf
			
			If doIt Then 
				map(bx,by) = curBlock		
			EndIf
		EndIf
		k = GetKey()
		If k = Asc("s") Then SaveLevel()
		If k = Asc("l") Then 
			LoadLevel()
			drawCount = 2
		EndIf
		
		If k = Asc("-") Then
			level = level -1
			If level < 0 Then level = 0
			drawCount = 2
		EndIf
		If k = Asc("=") Then
			level = level + 1
			If level > 99 Then level = 99
			drawCount = 2
		EndIf
		
		If k >= Asc("0") And k < Asc("0") + MAX_BLOCKS Then
			curBlock = k - Asc("0")
			drawCount = 2
		EndIf
		
		If k = 32 Then
; Must call this routine before doing any priority queue stuff
			AS_Initialise()
			
		
			If startX <> -1 And endX <> -1 Then 
				DrawMap()
				Flip
				DrawMap()
				map(startX,startY) = 0
				map(endX,endY) = 0
				InitialiseMap()
				If AS_FindPath(MP_map(startX,startY),MP_map(endX,endY)) = 0 Then
					Color 255,255,0
					If AS_outSize > 0 Then 
						For t = 0 To AS_outSize	- 1
							n.PQ_Node = AS_outPath(t)
							x = n\x
							y = n\y
							Rect x * BLOCK_SIZE, y * BLOCK_SIZE, BLOCK_SIZE - 1,BLOCK_SIZE - 1			
						Next
					EndIf
				EndIf
				map(startX,startY) = BLOCK_START
				map(endX,endY) = BLOCK_END
			EndIf
			drawCount = 2
			DrawMap()
		EndIf
		If k = Asc("c") Then
			AS_outSize = 0
			drawCount = 2
		EndIf
		If k = Asc("r") Then
			SHOW_COSTS = 1 - SHOW_COSTS
			drawCount = 2
		EndIf
		If k = Asc("[") And heuristic > 0 Then heuristic = heuristic - 1: drawCount = 2
		If k = Asc("]") And heuristic < 10 Then heuristic = heuristic + 1: drawCount = 2	

		If k = Asc(",") And SLOWMO > 0 Then SLOWMO = SLOWMO - 1: drawCount = 2
		If k = Asc(".") And SLOWMO < 10 Then SLOWMO = SLOWMO + 1: drawCount = 2
		
		If k = Asc(";") And DIST_CALC_METHOD > 0 Then DIST_CALC_METHOD = DIST_CALC_METHOD - 1: drawCount = 2
		If k = Asc("'") And DIST_CALC_METHOD < MAX_DIST_CALC_METHODS-1 Then DIST_CALC_METHOD = DIST_CALC_METHOD + 1: drawCount = 2
		
		If k = Asc("w") Then
			WipeMap()
			drawCount = 2
		EndIf
	Wend
	End

	
WaitKey

End

Function WipeMap()
			For y = 0 To MAP_HEIGHT - 1
				For x = 0 To MAP_WIDTH - 1
					map(x,y)=0
				Next
			Next
			startX = -1
			endX = -1
End Function

Function SaveLevel()
	file = WriteFile("lvl"+Str$(level))
	If file = 0 Then Return
	For y = 0 To MAP_HEIGHT - 1
		For x = 0 To MAP_WIDTH - 1
			WriteInt file,map(x,y)
		Next
	Next
	CloseFile file
End Function

Function LoadLevel()
	file = ReadFile("lvl"+Str$(level))
	If file = 0 Then WipeMap():Return
	For y = 0 To MAP_HEIGHT - 1
		For x = 0 To MAP_WIDTH - 1
			map(x,y) = ReadInt(file)
			If map(x,y) = BLOCK_START Then
				startX = x
				startY = y
			EndIf
			If map(x,y) = BLOCK_END Then
				endX = x
				endY = y
			EndIf
		Next
	Next
	CloseFile file
End Function

;----------------------------------------------------
; Compute the cost of a block
;----------------------------------------------------
Function BlockCost(b) 
	Return COST_MULT*b+1
End Function


Function InitBlocks()
	Restore colours
	For t = 0 To MAX_BLOCKS - 1
		block(t) = New Block
		Read block(t)\r
		Read block(t)\g
		Read block(t)\b
	Next
	
	Restore offsData
	For t = 0 To 7: Read MP_xoff(t): Next
	For t = 0 To 7: Read MP_yoff(t): Next
	
End Function


Function DrawMap()
	Color 0,0,255
	Origin 0,0
	Rect 0, 0, MAP_WIDTH * BLOCK_SIZE + 2, MAP_HEIGHT * BLOCK_SIZE + 2, 0
	Origin 1,1
	For y = 0 To MAP_HEIGHT - 1
		For x = 0 To MAP_WIDTH - 1
			b = map(x,y)
			Color block(b)\r,block(b)\g,block(b)\b
			Rect x*BLOCK_SIZE,y*BLOCK_SIZE,BLOCK_SIZE-1,BLOCK_SIZE-1
If SHOW_COSTS
			Color 0,0,255
			Text x*BLOCK_SIZE,y*BLOCK_SIZE,Str$(BlockCost(b))
EndIf
		Next
	Next
	
	Color 0,0,0
	Rect 0, MAP_HEIGHT * BLOCK_SIZE + 1,300,40
	
	Color block(curBlock)\r,block(curBlock)\g,block(curBlock)\b 
	Rect 0,MAP_HEIGHT * BLOCK_SIZE + 1,40,40
	Color 255,255,255
	Rect 0,MAP_HEIGHT * BLOCK_SIZE + 1,40,40,0
	
	Color 255,0,0
	Rect 0,MAP_HEIGHT * BLOCK_SIZE + 1 + 44,20,20
	Text 24,MAP_HEIGHT * BLOCK_SIZE + 1 + 44,"Node currently examining (popped off queue)"

	Color 0,255,0
	Rect 0,MAP_HEIGHT * BLOCK_SIZE + 1 + 64,20,20
	Text 24,MAP_HEIGHT * BLOCK_SIZE + 1 + 64,"Node finished examining (in closed list)"
	
	Color 0,0,255
	Rect 320,MAP_HEIGHT * BLOCK_SIZE + 1 + 44,20,20
	Text 320+24,MAP_HEIGHT * BLOCK_SIZE + 1 + 44,"Child of the current node. (Added to open list)"
	
	Color 255,255,255
	Text 40 + 10,MAP_HEIGHT * BLOCK_SIZE + 1,"Level:"+Str$(level) + "  SlowMo:" + Str$(SLOWMO)
	Text 40 + 10,MAP_HEIGHT * BLOCK_SIZE + 1 + 10,"Heuristic multiplier:"+Str$(heuristic)
	Text 40 + 10,MAP_HEIGHT * BLOCK_SIZE + 1 + 20,"Distance Method:"+distName(DIST_CALC_METHOD)
	
	Color 255,255,0
	If AS_outSize > 0 
		For t = 0 To AS_outSize	- 1
			n.PQ_Node = AS_outPath(t)
			x = n\x
			y = n\y
			Rect x * BLOCK_SIZE, y * BLOCK_SIZE, BLOCK_SIZE - 1,BLOCK_SIZE - 1			
		Next
	EndIf
	
End Function

Function DrawHelp()
	xx = BLOCK_SIZE * MAP_WIDTH + 8
	hh = 12
	Text xx,0,"Press 0 to " + Str$(MAX_BLOCKS-1) + " to select"
	Text xx,hh,"a block to put down."
	Text xx,hh*2,"Green is start point."
	Text xx,hh*3,"Red is end point."
	Text xx,hh*4,"White is impassable."
	Text xx,hh*5,"Greys various costs."
	Text xx,hh*7,"ESC - Quit"
	Text xx,hh*8,"SPACE - Start/Stop pathfind"
	Text xx,hh*9,"l)oad level"
	Text xx,hh*10,"s)ave level"
	Text xx,hh*11,"=)next level"
	Text xx,hh*12,"-)prev level"
	Text xx,hh*13,"c)clear paths shown"
	Text xx,hh*14,"r)Show/Hide costs of nodes"
	Text xx,hh*15,"q)Toggle slow motion path generation"
	Text xx,hh*16,"w)Wipe map"
	Text xx,hh*17,"[)Decrease heuristic"
	Text xx,hh*18,"])Increase heuristic"
	Text xx,hh*19,",)Decrease path finding delay"
	Text xx,hh*20,".)Increase path finding delay"
	Text xx,hh*21,";)Decrease distance calculation type"
	Text xx,hh*22,".)Increase distance calculation type"
	Text xx,hh*23,"p)Pause/unpause during pathfind"
End Function

.colours
Data 0,0,0
Data 255*.1,255*.1,255*.1
Data 255*.2,255*.2,255*.2
Data 255*.3,255*.3,255*.3
Data 255*.4,255*.4,255*.4
Data 255*.5,255*.5,255*.5
Data 255*.6,255*.6,255*.6
Data 0,255,0
Data 255,0,0
Data 255,255,255				; Can't go through this




Function InitialiseMap()

; NOTE: Reset of nodes. If you weren't remaking the map each time like I am doing, you don't have to
; delete the PQ_Nodes or AS_Neighbours, but you would have to initialise the node's inClosed and inOpen
; fields so that the node's start not in any list.
	Delete Each PQ_Node						; Remember to do this if you're reinitialising your PQ_Node map
	Delete Each AS_Neighbour				; Same with this!

	MP_width = MAP_WIDTH
	MP_height = MAP_height
	
;NOTE: Here is where I make the nodes for my graph (map). I also calculate the cost of the nodes here
; also	
	For y = 0 To MP_height - 1
		For x = 0 To MP_width - 1
			unit = map(x,y)
			MP_map(x,y) = New PQ_Node
			MP_map(x,y)\cost = BlockCost(unit)
			If map(x,y)<> BLOCK_IMPASS Then MP_map(x,y)\cost = 0
			MP_map(x,y)\x = x
			MP_map(x,y)\y = y
		Next
	Next
	
	For y = 0 To MP_height - 1
		For x = 0 To MP_width - 1
			sb = map(x,y)
			For t = 0 To 7
				nx = x + MP_xoff(t)				; Positions of neighbours using offsets
				ny = y + MP_yoff(t)
				If nx >= 0 And ny >=0 And nx < MP_width And ny < MP_height Then
				
; NOTE: Here is how you make neighbours for your nodes						
					If MP_map(nx,ny)\cost < MP_COST_IMPASS Then			; Only ones with no walls
;					If map(nx,ny) <> BLOCK_IMPASS Then			; Only ones with no walls
						nb = map(nx,ny)
						m.PQ_Node = MP_map(x,y)
						neigh.PQ_Node = MP_map(nx,ny)		; This neighbour
						
						newNeigh.AS_Neighbour = New AS_Neighbour
						newNeigh\nextNeigh = m\firstNeigh	; Insert at front of list
						newNeigh\neigh = neigh				; Point to neighbour
						
; NOTE: Edge cost calculation. AStar needs this
						newNeigh\edgeCost = (BlockCost(sb)+BlockCost(nb))/2
						
						
						m\firstNeigh = newNeigh				; New one is at front
					EndIf
				EndIf
			Next			
		Next
	Next
	
End Function

.offsData
Data 0,1,1,1,0,-1,-1,-1
Data -1,-1,0,1,1,1,0,-1
