
PlayMusic("shadxg.mid")						;play some music
AppTitle "Shooting game By Fash-FD"			;window title if run in a box
Graphics 1024,768							;graphic size
Text 10,10,"Project: Moonbase Game By Steve 'Fash' Harrison Of Future Developments...LOADING.."
											;break the silence while loading
SetBuffer BackBuffer()						;start off drawing on the back buffer
SetFont LoadFont("arial",38,1)				;load the font for our text
Global crosshair=LoadImage("crosshairfd1.bmp");load the crosshair graphic
Global enemy=LoadImage("warpmine.bmp")		; Load in the enemy 
Global background=LoadImage("planet.bmp")	;load the background
Global base=LoadImage("base.bmp")			;load our base graphic
Global explode=LoadSound("buildexplode.wav");load the explosion sound
Global die=LoadSound("baiterdie.wav")		;load the laser sound	
Global build=LoadSound("baiterwarp.wav")	;load the enemy draining base energy sound	
Global gover=LoadImage("gameover.bmp")		;load the gameover screen
Global backscr=LoadImage("code.bmp")		;load the background for the title screen
Global star=LoadImage ("star.bmp")
Global basex=0								;initial base x pos (was gonna scroll it to make it harder!)
Global basey=600							;position of base on screen (just on grass!)
Global MousestartX =512						;start x pos of crosshair
Global MousestartY =384						;start y pos of crosshair
Global lives=5								;initial lives
Global x=100								;start position x
Global y=100								;start position y
Global xs=4									;start x speed of enemy
Global ys=4									;start y speed of enemy
Global bottom=560							;enemy boundaries
Global top=20								;enemy boundaries
Global Lft=0								;enemy boundaries
Global Rght=900								;enemy boundaries
Global coll=0								;collision flag 1=yes,0=no
Global score=000000							;score obviously
Global mousespeed=8							;initial mouse x,y speed
Global damage=142							;damage counter
Global tx=0
Global sx=0
MoveMouse mousestartx,mousestarty			;reset mouse pointer to middle of screen
Global stage=0
Repeat										;This is the start of our main loop
Select stage								;Decide which segment to run
	Case 0
	While Not MouseHit (1)					;this is the title
	start
	tx=tx+1									;increase tx to scroll background
	Wend
	stage=1
	
	Case 1									;this initialises the game variables (needed after game over etc)
	initgame
	stage=2	
	
	Case 2									;this is the main game loop
	drawstar
	drawback
	drawbase
	Updateenemy
	drawenemy
	drawcross
	detectfire
	drawscore
	drawdamage
	drawlives
	detectdamage
	sx=sx+1
	Flip
	Cls
	
	Case 3									;this is the game over bit
	gameover
	stage=0
End Select									;if escase pressed exit game 
Until KeyHit (1)
End
	
Function start()							;this is the titlescreen;draw the background and some text
SetBuffer BackBuffer()						;then wait for left mouse before going to next stage
TileImage backscr,0,tx,0
Text 230,100,"Welcome to Project: MOONBASE ",0,1
Text 180,160,"Coded in Blitz By Steve 'Fash' Harrison ",0,1
Text 250,220,"(c) 2000 Future Developments ",0,1
Text 250,400,"Hi, and thanx to George Bray, 
Text 230,460,"Mikkel Lokke, and everyone else !! "
Text 270,700,"HIT LEFT MOUSE TO PLAY "
Flip
Cls
End Function

Function drawstar()
TileBlock star,sx,0,0
End Function

Function drawback()							;draw the planet background
DrawImage background,0,0,0
End Function

Function drawbase()							;draw the base you need to protect
DrawImage base,basex,basey,0
End Function

Function Updateenemy()						;update the enemy
x=x+xs : y=y+ys								;Update enemy position
If x<top Or x>(rght) Then xs=-xs			;edge of screen ? change direction
If y<Lft Or y>(bottom) Then ys=-ys			;edge of screen ? change direction
End Function

Function drawenemy()						;draw the enemy at its co-ordinates
DrawImage enemy,x,y
End Function

Function drawcross()						;draw our crosshair at the mouse position
DrawImage crosshair,MouseX ()+mousespeed,MouseY ()+mousespeed,0
End Function


Function detectfire()						;check if leftmouse has been pressed
If MouseDown (1) Then PlaySound die			;yes, then check if crosshair was over enemy
collision 
End Function

Function collision()						;if crosshair hit enemy then go to kill function
coll=0										;if not,ignore it
If ImagesCollide (enemy,x,y,0,crosshair,MouseX (),MouseY (),0) Then coll=1
kill
End Function

Function kill()								;if collision took place increase score,reset collision counter
If coll=1 And MouseHit (1) Then updatescore Else
coll=0
End Function

Function drawscore()						;draw the score
Text 10,10,"SCORE " +score
End Function

Function drawlives()						;draw the lives
Text 10,40,"LIVES " +lives
End Function


Function updatescore()						;update the score if there was a collison
PlaySound explode							;explode the enemy, then increas his speed
If coll=1 Then score=score+10:x=Rnd (40,900):y=Rnd (0,50):xs=xs+1:ys=ys+1:coll=0
End Function								;also give him a random start position on the screen

Function drawdamage()						;draw the damage bar
Text 740,10,"DAMAGE "
Rect 742,5,damage,10,1
End Function

Function detectdamage()						;if there's a collison decrease the damage bar
If ImagesCollide (enemy,x,y,0,base,basex,basey,0) Then damage=damage-1:PlaySound build:If damage=0 Then updatelives
End Function								;no damage left, then decrease lives

Function updatelives()						;no lives left ? gamover man,game over
damage=100:lives=lives-1:If lives=0 Then stage=3
End Function

Function gameover()							;draw the game over bitmap
Repeat
Cls
DrawImage gover,200,200,0			
Text 270,700,"HIT LEFT MOUSE TO PLAY "
Flip
Until MouseHit(1)							;wait for the mouse again 
Cls
stage=0										;go back to first stage
End Function

Function initgame()							;same variables as start (needed after game over !)
basex=0
basey=600
MousestartX =512
MousestartY =384
lives=5
x=100								
y=100							
xs=4								
ys=4								
bottom=560							
top=20							
Lft=0								
Rght=900							
coll=0								
score=000000						
mousespeed=8						
damage=142
End Function