;
; SPINNING STARFIELD 2
;
; By Rob Hutchinson and Simon Hitchen -	simon@satanicdreams.com
;										rob@satanicdreams.com
; LEFT ARROW  - rotate left
; RIGHT ARROW - rotate right 
; SPACE       - stop rotation
; ESC         - quit
;

SeedRnd MilliSecs()
Const width=1024,height=768		; Bitmap parameters
Global stars=25					; Now the number of stars added per frame
Global rot#=1					; rotation direction
Global maxrot#=1				; rotate to +/- this value tops.
Global movespeed#=1.03			; rate at which stars come towards screen.
Global wx=-((width/2)+150)		; just some precalculations
Global hy=-((height/2)+150)		;

Type Star						; a star :)
	Field an#,dis#,spd#			; angle, distance ,speed
	Field r,g,b					; colour
End Type

Global s.Star					; Our list
								; .... this is faster :)

Graphics width,height;,16		; display
TFormFilter 0

stonea=LoadImage("stone.bmp")	; Load in the ball image from disk.
stoneb=LoadImage("stone2.bmp")	; Load in the ball image from disk.
ResizeImage(stonea,20,20)		; Load in the ball image from disk.
ResizeImage(stoneb,20,20)		; Load in the ball image from disk.

SetBuffer BackBuffer()			; Double buffer for no flicker :)
Origin width/2,height/2			; Set GFX origin to centre of screen

Repeat							; MAIN LOOP 

	If KeyHit(57)				; Space pressed
		rot=0					; no rotation
	End If
	If KeyDown(203)				; Right Arrow
		rot=rot+0.10			; clockwise rotation
		CheckRot()
	End If
	If KeyDown(205)				; Left Arrow
		rot=rot-0.10
		CheckRot()
	End If

	Cls

	s.Star=First Star
	For lop=0 To stars				; Define the stars
		s.Star=New Star				;
		s\an=Rnd(360)				; the angle
		s\dis=Rnd(50)				; the distance
		r=Rnd(100,250)
		s\spd=Rnd(0.90,2.0)
		s\r=r : s\g=r : s\b=r		; Set colour of pixel.
	Next

	For s.Star=Each Star			; process all stars
		s\an=(s\an+rot)         	; add rotation to each stars angle
		If s\an<0 Then s\an=359 	; wrap round
		If s\an>=360 Then s\an=0	

		posx=Sin(s\an)*s\dis		; grid positions of this star
		posy=Cos(s\an)*s\dis		;
		If posx<wx Or posx>Abs(wx) Or posy<hy Or posy>Abs(hy)
			Delete s
		Else
			Color s\r,s\g,s\b
			Rect posx,posy,1,1		; draw stars
			s\spd=s\spd*movespeed
			s\dis=s\dis+s\spd
		EndIf
	Next

	Flip							; update screen
	
Until KeyDown(1)                	; exit if ESC pressed

End

Function CheckRot()					; a little function to check 
	If rot>maxrot Then rot=maxrot	; to see if the rotation is 
	If rot<-maxrot Then rot=-maxrot	; out of bounds.
End Function


