;
;	Scrolling platform (Map Editer)
;
;	Created by David Bird
;
;	e-mail dave@birdie72.freeserve.co.uk
;
;	27-09-2000
;


Global tilesize=32
Global s_width=1024
Global s_height=768
;
;	Editer variables
;
Type srect
	Field active
	Field x1,y1,x2,y2
End Type
;
Global sel.srect=New srect
Global bufferactive
Global consoleypos
Global xpos,ypos
;
Graphics s_width,s_height						;Setup Screen
SetBuffer BackBuffer()							;and back buffer
	
Global map_tiles=CreateImage(32,32,1600)		;All the tiles for the game
Global m_pointer=CreateImage(32,32,3)			;rectangle mouse pointer
Global m_pointer2=CreateImage(32,32,1)			;second mouse pointer
Global player=CreateImage(32,64,24)				;create images for player

Global g_bang=CreateImage(32,32,6)				;explosions
Global watermain=CreateImage(64,64,1)			;water level object
Global g_bigbang								;bigger explosion

Global g_log=CreateImage(128,32,4)				;object 1
Global bad01=CreateImage(32,32,4)				;object 2
Global bad02=CreateImage(64,64,2)				;object 3
Global bad03=CreateImage(32,32,6)				;object 4
Global bad04=CreateImage(32,32,4)				;object 5
Global bad05=LoadAnimImage("gamegfx\enemies\dragon2.bmp",64,64,0,12)
Global bad06=LoadAnimImage("gamegfx\enemies\dragon2.bmp",64,64,0,12)
Global fish=LoadAnimImage("gamegfx\enemies\fish.bmp",48,32,0,6)
Global fly=LoadAnimImage("gamegfx\enemies\fly.bmp",48,48,0,12)
Global mosc=LoadAnimImage("gamegfx\enemies\moscy.bmp",48,48,0,12)


Global coin=LoadAnimImage("gamegfx\coins\coinsanim.bmp",32,32,0,8)

Global bad07=LoadAnimImage("gamegfx\enemies\gorr.bmp",64,64,0,6)		;object 7 - Gorilla.
HandleImage bad07,32,64													;handle object at bottom middle
Global bad08=LoadAnimImage("gamegfx\enemies\turtle.bmp",64,64,0,6)		;object 8 - slow turtle.
HandleImage bad08,32,60 												;handle object at bottom middle
Global seesaw=LoadAnimImage("gamegfx\map_tiles\seesaw.bmp",256,64,0,5)
Global s_ton=LoadAnimImage("gamegfx\map_tiles\10ton.bmp",64,64,0,2)
Global drawbridge=LoadAnimImage("gamegfx\map_tiles\drawbridge.bmp",192,192,0,6)

ResizeImage bad06,128,96

Global bullet1=CreateImage(32,32,4)
Global tellscore=CreateImage(56,32,100)			;used to display pickups value
Global font1=LoadFont( "helvetica",32,True )	;load fonts 1
Global font2=LoadFont( "helvetica",16,True )	;and 2
Global heighttile=1

Global watercnt=3					;pause between rise
Global waterspeed=1					;amount rise each count
Global waterlevel


;
;	Object types (tpe)
;	~~~~~~~~~~~~~~~~~~
;
;	1 		- 	Controlled by player
;	2->11	-	Display of pickup score 100 to 1000
;	12		-	
;	13		-	players bullet
;	14		-	explosion
;	15		-	bigger explosion
;	16		-	
;	17		-	
;	18		-	
;	19		-	
;	20		-	Scorpion
;	21		-	Big Bee
;	22		-	none lethal bridge type object
Type screen_object	;every moving object uses this type
	Field Selected
	Field sx
	Field sy
	Field gfx		;gfx direction 0=right 1=left
	Field stand_still
	Field lives
	Field score
	Field frame
	Field tpe		;type of object see listing of objects
	Field x,y		;position
	Field spdx		;movement speed
	Field falling
	Field jumping
	Field jumpcnt
	Field counter
	Field dx
	Field dy
	; path information
	Field path_number	;=0 for no path to run
	Field path_index
	Field path_direction
End Type

Type screen_block
	Field tpe
	Field value
	Field blk
End Type
Type path
	Field tpe$
	Field dx,dy
End Type

Dim paths.path(100,1000)
For q=0 To 100
	For w=1 To 1000
		paths.path(q,w)=New path
		paths(q,w)\tpe$="B"
		paths(q,w)\dx=0
		paths(q,w)\dy=0
	Next
Next

Global map_width=128,map_height=128
Global object_place=0

Dim tileheight(1000,32)

Dim map(20,map_width,map_height)
Dim mapinfo.screen_block(20,map_width,map_height)
For a=0 To 20
	For y=0 To map_height
		For x=0 To map_width
			mapinfo.screen_block(a,x,y)=New screen_block
			mapinfo(a,x,y)\tpe=0
			mapinfo(a,x,y)\value=0
			mapinfo(a,x,y)\blk=0
		Next
	Next
Next
Dim buffer(map_width,map_height)
Dim oblist.info(100)
Type info
	Field name$
	Field sx,sy
	Field tpe
	Field dx,dy
	Field falling
	Field jumping
	Field jumpcnt
	Field counter
	Field frame
End Type

Restore obsdata

Read numobs
Global maxobjects=numobs
For a=0 To numobs-1
	oblist.info(a)=New info
	Read oblist(a)\name$
	Read oblist(a)\sx
	Read oblist(a)\sy
	Read oblist(a)\tpe
	Read oblist(a)\dx
	Read oblist(a)\dy
	Read oblist(a)\falling
	Read oblist(a)\jumping
	Read oblist(a)\jumpcnt
	Read oblist(a)\counter
	Read oblist(a)\frame
Next


For y=0 To map_height
	For x=0 To map_width
		buffer(x,y)=0
	Next
Next

Global max_x=map_width*32-s_width
Global max_y=map_height*32-s_height
Global level=1
Global scroll_speed=8
Global screenx,screeny
Global xfollow,yfollow
Global firecnt,ldir
Global dead							;lose control if dead
Global heightmap=0					;used to display heightmap

CreateTiles()						;loads all tiles and objects
xpos=0:ypos=0

Global p1.screen_object=New screen_object		;players screen object
dead=False
Global mapinf=0
Global coinstocollect=0

;
;	erase all map tiles for the game
;

For a=0 To 20
	For x=0 To map_height
		For y=0 To map_width
			map(a,x,y)=0
			mapinfo(a,x,y)\tpe=0
			mapinfo(a,x,y)\value=0
		Next
	Next
Next


;
;	Map editer used only as a temp
;	for creating maps for the game
;	I`ll sort this out at a later date
;

e_mapposx=0
e_mapposy=0
setup_editer_map()
load_map(level)
load_map_objects(level)
load_paths(level)
Load_Tile_Info()
xpos=0:ypos=0
currentobject=2
pathnum=1

While Not KeyDown(1)
	Cls
	SetFont font2
	
	If KeyDown(203) And xpos>0 Then
		xpos=xpos-32
		e_move_delta(32,0)
	End If	
	If KeyDown(205) And xpos<max_x Then
		xpos=xpos+32
		e_move_delta(-32,0)
	End If
	If KeyDown(200) And ypos>0 Then
		ypos=ypos-32
		e_move_delta(0,32)
	End If	
	If KeyDown(208) And ypos<max_y Then 
		ypos=ypos+32
		e_move_delta(0,-32)
	End If
	
	If KeyDown(31) Then 
		save_map(level)
		save_map_objects(level)
		save_paths(level)
		Save_Tile_info()
	End If
	
	If KeyDown(26) And waterlevel>0 Then waterlevel=waterlevel-1
	If KeyDown(27) And waterlevel<map_height*32 Then waterlevel=waterlevel+1
	
	If KeyDown(40) Then watercnt=watercnt+1:watercnt=watercnt Mod 11:Delay 100
	If KeyDown(39) Then waterspeed=waterspeed+1:Delay 100:waterspeed=waterspeed Mod 5
	
	If KeyDown(15) Then heightmap=1:mapinf=0:object_place=0:Delay 200	;Height map editer
	If KeyDown(157) Then mapinf=1:heightmap=0:object_place=0:Delay 200	;Solid block info
	If KeyDown(28) Then object_place=1:heightmap=0:mapinf=0:Delay 200	;Place objects to screen
	If KeyDown(50) Then object_place=0:heightmap=0:mapinf=0:Delay 200	;Graphic tile placement

	e_mapposx=(MouseX()/32)*32
	e_mapposy=((MouseY()/32)*32)
	temp=(consoleypos/32)
	blkx=(xpos/32)+(e_mapposx/32)
	blky=(ypos/32)+(e_mapposy/32)+temp
	
	If object_place=0 Then											;
	  If heightmap=0 Then
	
		e_RenderMap(level,xpos,ypos)	
		e_Draw_Objects()
	
		If e_mapposy>s_height-consoleypos Then
			leved=0
			displace=s_height/32
		Else
			leved=level
		End If

	

		If MouseDown(1) And (Not KeyDown(42)) Then
			sel\active=0
			If e_mapposy>=s_height-consoleypos Then
				xxx=e_mapposx/32
				yyy=(e_mapposy/32)-(consoleypos/32)
				current_block=map(0,xxx,yyy+tilespos)
			Else
				map(level,blkx,blky)=current_block
			End If
		End If
	
		If KeyDown(2) Then set_map(level,blkx,blky,1)	;solid object
		If KeyDown(3) Then set_map(level,blkx,blky,2)	;solid on the top of block
		If KeyDown(4) Then set_map(level,blkx,blky,3)	;collect 1
		If KeyDown(5) Then set_map(level,blkx,blky,4)	;collect 2
		If KeyDown(6) Then set_map(level,blkx,blky,5)	;collect 3
		If KeyDown(7) Then set_map(level,blkx,blky,6)	;death object
		If KeyDown(8) Then set_map(level,blkx,blky,7)	;Spring object
		If KeyDown(14) Then
			If mapinf=1
				mapinfo(level,blkx,blky)\tpe=0
				mapinfo(level,blkx,blky)\value=0
			Else
				map(level,blkx,blky)=0
			End If
		End If
		
		If MouseDown(1) And KeyDown(42) Then 
			If e_mapposy<s_height-consoleypos Then
				If sel\active=0 Then
					sel\active=1
					sel\x1=blkx
					sel\y1=blky
					sel\x2=blkx
					sel\y2=blky
				Else
					sel\x2=blkx
					sel\y2=blky
				End If
			Else
				If sel\active=0 Then
					sel\active=2
					sel\x1=e_mapposx/32
					sel\y1=((e_mapposy/32)-(consoleypos/32))+tilespos
					sel\x2=e_mapposx/32
					sel\y2=((e_mapposy/32)-(consoleypos/32))+tilespos
				Else
					sel\x2=e_mapposx/32
					sel\y2=((e_mapposy/32)-(consoleypos/32))+tilespos
				End If
			End If
		End If
	
		If KeyDown(46) And sel\active=1		;c is for cut blocks on screen
			cut_buffer(leved)
			bufferactive=1
		End If

		If KeyDown(46) And sel\active=2		;c is for cut blocks on console
			cut_buffer(0)
			bufferactive=1
		End If
		
		If KeyDown(25) And bufferactive=1	;P is for paste
			Paste_buffer(blkx,blky)
			sel\active=0
		End If
		If MouseDown(2) Then console_active=1-console_active:Delay 140
		If KeyDown(201) And tilespos>0 Then tilespos=tilespos-1
		If KeyDown(209) And tilespos<60 Then tilespos=tilespos+1
	
		If console_active=1 Then 
			draw_console(tilespos)
			If consoleypos<(s_height/2) Then consoleypos=consoleypos+8
		Else
			draw_console(tilespos)
			If consoleypos>0 Then consoleypos=consoleypos-8
		End If
	  Else
		;
		; tile height information
		;
		drwfsel=0
		If MouseDown(2) Then drwfsel=1
		If KeyDown(18) Then EditBlock(heighttile)
		If drwfsel=0 Then
			
			If MouseDown(1) Then
				mapinfo(level,blkx,blky)\tpe=10
				mapinfo(level,blkx,blky)\blk=heighttile
			End If
			If KeyDown(14) Then							;delete heightmap
				mapinfo(level,blkx,blky)\tpe=0
				mapinfo(level,blkx,blky)\blk=0
			End If
			
			e_RenderMap(level,xpos,ypos)	
			e_Draw_Objects()
		Else
			drawfloorsel()
			If MouseDown(1) Then						;select new block
				tttx=(MouseX()/32)+1
				ttty=(MouseY()/32)*32
				heighttile=ttty+tttx
			End If
		End If
	  End If
	Else

		;
		;	Object placement
		;
		If KeyDown(209) And pathnum>0 And rec=False Then pathnum=pathnum-1:indeo=0
		If KeyDown(201) And pathnum<100 And rec=False Then pathnum=pathnum+1:indeo=0
		Color 255,255,255
		Locate 0,s_height-15:Print "Path Number:"+pathnum+" Length:"+ret_path_len(pathnum)
		Locate 0,s_height-32:Print "Coins to Collect This Level="+coinstocollect
		If KeyDown(30) Then AssignPath(pathnum)					;Assign a Path to a object
		If MouseDown(2) Then	
			currentobject=currentobject+1
			If currentobject=maxobjects Then currentobject=0
			Delay 500			
		End If


		If MouseDown(1) And beenclicked=1 Then beenclicked=1 Else beenclicked=0


		If KeyDown(14) Then
			For qwe.screen_object=Each screen_object
				If qwe\Selected=1 And qwe\tpe<>1 Then
					If qwe\tpe=17 Then 
						coinstocollect=	coinstocollect-1
						If coinstocollect<0 Then
							coinstocollect=0
						End If
					End If
					Delete qwe
					beenclicked=0
				End If
			Next
		End If
		If KeyDown(16) Then ToggleSpeed():Delay 50			;Toggle speed
		If KeyDown(17) Then ToggleScore():Delay 50			;Toggle score
		If KeyDown(18) Then ToggleDirection():Delay 50		;Toggle ?????
		If KeyDown(20) Then ToggleLives():Delay 50
		
		If MouseDown(1) And beenclicked=1 Then
			For qwe.screen_object=Each screen_object
				If qwe\Selected=1 Then
					qwe\x=(MouseX()-qwe\sx-8)/8*8
					qwe\y=(MouseY()-qwe\sy-8)/8*8
				End If
			Next
		Else
			If MouseDown(1) And beenclicked=0 Then
				For qwe.screen_object=Each screen_object
	  			  If qwe\tpe>0 Then
					If RectsOverlap(MouseX(),MouseY(),1,1,qwe\x+qwe\sx,qwe\y+qwe\sy,16,16) Then
						selctit(qwe)
						qwe\x=(MouseX()-qwe\sx-8)/8*8
						qwe\y=(MouseY()-qwe\sy-8)/8*8
						beenclicked=1
					End If
				  End If
				Next
				If beenclicked=0 Then		;if not over a object on screen then create a new one
					temper.screen_object=New screen_object
					temper\x=MouseX()-oblist(currentobject)\sx-8
					temper\y=MouseY()-oblist(currentobject)\sy-8
					temper\sx=oblist(currentobject)\sx
					temper\sy=oblist(currentobject)\sy
					temper\tpe=oblist(currentobject)\tpe
					temper\dx=oblist(currentobject)\dx
					temper\dy=oblist(currentobject)\dy
					temper\falling=oblist(currentobject)\falling
					temper\jumping=oblist(currentobject)\jumping
					temper\jumpcnt=oblist(currentobject)\jumpcnt
					temper\counter=oblist(currentobject)\counter
					temper\path_number=pathnum
					temper\path_direction=1
					If temper\tpe=17 Then					;Add a coin to collect
						coinstocollect=	coinstocollect+1
					End If

					If temper\tpe=25 Or temper\tpe=26 Then
						temper\lives=4
					End If
					tdps=oblist(currentobject)\tpe
				End If
			End If
		End If
		If KeyDown(19) Then		;record new path
			rec_new_path(pathnum)
		End If
		e_RenderMap(level,xpos,ypos)	
		e_Draw_Objects()
		If KeyDown(78) Then
			For r.screen_object=Each screen_object
				Delete r
			Next
			p1.screen_object=New screen_object
			p1\x=32:p1\y=32:p1\tpe=1:p1\spdx=8
			p1\sx=8
			p1\sy=24
			coinstocollect=0
		End If
	End If
	Color Rnd(255),Rnd(255),Rnd(255)
	Locate s_width-130,0:Print "F1 for Help.."
	Locate s_width-130,15:Print "Water Speed="+waterspeed
	Locate s_width-130,30:Print "Water Pause="+watercnt

	If KeyDown(59) Then
		SetFont font2
		Locate 0,30
		Color 255,255,255
		Print "Key Help."
		If heightmap=1 Then
			;help for height Mapper
			Print
			Print "These tiles are for movement in between blocks"
			Print "like hills and tunnels."
			Print "Warning. If you edit a tile make sure its right where"
			Print "ever it is placed."
			Print "Right Click - Toggle height tiles."
			Print "Left click - On tile screen to select a tile."
			Print "Left click - On map screen to place a tile."
			Print "    E      - To edit selected tile."
			Print "   TAB     - Exit Height map editer."
			Print "   ESC     - To exit Map Editer."
		Else		
			If mapinf=0 And object_place=0 Then
				;help for Map Editer
				Print
				Print "All tiles are only for asthetics they don`t do anything at all."
				Print "Press right CTRL to goto Tile information"
				Print "Press right SHIFT And movemouse with Left button clicked To Select a region of tiles"
				Print "Press C to copy region."
				Print "Press P to Paste region."
				Print "Press S to Save Level."
				Print "Press [ or ] to + & - water level"
				Print "Press ; to Toggle Water Speed."
				Print "Press ' to Toggle Water Delay."
				Print "Press ESC - To quit Map Editer."
	
			Else
				If mapinf=1 And object_place=0 Then
					;Tile info help
					Print
					Print "These are the important tiles."
					Print "Press 1 - To place a Solid tile."
					Print "Press 2 - To place a semi solid tile. ie Can`t pass though going down."
					Print "Press 3 - To place a pickup object continue to press to increase score value."
					Print "Press 4 - To place a pickup object continue to press to increase score value."
					Print "Press 5 - To place a pickup object continue to press to increase score value."
					Print "Press 6 - To place a deadly object. Will kill player only."
					Print "Press 7 - To place a spring object."
					Print "Press 8 - To place a shooting block (RIGHT). Continue to press to alter fequency."
					Print "Press 9 - To place a shooting block (LEFT). Continue to press to alter fequency."
					Print "Press S to Save Level."
					Print "Press [ or ] to + & - water level"
					Print "Press ; to Toggle Water Speed."
					Print "Press ' to Toggle Water Delay."
					Print "Press ESC - To quit Tile Information."

				Else
					;Object Editer help
					Print "PGUP - To increase path number."
					Print "PGDWN - To decrease path number."
					Print "Press A - To Assign a path to an object"
					Print "Press Q - To toggle speed of object where applic."
					Print "Press W - To toggle value of object where applic."
					Print "Press E - To toggle start direction of object where applic."
					Print "Press R - To record new path."
					Print "Press T - To toggle hit count to kill object where applic."
					Print "Press ESC - To quit Map Editer."
					Print "Press [ or ] to + & - water level"
					Print "Press ; to Toggle Water Speed."
					Print "Press ' to Toggle Water Delay."
				End If
			End If
		End If
	End If
	SetFont font1
	Color 255,255,255
	Locate 0,0
	DrawImage m_pointer2,MouseX(),MouseY(),0
	If object_place=0 Then
	Locate 0,0
	  If heightmap=0 Then
		If mapinf=0 Then
			Print "Map Editer."
		Else 
			Print "Tile Information."
		End If
		Color Rnd(255),Rnd(255),Rnd(255)
		Text s_width/2,s_height-32-consoleypos,"Right mouse to toggle Console.",1,0
	  Else
		If drwfsel=0 Then
			Print "Height Map"
		Else
			Text 512,730,"Height Map Tiles. Select with mouse",1,1
		End If
	  End If
	Else
		Print "Object Editer."
		Print "Next Object:"+oblist(currentobject)\name$
		Color Rnd(255),Rnd(255),Rnd(255)
		Text s_width/2,s_height-32-consoleypos,"ENTER to toggle Objects placement.",1,0
	End If
	If object_place=0 Then DrawImage m_pointer,e_mapposx,e_mapposy,0
	draw_water(ypos)
	Flip
	If KeyDown(11) Then 
		tmper=CreateImage(1024,768,1)
		GrabImage tmper,0,0
		SaveImage(tmper,"Snap.bmp")		
	End If

Wend
Cls
save_map(level)
save_map_objects(level)
save_paths(level)
Save_Tile_info()


For e.screen_object=Each screen_object
	Delete e
Next 
For et=0 To 100
	For f=0 To 1000
		Delete paths(et,f)
	Next
Next
For ep.srect=Each srect
	Delete ep
Next
For er.info=Each info
	Delete er
Next
For es.screen_block=Each screen_block
	Delete es
Next
SetFont font1
End
End

;
;	All functions placed after here
;
Function AssignPath(pth)
	For a.screen_object=Each screen_object
		If a\Selected=1 Then
			If a\tpe=1 Then Return				;Can`t assign a path to player
			a\path_number=pth
			a\path_index=1
			a\path_direction=1
		End If
	Next
End Function

Function ToggleLives()
	For a.screen_object=Each screen_object
		If a\Selected=1 Then
			If a\tpe=1 Then Return				;Can`t assign a path to player
			a\lives=a\lives+1
			If a\lives=30 Then a\lives=0
		End If
	Next
End Function

Function ToggleSpeed()
	For a.screen_object=Each screen_object
		If a\Selected=1 Then
			If a\tpe=1 Then Return				;Can`t assign a path to player
			spd=a\spdx
			If spd>=4 Then 
				spd=0
			Else
				spd=spd+2
			End If
			a\spdx=spd
		End If
	Next
End Function

Function ToggleDirection()
	For a.screen_object=Each screen_object
		If a\Selected=1 Then
			If a\tpe=1 Then Return				;Can`t assign a path to player
			If a\dx=0 Then a\dx=1
			a\dx=-a\dx
		End If
	Next
End Function

Function ToggleScore()
	For a.screen_object=Each screen_object
		If a\Selected=1 Then
			If a\tpe=1 Then Return				;Can`t assign a path to player
			a\score=a\score+100
			If a\score=1100 Then a\score=100

		End If
	Next
End Function

Function selctit(w.screen_object)
	For a.screen_object=Each screen_object
		If a\tpe=0 Then
			Delete a
		Else
			a\Selected=0
			If a=w Then	a\Selected=1
		End If
	Next
End Function

Function CreateTiles()
	tilespic=LoadImage("gamegfx\Map_Tiles\block1.bmp")
	DrawImage tilespic,0,0,0

	Color 255,0,0
	img=1
	For y=0 To 735 Step 32
		For x=0 To 991 Step 32
			GrabImage map_tiles,x,y,img
			img=img+1
			Rect x,y,32,32,0
		Next
	Next
	Cls
	tilespic=LoadImage("gamegfx\Map_Tiles\block2.bmp")
	DrawImage tilespic,0,0,0

	Color 255,0,0
	For y=0 To 735 Step 32
		For x=0 To 991 Step 32
			GrabImage map_tiles,x,y,img
			img=img+1
			Rect x,y,32,32,0
		Next
	Next

	Cls
	Color 255,0,0
	Rect 1,1,30,30,0
	GrabImage m_pointer,0,0,0
	Color 0,255,0
	Rect 1,1,30,30,0
	GrabImage m_pointer,0,0,1
	m_pointer2=LoadImage("gamegfx\Map_Tiles\pointer.bmp")

	Cls
	For r=0 To 23
		Color Rnd(255),Rnd(255),Rnd(255)
		Rect 0,0,32,64
		GrabImage player,0,0,r
	Next 
	SetFont font1
	d=0
	For a=1  To 10
		For r=1 To 10
			Color Rnd(255),Rnd(255),Rnd(255)
			Cls
			Text 28,16,a*100,1,1
			GrabImage tellscore,0,0,d
			d=d+1
		Next
	Next
	;
	;	load image for player etc
	;	and grab each image
	;
	tempp=LoadImage("gamegfx\player\player.bmp")
	Cls
	DrawImage tempp,0,0,0
	For a=0 To 3
		GrabImage player,a*32,0,a
		GrabImage bad01,a*32,64,a
		GrabImage bullet1,a*32,128,a
		GrabImage g_log,a,160,a
		GrabImage bad04,a*32,320,a
	Next
	For a=0 To 5
		GrabImage g_bang,a*32,96,a
		GrabImage bad03,a*32,256,a
	Next
	g_bigbang=CopyImage(g_bang)				;bigger explosion
	ResizeImage g_bigbang,64,64

	For a=0 To 1
		GrabImage bad02,a*64,192,a
	Next
	ResizeImage g_bigbang,64,64
	Cls
	Color 0,0,Rnd(100)+150
	tmpp=0
	For y=0 To 64 Step 2
		For x=tmpp To tmpp+64 Step 2
			Plot x,y
		Next
		tmpp=1-tmpp
	Next
	GrabImage watermain,0,0,0
	Color 255,255,255
	Cls
End Function

Function e_Draw_Objects()
	For a.screen_object=Each screen_object
	 If a\x>-200 And a\x<s_width+200 Then				;Only draw objects if
	  If a\y>-200 And a\y<s_height+200 Then				;within range of screen
		Select a\tpe
			Case 1										;players object
				If a\stand_still=0 Then
					image=a\gfx*2
				Else
					image=a\gfx*2+a\frame
				End If
				DrawImage player,a\x,a\y,image
			Case 2										;100 pnts
				DrawImage tellscore,a\x,a\y,Rnd(10)
			Case 3										;200 pnts
				DrawImage tellscore,a\x,a\y,Rnd(10,20)
			Case 4										;300 pnts
				DrawImage tellscore,a\x,a\y,Rnd(20,30)
			Case 5										;400 pnts
				DrawImage tellscore,a\x,a\y,Rnd(30,40)
			Case 6										;500 pnts
				DrawImage tellscore,a\x,a\y,Rnd(40,50)
			Case 7										;600 pnts
				DrawImage tellscore,a\x,a\y,Rnd(50,60)	
			Case 8										;700 pnts
				DrawImage tellscore,a\x,a\y,Rnd(60,70)	
			Case 9										;800 pnts
				DrawImage tellscore,a\x,a\y,Rnd(70,80)
			Case 10										;900 pnts
				DrawImage tellscore,a\x,a\y,Rnd(80,90)	
			Case 11										;1000 pnts
				DrawImage tellscore,a\x,a\y,Rnd(90,100)	
			Case 12										;Seesaw used for puzzles
				DrawImage seesaw,a\x,a\y,a\frame
			Case 13										;draw bullet fired from player
				DrawImage bullet1,a\x,a\y,0
			Case 14										;explosions
				DrawImage g_bang,a\x,a\y,a\frame
			Case 15
				DrawImage g_bigbang,a\x,a\y,a\frame		;larger explosion
			Case 16
			Case 17										;goal object coins
				DrawImage coin,a\x,a\y,a\frame			
			Case 18										;10 ton wieght
				DrawImage s_ton,a\x,a\y,0
			Case 19
			Case 20										;scorpion bad01
				image=a\gfx*2+a\frame
				DrawImage bad01,a\x,a\y,image
			Case 21										;Big Bee
				DrawImage bad02,a\x,a\y,a\frame
			Case 22										;non leathal log
				If a\counter=0 Then 
					a\counter=10
					a\frame=a\frame+1
					If a\frame=4 Then a\frame=0
				End If
				DrawImage g_log,a\x,a\y,a\frame
			Case 23										;mobile eye
				DrawImage bad03,a\x,a\y,a\frame
			Case 24										;
				DrawImage bad04,a\x,a\y,a\frame
			Case 25										;
				DrawImage bad05,a\x,a\y,a\frame
			Case 26										;
				DrawImage bad06,a\x,a\y,a\frame
			Case 27										;Gorrila
				DrawImage bad07,a\x,a\y,a\frame
			Case 28										;Turtle
				DrawImage bad08,a\x,a\y,a\frame
			Case 29										;fly
				DrawImage fly,a\x,a\y,a\frame
			Case 30
				DrawImage mosc,a\x,a\y,a\frame
			Case 103
				DrawImage drawbridge,a\x,a\y,a\frame
		End Select
		If object_place=1 Then									;only active if object select is on toggle ENTER
			If a\Selected=1 Then								;if selected then give details
				Color 255,255,255
				Rect s_width/4,0,s_width/2,128,0
				Line s_width/2,128,a\x,a\y
				Oval a\x-4,a\y-4,8,8
				;draw path is exists
				draw_path(a\path_number,a\x,a\y)
				;print give details
				Select a\tpe
					Case 1
						Text s_width/2,10,"Player object",1,1
						Text s_width/2,24,"Player Speed"+a\spdx,1,1
					Case 12
						Text s_width/2,10,"Seesaw Object",1,1
					Case 17
						Text s_width/2,10,"Coin Object",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						Text s_width/2,52,"Value: "+a\score,1,1
					Case 18
						Text s_width/2,10,"10 Ton Weight",1,1
					Case 20
						Text s_width/2,10,"Scorpion Object",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
							Text s_width/2,52,"Value: "+a\score,1,1
							If a\dx<0 Then 
								Text s_width/2,66,"Direction:Left",1,1
							Else
								Text s_width/2,66,"Direction:Right",1,1
							End If								

						End If
					Case 21
						Text s_width/2,10,"Big Bug Object",1,1
						Text s_width/2,24,"Path number"+a\path_number,1,1	
						If a\path_number=0 Then
							Text s_width/2,38,"Value: "+a\score,1,1
						End If
					Case 22
						Text s_width/2,10,"Log Object",1,1
						Text s_width/2,24,"Path number"+a\path_number,1,1
					Case 23
						Text s_width/2,10,"Mobile Eye Object",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
							Text s_width/2,52,"Value: "+a\score,1,1
							If a\dx<0 Then 
								Text s_width/2,66,"Direction:Left",1,1
							Else
								Text s_width/2,66,"Direction:Right",1,1
							End If								
						End If
					Case 24
						Text s_width/2,10,"Man With Gun Object",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
							Text s_width/2,52,"Value: "+a\score,1,1
							If a\dx<0 Then 
								Text s_width/2,66,"Direction:Left",1,1
							Else
								Text s_width/2,66,"Direction:Right",1,1
							End If								
						End If
					Case 25
						Text s_width/2,10,"Flying Dragon",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						Text s_width/2,38,"Hit Count:"+a\lives,1,1
						Text s_width/2,52,"Value: "+a\score,1,1
					Case 26
						Text s_width/2,10,"Big Flying Dragon",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						Text s_width/2,38,"Hit Count: "+a\lives,1,1
						Text s_width/2,52,"Value: "+a\score,1,1
					Case 27
						Text s_width/2,10,"Gorrila Object",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
							Text s_width/2,52,"Value: "+a\score,1,1
							If a\dx<0 Then 
								Text s_width/2,66,"Direction:Left",1,1
							Else
								Text s_width/2,66,"Direction:Right",1,1
							End If								
						End If
						Text s_width/2,80,"Hit Count:"+a\lives,1,1
					Case 28
						Text s_width/2,10,"Turtle Object",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
							Text s_width/2,52,"Value: "+a\score,1,1
							If a\dx<0 Then 
								Text s_width/2,66,"Direction:Left",1,1
							Else
								Text s_width/2,66,"Direction:Right",1,1
							End If								
						End If
						Text s_width/2,80,"Hit Count: "+a\lives,1,1
					Case 29
						a\dx=0
						Text s_width/2,10,"Dropping Fly",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
						End If

						Text s_width/2,52,"Hit Count:"+a\lives,1,1
						Text s_width/2,66,"Value: "+a\score,1,1
					Case 30
						a\dx=0
						Text s_width/2,10,"Mosquetto",1,1
						Text s_width/2,24,"Path number: "+a\path_number,1,1
						If a\path_number=0 Then
							Text s_width/2,38,"Speed: "+a\spdx,1,1
						End If

						Text s_width/2,52,"Hit Count:"+a\lives,1,1
						Text s_width/2,66,"Value: "+a\score,1,1
				End Select
			End If
			If a\tpe>0 Then
				Rect a\x+a\sx,a\y+a\sy,16,16,0
			End If
		End If
	   End If
	  End If
	Next
End Function

Function e_RenderMap(lev, x_offset,y_offset )
	y_offset=y_offset+consoleypos
	ty=y_offset/tilesize
	sy=-(y_offset Mod tilesize)
	While sy<(s_height-consoleypos)
		ty=ty Mod map_height
		tx=x_offset/tilesize
		sx=-(x_offset Mod tilesize)
		While sx<s_width
			aax=tx Mod map_width
			tile=map(lev,aax,ty)
			DrawImage map_tiles,sx,sy,tile
			Color 255,255,255
				If mapinf=1 Then				;tile information on
					Select mapinfo(lev,aax,ty)\tpe
						Case 0
						Case 1
							Color 255,255,255		;walk on complete solid block
						Case 2
							Color 100,100,100		;walk on and jump through
						Case 3
							Color Rnd(255),0,0		;collectab;e 1
						Case 4
							Color 0,Rnd(255),0		;collectable 2
						Case 5
							Color 0,0,Rnd(255)		;collectable 3
						Case 6
							Color 255,0,0			;death object
						Case 7
							Color 30,30,255			;springey
						Case 8
							Color 255,Rnd(10),255	;gun block Left
						Case 9
							Color 255,255,Rnd(10)	;gun block Right
					End Select
				
					If mapinfo(lev,aax,ty)\tpe<>0 And mapinfo(lev,aax,ty)\tpe<=9 Then Rect sx,sy,32,32,0
					If mapinfo(lev,aax,ty)\value<>0 Then 
						Color 255,255,Rnd(255)
						Text sx+16,sy+16,mapinfo(lev,aax,ty)\value,1,1
					End If
					If mapinfo(lev,aax,ty)\tpe>=10 Then
						drawblck(mapinfo(lev,aax,ty)\blk,sx,sy)
					End If
				End If
			If heightmap=1 Then
				If mapinfo(lev,aax,ty)\tpe>=10 Then
					drawblck(mapinfo(lev,aax,ty)\blk,sx,sy)
				End If
			End If
			If sel\active=1 Then
				If aax>=sel\x1 And aax<=sel\x2 Then
					If ty>=sel\y1 And ty<=sel\y2 Then
						Color Rnd(255),Rnd(255),255
						Rect sx,sy,32,32,0
					End If
				End If
			End If
			tx=tx+1:sx=sx+tilesize
		Wend
		ty=ty+1:sy=sy+tilesize
	Wend
;	Prnkeypress()

End Function

Function draw_water(sy)

	If waterlevel-sy<0 Then 
		strt=0
	Else
		strt=waterlevel-sy
	End If
	For y=strt To s_height Step 64
		For r=0 To s_width Step 64
			DrawImage watermain,r,y,0
		Next
	Next
End Function

Function Paste_buffer(xx,yy)
	xt=0:yt=0
	For y=sel\y1 To sel\y2
		For x=sel\x1 To sel\x2
			If xx+xt<map_width And yy+yt<map_height Then
				map(level,xx+xt,yy+yt)=buffer(x-sel\x1,y-sel\y1)
			End If
			xt=xt+1
		Next
		yt=yt+1
		xt=0
	Next	
End Function

Function cut_buffer(lev)
	For y=sel\y1 To sel\y2
		For x=sel\x1 To sel\x2
			buffer(x-sel\x1,y-sel\y1)=map(lev,x,y)
		Next
	Next
	sel\active=0
End Function

Function draw_console(ps)
	Color 0,0,0
	Rect 0,8+s_height-consoleypos,s_width,s_height/2
	Color 255,255,255
	For y=0 To s_height/2 Step 32
		For x=0 To s_width Step 32
			aax=x/32:aay=y/32
			DrawImage map_tiles,x,s_height-consoleypos+y,map(0,aax,aay+ps)
			If sel\active=2 Then
				If aax>=sel\x1 And aax<=sel\x2 Then
					If aay>=sel\y1 And aay<=sel\y2 Then
						Color Rnd(255),Rnd(255),255
						Rect aax*32,s_height-consoleypos+(aay*32),32,32,0
					End If
				End If
			End If

			img=img+1
		Next
	Next	
	Color Rnd(255),Rnd(255),Rnd(255)
	Rect 0,s_height-consoleypos,s_width,1
End Function

Return

Function setup_editer_map()
	img=1
	For y=0 To 47
		For x=0 To 30
			map(0,x,y)=img
			img=img+1
		Next 
	Next
End Function

Function save_map(lev)
	name$="maps\map"+Str$(lev)+".map"
	file = WriteFile(name$)
	For y=0 To map_height
		For x=0 To map_width
			WriteInt file,map(lev,x,y)
			WriteInt file,mapinfo(lev,x,y)\tpe
			WriteInt file,mapinfo(lev,x,y)\value
			WriteInt file,mapinfo(lev,x,y)\blk
		Next
	Next
	WriteInt file,coinstocollect
	WriteInt file,watercnt					;pause between rise
	WriteInt file,waterspeed				;amount rise each count
	WriteInt file,waterlevel				;starpoint of water at beginning of level

End Function
Function save_map_objects(lev)
	name$="maps\map"+Str$(lev)+".obj"
	DeleteFile name$
	file= WriteFile(name$)
	For a.screen_object=Each screen_object
		WriteInt file,a\gfx		
		WriteInt file,a\stand_still
		WriteInt file,a\lives
		WriteInt file,a\score
		WriteInt file,a\frame
		WriteInt file,a\tpe		
		WriteInt file,a\x+xpos
		WriteInt file,a\y+ypos		
		WriteInt file,a\spdx		
		WriteInt file,a\falling
		WriteInt file,a\jumping
		WriteInt file,a\jumpcnt
		WriteInt file,a\counter
		WriteInt file,a\dx
		WriteInt file,a\dy
		WriteInt file,a\path_number
		WriteInt file,a\path_index
		WriteInt file,a\path_direction
	Next
End Function
Function save_paths(lev)
	name$="maps\map"+Str$(lev)+".pth"
	file = WriteFile(name$)
	For y=1 To 100
		For x=1 To 1000
			WriteString file,paths(y,x)\tpe$
			WriteInt file,paths(y,x)\dy
			WriteInt file,paths(y,x)\dx
		Next
	Next
End Function

Function Save_Tile_Info()
	file=WriteFile("TileInfo\TileHeight.plf")
	
	For ax=1 To 999
		For by=0 To 31
			WriteInt file,tileheight(ax,by)
		Next
	Next
End Function

Function Load_Tile_Info()
	file=ReadFile("TileInfo\TileHeight.plf")
	For ax=1 To 999
		For by=0 To 31
			tileheight(ax,by)=ReadInt(file)
		Next
	Next	
End Function

Function load_map_objects(lev)
	flush_objects()						;erase all objects from memory
	tempory=0
	name$="maps\map"+Str$(lev)+".obj"
	file= ReadFile(name$)
	While Not Eof(file)
		a.screen_object=New screen_object
		a\gfx=ReadInt(file)
		a\stand_still=ReadInt(file)
		a\lives=ReadInt(file)
		a\score=ReadInt(file)
		a\frame=ReadInt(file)
		a\tpe=ReadInt(file)
		a\x=ReadInt(file)
		a\y=ReadInt(file)
		a\spdx=ReadInt(file)
		a\falling=ReadInt(file)
		a\jumping=ReadInt(file)
		a\jumpcnt=ReadInt(file)
		a\counter=ReadInt(file)
		a\dx=ReadInt(file)
		a\dy=ReadInt(file)
		a\path_number=ReadInt(file)	;=0 for no path to run
		a\path_index=ReadInt(file)
		a\path_direction=ReadInt(file)

		Select a\tpe
			Case 1
				a\sx=8
				a\sy=24
			Case 12
				a\sx=120
				a\sy=24
			Case 17
				a\sx=8
				a\sy=8
			Case 18
				a\sx=24
				a\sy=24
			Case 20
				a\sx=8
				a\sy=8
			Case 21
				a\sx=24
				a\sy=24
			Case 22
				a\sx=56
				a\sy=8
			Case 23
				a\sx=8
				a\sy=8
			Case 24
				a\sx=8
				a\sy=8
			Case 25
				a\sx=24
				a\sy=24
			Case 26
				a\sx=56
				a\sy=40
			Case 27
				a\sx=-8
				a\sy=-48
			Case 28
				a\sx=-8
				a\sy=-48
			Case 29
				a\sx=16
				a\sy=16
			Case 30
				a\sx=16
				a\sy=16
			Case 102
				a\sx=88
				a\sy=88
		End Select
	Wend
End Function

Function load_map(lev)
	name$="maps\map"+Str$(lev)+".map"
	file = ReadFile(name$)
	For y=0 To map_height
		For x=0 To map_width
		map(lev,x,y)=ReadInt(file)
		mapinfo(lev,x,y)\tpe=ReadInt(file)
		mapinfo(lev,x,y)\value=ReadInt(file)
		mapinfo(lev,x,y)\blk=ReadInt(file)
		Next
	Next
	coinstocollect=ReadInt(file)
	watercnt=ReadInt(file)					;pause between rise
	waterspeed=ReadInt(file)				;amount rise each count
	waterlevel=ReadInt(file)				;starpoint of water at beginning of level

End Function

Function load_paths(lev)
	name$="maps\map"+Str$(lev)+".pth"
	file = ReadFile(name$)
	For y=1 To 100
		For x=1 To 1000
			paths(y,x)\tpe$=ReadString(file)
			paths(y,x)\dy=ReadInt(file)
			paths(y,x)\dx=ReadInt(file)
		Next
	Next
End Function

Function e_move_delta(x,y)
	For a.screen_object=Each screen_object
			a\x=a\x+x
			a\y=a\y+y
	Next
End Function

Function set_map(lev,x,y,val)
	Delay 250
	If mapinfo(lev,x,y)\tpe=val And val<>1 Then 
		If Not val=1 Then
			If Not val=2 Then
				If Not val=7 Then
					mapinfo(lev,x,y)\value=mapinfo(lev,x,y)\value+100
					If mapinfo(lev,x,y)\value=1100 Then mapinfo(lev,x,y)\value=0
				End If
			End If
		End If
	End If
	mapinfo(lev,x,y)\tpe=val
End Function

Function check_blocks(x,y)
	If y>map_height Or y<0 Then y=map_height:Return 1
	Return mapinfo(level,x,y)\tpe

End Function

Function Exit_game()
	For a.screen_object=Each screen_object
		Delete a
	Next 
	For sr.srect=Each srect
		Delete sr
	Next
	For l=0 To 20
		For y=0 To nap_width
			For x=0 To map_height
				Delete mapinfo(l,x,y)
			Next
		Next
	Next
	FreeFont font1
	FreeFont font2
End Function

Function flush_objects()
	For a.screen_object=Each screen_object
	    If a <> p1 Then 
			Delete a
		End If
	Next 
End Function

Function boxout(x,y,sz,sy)
	Color Rnd(255),Rnd(255),100
	Rect x,y,sx,sy,0
End Function

Function draw_path(pth,startx,starty)
	If pth=0 Then Return
	tx=startx
	ty=starty
	For index=1 To 1000
		If paths(pth,index)\tpe$="B" Then Color 255,255,255:Return
		Color Rnd(255),0,Rnd(255)
		Line tx,ty,tx+paths(pth,index)\dx,ty+paths(pth,index)\dy
		tx=tx+paths(pth,index)\dx
		ty=ty+paths(pth,index)\dy
	Next	
	Color 255,255,255
End Function

Function rec_new_path(pth)
	pathnum=pth
	rec=False
	quit=0
	While 1
		Cls
		Locate 0,0
		Color 200,200,200
		
		If KeyDown(209) And pathnum>1 And rec=False Then pathnum=pathnum-1:indeo=0
		If KeyDown(201) And pathnum<100 And rec=False Then pathnum=pathnum+1:indeo=0
		If indeo=0 Then
			For w=1 To 1000
				If paths(pathnum,w)\tpe$="B" Then path_length=w:Exit
				startx=MouseX()
				starty=MouseY()
			Next
		End If

		
		Print "Path Recorder.             Esc to leave         Path Number:"+pathnum
		If rec=True Then Print "Status:Recording." Else Print "Status:Inactive"
		If rec=True Then
			Print "Index Number:"+index
		Else
			If path_length<1000 Then
				Print "Path length:"+path_length
			Else
				Print "Path length:1000(MAXIMUM)"			
			End If
		End If
		Print "PGUP - path number up"
		Print "PGDWN - path number down"
		Print "Click left mouse to start recording."
		Print "Click right mouse to finish recording."
		
		Rect MouseX()-4,MouseY()-4,8,8,0
		mx=MouseX()/2*2
		my=MouseY()/2*2
		If MouseDown(1) And rec=False Then
			startx=mx
			starty=my
			ox=startx
			oy=starty
			index=1
			rec=True
			del_path(pathnum)				;erase all path info before recording
		End If
			If rec=True Then
				If ox=mx And oy=my Then
					paths(pathnum,index)\tpe$="P"
					index=index+1
				Else
					px=mx
					py=my
					paths(pathnum,index)\tpe$="M"
					paths(pathnum,index)\dx=px-ox
					paths(pathnum,index)\dy=py-oy
					index=index+1
					ox=px
					oy=py
				End If
			End If
		If MouseDown(2) Then 
			rec=False
			paths(pathnum,index)\tpe$="B"	;terminate end of path:bounce back
			path_length=index
		End If
		If rec=True And index=1000 Then		;can`t go over max
			rec=False
			paths(pathnum,index)\tpe$="B"	;terminate end of path:bounce back
			path_length=index
		End If
		tx=startx
		ty=starty
		If rec=True Then
			indeo=index
		Else
			indeo=path_length
		End If
		Color Rnd(255),Rnd(255),0
		For r=1 To indeo
			Line tx,ty,tx+paths(pathnum,r)\dx,ty+paths(pathnum,r)\dy
			tx=tx+paths(pathnum,r)\dx
			ty=ty+paths(pathnum,r)\dy
		Next
		Flip
		If KeyDown(1) Then Delay 500:quit=1:Goto ext
		If KeyDown(14) Then del_path(pathnum):indeo=0
	Wend
.ext
	If quit=1 And rec=True Then				;if quit before finished recording then erase current path
		del_path(pathnum)
		quit=0
		rec=False
	End If
End Function

Function del_path(pth)
	For a=1 To 1000
		paths(pth,a)\tpe$="B"
		paths(pth,a)\dx=0
		paths(pth,a)\dy=0
	Next
End Function
Function ret_path_len(pth)
	For a=1 To 1000
		If paths(pth,a)\tpe$="B" Then Return a
	Next
End Function

Function Drawblck(block,x,y)
Color 25,255,255
;	Locate x,y
;	Print x
;	Locate x,y+10
;	Print y
;	Locate x,y+20
;	Print block

	tx=0
	sx=x
	sy=y
	For xx=0 To 31
		Plot sx,sy+Tileheight(block,tx)
		tx=tx+1:sx=sx+1
	Next
End Function

;
;	floor selector
;
Function drawfloorsel()
	tile=1
	For y=0 To 22
		For x=0 To 31
			drawblck(tile,x*32,y*32)
			tile=+tile+1
		Next
	Next
End Function

Function EditBlock(block)
While Not KeyDown(1)
	Cls
	If KeyDown(2) And block>0 Then block=block-1:Delay 50
	If KeyDown(3) And block<1000 Then block=block+1:Delay 50
	Locate 512,0:Print "Editing Block Number:"+block
	Color 255,255,255
	drawbox(block)
	drawblck(block,512,32)
	drawblck(block+1,544,32)
	xml=MouseX():yml=MouseY()
	xm=xml/16:ym=yml/16
	If xm<32 And ym<32 Then
		If MouseDown(1) Then
			tileheight(block,xm)=ym
		End If
		Color 0,0,Rnd(255)
		Oval xm*16,ym*16,16,16
	Else
		Color 255,255,255
		Line xml,yml-7,xml,yml+8
		Line xml-7,yml,xml+8,yml
	End If
	Color 255,255,255
	Flip
Wend
Cls
Delay 500
End Function

Function drawbox(block)
Rect 0,0,32*16,32*16,0
	For x=0 To 31
		For y=0 To 31
			If tileheight(block,x)=y Then fill=1 Else fill=0
			If fill=1 Then	Rect x*16,y*16,16,16,fill
		Next
	Next
End Function

.obsdata
Data 15

;scorpion
Data "Scorpion"
Data 8,8
Data 20
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;big bee
Data "Big Bee"
Data 24,24
Data 21
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;log
Data "Log"
Data 56,8
Data 22
Data 0,-1
Data 0
Data 0
Data 0
Data 0
Data 0
;eye
Data "Mobile Eye"
Data 8,8
Data 23
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Man with gun
Data "Space Man"
Data 8,8
Data 24
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Flying dragon
Data "Flying Dragon"
Data 24,24
Data 25
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;BIG Flying dragon
Data "BIG Flying Dragon"
Data 56,40
Data 26
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Pickup Coin
Data "Coins Goal"
Data 8,8
Data 17
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Gorilla Coin
Data "Walking Gorrila"
Data -8,-48
Data 27
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Turtle Coin
Data "Slow Turtle"
Data -8,-48
Data 28
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Fly
Data "Buzzing Fly"
Data 16,16
Data 29
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;Moscy
Data "Mosquito??? dropper"
Data 16,16
Data 30
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;See saw
Data "See Saw"
Data 120,24
Data 12
Data 0,0
Data 0
Data 0
Data 0
Data 0
Data 0
;10 ton wieght
Data "10 ton weight"
Data 24,24
Data 18
Data 0,0
Data 0,0,0,0,0
;drawbridge
Data "Drawbridge facing Left"
Data 88,88
Data 103
Data 0,0
Data 0,0,0,0,0
