;
;	Scrolling platform game
;
;	Created by David Bird
;
;	e-mail dave@birdie72.freeserve.co.uk
;
;	27-09-2000
;


Global tilesize=32
Global s_width=1024
Global s_height=768
Graphics s_width,s_height												;Setup Screen
SetBuffer BackBuffer()													;and back buffer
Global goodbye=0	
Global map_tiles=CreateImage(32,32,2400)								;All the tiles for the game
Global player=LoadAnimImage("gamegfx\player\dog.bmp",32,64,0,4)			;create images for player
HandleImage player,16,64												;handle object at bottom middle

Global g_bang=CreateImage(32,32,6)										;explosions
Global g_bigbang														;bigger explosion

Global g_log=CreateImage(128,32,4)										;object 1 -
Global bad01=CreateImage(32,32,4)										;object 2 -
Global bad02=CreateImage(64,64,2)										;object 3 -
Global bad03=CreateImage(32,32,6)										;object 4 -
Global bad04=CreateImage(32,32,4)										;object 5 -
Global bad05=LoadAnimImage("gamegfx\enemies\dragon2.bmp",64,64,0,12)
Global bad06=LoadAnimImage("gamegfx\enemies\dragon2.bmp",64,64,0,12)	;Load the same file agaim but 
ResizeImage bad06,128,96												;resize it lazy I know.
Global fish=LoadAnimImage("gamegfx\enemies\fish.bmp",48,32,0,6)			;fish object just floats and kills
Global fly=LoadAnimImage("gamegfx\enemies\fly.bmp",48,48,0,12)
Global mosc=LoadAnimImage("gamegfx\enemies\moscy.bmp",48,48,0,12)
Global splat=LoadAnimImage("gamegfx\enemies\spark.bmp",32,32,0,3)

Global egg=LoadImage("gamegfx\enemies\egg.bmp")

Global bad07=LoadAnimImage("gamegfx\enemies\gorr.bmp",64,64,0,6)		;object 7 - Gorilla.
HandleImage bad07,32,64													;handle object at bottom middle
Global bad08=LoadAnimImage("gamegfx\enemies\turtle.bmp",64,64,0,6)		;object 8 - slow turtle.
HandleImage bad08,32,60 												;handle object at bottom middle
Global coin=LoadAnimImage("gamegfx\coins\coinsanim.bmp",32,32,0,8)		;coins object.
Global bullet1=LoadAnimImage("gamegfx\player\bone.bmp",32,32,0,8)


Global badbul=CreateImage(32,32,8)										;bad guys bullets
Global tellscore=CreateImage(56,32,100)									;used to display pickups value
Global watermain=CreateImage(64,64,1)									;water level object
Global bubbles=CreateImage(32,32,10)									;bubbles
Global seesaw=LoadAnimImage("gamegfx\map_tiles\seesaw.bmp",256,64,0,5)
Global drawbridge=LoadAnimImage("gamegfx\map_tiles\drawbridge.bmp",192,192,0,6)
Global s_ton=LoadAnimImage("gamegfx\map_tiles\10ton.bmp",64,64,0,2)
HandleImage s_ton,32,64

Global font1=LoadFont( "helvetica",32,True )							;load fonts 1
Global font2=LoadFont( "helvetica",16,True )							;and 2
Global font3=LoadFont( "helvetica",64,True )							;and 3

Global Backdrop=LoadImage("gamegfx\Backdrops\Backdrop1.bmp")
Global Blitzlogo=LoadImage("gamegfx\Titles\blitzlogo.bmp")
Global GameTitle=LoadImage("gamegfx\Titles\gametitle.bmp")

Global shoot=LoadSound("sounds\shoot.wav")
Global kboom=LoadSound("sounds\kazap.wav")
Global Pikup=LoadSound("sounds\mtruc.wav")
Global water=LoadSound("sounds\bubble.wav")
Global coinstocollect=0
Global fishcount=0
Global maxfish=50


Type High_Scores
	Field Score,Name$
End Type

Dim Htable.High_Scores(11)

For a=1 To 10
	Htable.High_Scores(a)=New High_Scores
Next
Htable.High_Scores(11)=New High_Scores



;
;	Object types (tpe)
;	~~~~~~~~~~~~~~~~~~
;
;	1 		- 	Controlled by player
;	2->11	-	Display of pickup score 100 to 1000
;	20		-	scorpion
;	21		-	big bee
;	22		-	none lethal bridge type object
;
;
Type screen_object	;every moving object uses this type
	Field gfx		;gfx direction 0=right 1=left
	Field stand_still
	Field lives
	Field score
	Field frame
	Field tpe		;type of object see listing of objects
	Field x,y		;position
	Field spdx		;movement speed
	Field falling
	Field jumping
	Field jumpcnt
	Field counter
	Field dx
	Field dy
	Field Air
	Field firecnt
	Field hasmoved
	Field sawjump=0
	; path information
	Field path_number	;=0 for no path to run
	Field path_index
	Field path_direction
End Type

Type path
	Field tpe$
	Field dx,dy
End Type

Dim paths.path(1000,1000)
For q=0 To 100
	For w=0 To 1000
		paths.path(q,w)=New path
		paths(q,w)\tpe$=""
		paths(q,w)\dx=0
		paths(q,w)\dy=0
	Next
Next

Type screen_block
	Field tpe
	Field value
	Field blk
End Type

Dim tileheight(1000,32)

Global map_width=128,map_height=128

Dim map(20,map_width,map_height)
Dim mapinfo.screen_block(20,map_width,map_height)
For a=0 To 20
	For y=0 To map_height
		For x=0 To map_width
			mapinfo.screen_block(a,x,y)=New screen_block
		Next
	Next
Next

Dim b(4)							;used for collision of blocks
Global max_x=map_width*32-s_width
Global max_y=map_height*32-s_height
Global level=1
Global scroll_speed=4
Global screenx,screeny
Global xfollow,yfollow
Global firecnt,ldir
Global dead							;lose control if dead

Global watercnt=3					;pause between rise
Global waterspeed=1					;amount rise each count
Global waterlevel=map_height*32
Global oldwatercnt					;temp to hold counter

CreateTiles()
;
;	Set up player1
;
Global p1.screen_object=New screen_object		;players screen object
dead=False

;
;	Load all maps for the game
;

For a=0 To 20
	For x=0 To map_height
		For y=0 To map_width
			map(a,x,y)=0
			mapinfo(a,x,y)\tpe=0
			mapinfo(a,x,y)\value=0
		Next
	Next
Next



Load_Highs()

Goto Title

;
;	Main part to the game starts here
;
.main
SetFont font1
ldir=16
t=2
level=1
var_score=0
lives=3

.levelstart
Cls
SetFont font3
Color 255,255,255
Text s_width/2,s_height/2,"LEVEL "+level,1,1
Flip

flush_objects()
load_map(level)					;loads all map information for this level
load_map_objects(level)			;loads all the objects for this level
load_paths(level)				;loads all paths for objects
Load_Tile_info()
p1\score=var_score				;carry score over from last life
floating=180
p1\path_number=0
dead=False
screenx=0:screeny=0
Global levstrt=s_height
While Not KeyDown(1)
	Cls	
	If levstrt>0 Then 
		levstrt=levstrt-8
	Else
		levsrt=0
		check_keys()
		If dead=False Then
			check_6blocks(p1)						;Only check blocks for pickups if alive makes sense when you think
			Check_for_death()
		End If
		scroll_speedx=scroll_speed
		scroll_speedy=scroll_speed
;		tx= p1\x-(s_width/2)
;		ty= (p1\y-32)-(s_height/2)
;		If tx<0 Then tx=-tx
;		If ty<0 Then ty=-ty
;		If tx<scroll_speed Then scroll_speedx=4
;		If ty<scroll_speed Then scroll_speedy=4

;		Color 255,255,255
;		Locate 0,40:Print tx+" "+ty
		If (p1\x)>s_width/2 And screenx<(map_width*32-s_width) Then 
			screenx=screenx+scroll_speedx
			p1\x=p1\x-scroll_speedx
			move_delta(-scroll_speedx,0)
		End If
	
		If (p1\x)<s_width/2 And screenx>0 Then 
			screenx=screenx-scroll_speedx
			p1\x=p1\x+scroll_speedx
			move_delta(scroll_speedx,0)
		End If
	
		If (p1\y-32)>s_height/2 And screeny<(map_height*32-s_height) Then 
			screeny=screeny+scroll_speedy
			p1\y=p1\y-scroll_speedy
			move_delta(0,-scroll_speedy)
		End If
	
		If (p1\y-32)<s_height/2 And screeny>0 Then 
			screeny=screeny-scroll_speedy
			p1\y=p1\y+scroll_speedy
			move_delta(0,scroll_speedy)
		End If
		move_objects()
	End If
	RenderMap(level,screenx,screeny)

	draw_objects()
	draw_water()
	Locate 0,60
	Print coinstocollect

	If dead=True Then
		If floating=180 Then p1\jumping=18:p1\jumpcnt=80:lives=lives-1
		floating=floating-1
		p1\gfx=Rnd(1)
		var_score=p1\score
		If floating=0 Then Goto playerdied
	End If
	Color 255,0,0
	Rect 0,ScanLine(),width,1
	Color 255,255,255
	Locate 0,0
	Print "Score:"+p1\score
	Locate s_width-200,32
	Text s_width-340,36,"Lives:",0,1
		For r=0 To lives-1
			DrawImage player,(s_width-150)+r*40,64,0
		Next
	If p1\air<1000 Then draw_airleft()

	Flip
Wend
;
;	Exit game and clear all objects and fonts in memory
;
Goto Title
End

Function draw_airleft()
	Color 255,255,255
	Rect 0,50,102,32,0
	If p1\air>500 Then Color 0,0,255
	If p1\air<500 Then Color 255,255,0
	If p1\air<100 Then Color 255,0,0
	Rect 1,51,p1\air/10,30
End Function

Function draw_water()

	watercnt=watercnt-1
	If watercnt=0 Then 
		waterlevel=waterlevel-waterspeed
		watercnt=oldwatercnt
	End If
	
	If waterlevel=-1 Then waterlevel=0
	If waterlevel-screeny<0 Then 
		strt=0
	Else
		strt=waterlevel-screeny
	End If
	For y=strt To s_height Step 64
		For r=0 To s_width Step 64
			DrawImage watermain,r,y,0
		Next
	Next
	If waterlevel < p1\y+screeny Then 						;create new fish
		If Int(Rnd(4))=2 And fishcount<maxfish Then
			temper.screen_object=New screen_object
			temper\score=400
			temper\counter=0
			temper\x=Rnd(p1\x-(s_width/2),p1\x+(s_width/2))
			temper\y=Rnd(waterlevel,map_height*32)
			temper\tpe=19
			temper\dx=Rnd(-3,3)
			If temper\dx=0 Then temper\dx=1
			temper\dy=Rnd(-3,3)
			If temper\dy=0 Then temper\dy=1
			fishcount=fishcount+1
		End If
	End If
End Function
.playerdied

If lives>0 Then Goto levelstart
	SetFont font3
	For r=1 To 400
		Color 255,255,255
		Locate 0,0
		Print "Score:"+p1\score
		Locate s_width-200,32
		Text s_width-340,36,"Lives:",0,1
		If p1\air<1000 Then draw_airleft()

		Color Rnd(255),Rnd(255),Rnd(255)
		Text s_width/2,s_height/2,"GAME OVER",1,1
		Flip
	Next
Goto title
	

;
;	All functions placed after here
;
Function RenderMap(lev, x_offset,y_offset )
;	DrawImage Backdrop,0,0,0
	lvst=levstrt
	ty=y_offset/tilesize
	sy=-(y_offset Mod tilesize)
	While sy<s_height
		ty=ty Mod map_height
		tx=x_offset/tilesize
		sx=-(x_offset Mod tilesize)
		While sx<s_width
			tile=map(lev,tx Mod map_width,ty)
			If tile>0 Then 		
				DrawImage map_tiles,sx+lvst,sy+lvst,tile
			End If
			tx=tx+1:sx=sx+tilesize
			If (tx Mod 2)=0 Then lvst=-lvst
		Wend
		lvst=-lvst
		ty=ty+1:sy=sy+tilesize
	Wend
End Function

Function Drawblck(block,x,y)
Color 25,255,255
	tx=0
	sx=x
	sy=y
	For xx=0 To 31
		Plot sx,sy+Tileheight(block,tx)
		tx=tx+1:sx=sx+1
	Next
End Function

Function CreateTiles()
	tilespic=LoadImage("gamegfx\Map_Tiles\block1.bmp")
	DrawImage tilespic,0,0,0

	Color 255,0,0
	img=1
	For y=0 To 735 Step 32
		For x=0 To 991 Step 32
			GrabImage map_tiles,x,y,img
			img=img+1
			Rect x,y,32,32,0
		Next
	Next
	Cls
	tilespic=LoadImage("gamegfx\Map_Tiles\block2.bmp")
	DrawImage tilespic,0,0,0

	Color 255,0,0
	For y=0 To 735 Step 32
		For x=0 To 991 Step 32
			GrabImage map_tiles,x,y,img
			img=img+1
			Rect x,y,32,32,0
		Next
	Next

	Cls
	SetFont font1
	d=0
	For a=1  To 10
		For r=1 To 10
			Color Rnd(255),Rnd(255),Rnd(255)
			Cls
			Text 28,16,a*100,1,1
			GrabImage tellscore,0,0,d
			d=d+1
		Next
	Next
	;
	;	load image for player etc
	;	and grab each image
	;
	tempp=LoadImage("gamegfx\player\player.bmp")
	Cls
	DrawImage tempp,0,0,0
	
	For a=0 To 3
		GrabImage bad01,a*32,64,a
		GrabImage g_log,a,160,a
		GrabImage bad04,a*32,320,a
	Next
	For a=0 To 5
		GrabImage g_bang,a*32,96,a
		GrabImage bad03,a*32,256,a
	Next
	HandleImage bad01,16,32
	HandleImage bad03,16,32
	HandleImage bad04,16,32
	
	g_bigbang=CopyImage(g_bang)				;bigger explosion
	ResizeImage g_bigbang,64,64
	For a=0 To 7
		GrabImage badbul,a*32,288,a
	Next
	For a=0 To 9
		GrabImage bubbles,a*32,352,a
	Next
	For a=0 To 1
		GrabImage bad02,a*64,192,a
	Next
	Cls
	Color 0,0,Rnd(100)+150
	tmpp=0
	For y=0 To 64 Step 2
		For x=tmpp To tmpp+64 Step 2
			Plot x,y
		Next
		tmpp=1-tmpp
	Next
	GrabImage watermain,0,0,0
	Color 255,255,255
	Cls
End Function

Function load_map_objects(lev)
	flush_objects()						;erase all objects from memory
	tempory=0
	name$="maps\map"+Str$(lev)+".obj"
	file= ReadFile(name$)
	While Not Eof(file)
		a.screen_object=New screen_object
		a\gfx=ReadInt(file)
		a\stand_still=ReadInt(file)
		a\lives=ReadInt(file)
		a\score=ReadInt(file)
		a\frame=ReadInt(file)
		a\tpe=ReadInt(file)
		a\x=ReadInt(file)
		a\y=ReadInt(file)
		a\spdx=ReadInt(file)
		a\falling=ReadInt(file)
		a\jumping=ReadInt(file)
		a\jumpcnt=ReadInt(file)
		a\counter=ReadInt(file)
		a\dx=ReadInt(file)
		a\dy=ReadInt(file)
		a\path_number=ReadInt(file)	;=0 for no path to run
		a\path_index=ReadInt(file)
		a\path_direction=ReadInt(file)
		a\path_index=1
		a\path_direction=1
		If a\tpe=17 Then
			a\frame=Rnd(5)
		End If
		If a\tpe=29 Or a\tpe=30 Then a\gfx=1
		
		If a\tpe=0 Then 
			Delete a
		Else
			If tempory=0 Then
				If a\tpe=1 Then 
					tempory=1
					loadup_player(a)
					xfollow=p1\x
					yfollow=p1\y
					Delete a
				End If
			End If
		End If
	Wend
	For r.screen_object=Each screen_object
		If r\tpe=0 Then Delete r
		If r\tpe>200 Then Delete r
	Next
End Function

Function load_map(lev)
	name$="maps\map"+Str$(lev)+".map"
	Print name$
	file = ReadFile(name$)
	For y=0 To map_height
		For x=0 To map_width
			map(lev,x,y)=ReadInt(file)
			mapinfo(lev,x,y)\tpe=ReadInt(file)
			mapinfo(lev,x,y)\value=ReadInt(file)
			mapinfo(lev,x,y)\blk=ReadInt(file)
		Next
	Next
	coinstocollect=ReadInt(file)
	watercnt=ReadInt(file)					;pause between rise
	waterspeed=ReadInt(file)				;amount rise each count
	waterlevel=ReadInt(file)				;starpoint of water at beginning of level
	oldwatercnt=watercnt					;temp to hold counter

End Function

Function load_paths(lev)
	name$="maps\map"+Str$(lev)+".pth"
	file = ReadFile(name$)
	For y=1 To 100
		For x=1 To 1000
			paths(y,x)\tpe$=ReadString(file)
			paths(y,x)\dy=ReadInt(file)
			paths(y,x)\dx=ReadInt(file)
		Next
	Next
End Function
Function Load_Tile_Info()
	file=ReadFile("TileInfo\TileHeight.plf")
	For ax=1 To 999
		For bx=0 To 31
			tileheight(ax,bx)=ReadInt(file)
		Next
	Next	
End Function


Function e_move_delta(x,y)
	For a.screen_object=Each screen_object
			a\x=a\x+x
			a\y=a\y+y
	Next
End Function

Function set_map(lev,x,y,val)
	Delay 250
	If mapinfo(lev,x,y)\tpe=val And val<>1 Then 
		mapinfo(lev,x,y)\value=mapinfo(lev,x,y)\value+100
		If mapinfo(lev,x,y)\value=1100 Then mapinfo(lev,x,y)\value=0
	End If
	mapinfo(lev,x,y)\tpe=val
End Function

Function check_for_player_push(a.screen_object,dx)
	For r.screen_object=Each screen_object
		Select r\tpe
			Case 18								;10 ton weight
			If ImagesCollide(s_ton,r\x,r\y,1,player,a\x,a\y,a\frame) And r\falling=0 Then
				side=30
				If dx<0 Then side=side * -1
				If checkpoint(level,r\x+side,r\y-16)=True Then
					If checkpoint(level,r\x+side,r\y-48)=True Then
						r\x=r\x+dx
					Else
						a\x=a\x-dx
					End If
				Else 
				a\x=a\x-dx
				End If
			End If
		End Select
	Next
End Function

Function check_keys()
	If dead=False Then
		p1\stand_still=0
		p1\hasmoved=0
		If KeyDown(200) And p1\jumping=0 And p1\jumpcnt=0 Then 
			If p1\falling=0 Then
				If checkpoint(level,p1\x-10,p1\y-66)=True Then
					If checkpoint(level,p1\x+10,p1\y-66)=True Then
						p1\jumping=36:p1\jumpcnt=80
					End If
				End If
			End If
		End If
		If KeyDown(203) Then ldir=-16:p1\gfx=0:p1\stand_still=1
		If KeyDown(205) Then ldir=16:p1\gfx=1:p1\stand_still=1
		If KeyDown(205) And (((screenx+p1\x)+16)/32)<map_width  Then
			If checkpoint(level,p1\x+17,p1\y-1)=True Then
				If checkpoint(level,p1\x+17,p1\y-32)=True Then
					If checkpoint(level,p1\x+17,p1\y-63)=True Then
						If ((p1\x+screenx) Mod 32)=32-p1\spdx
							If ret_blk(level,p1\x+p1\spdx,p1\y-16)=10 Then
								p1\y=p1\y-8
							End If
						End If
						p1\x=p1\x+p1\spdx
						check_for_player_push(p1,p1\spdx)
					End If
				End If
			End If
		End If
		
		If KeyDown(203) And screenx+p1\x>16 Then 
			If checkpoint(level,p1\x-17,p1\y-1)=True Then
				If checkpoint(level,p1\x-17,p1\y-32)=True Then
					If checkpoint(level,p1\x-17,p1\y-63)=True Then
						If ((p1\x+screenx) Mod 32)=0
							If ret_blk(level,p1\x-2,p1\y-16)=10 Then
								p1\y=p1\y-8
							End If
						End If
						p1\x=p1\x-p1\spdx
						check_for_player_push(p1,-p1\spdx)
					End If
				End If
			End If
		End If
		;
		;	control player firing
		;
		If firecnt>0 Then firecnt=firecnt-1
		If KeyDown(205) And KeyDown(29) Then
			If firecnt=0
				temper.screen_object=New screen_object
				temper\tpe=13
				temper\x=p1\x+16
				temper\y=p1\y-40
				temper\counter=40
				temper\air=4
				temper\dx=16
				ldir=16
				firecnt=10
			End If
		End If
		If KeyDown(203) And KeyDown(29) Then
			If firecnt=0 Then
				temper.screen_object=New screen_object
				temper\tpe=13
				temper\x=p1\x-16
				temper\y=p1\y-40
				temper\counter=40
				temper\air=4
				temper\dx=-16
				ldir=-16
				firecnt=10
			End If
		End If
		If KeyDown(29) And firecnt=0 Then
			temper.screen_object=New screen_object
			temper\tpe=13
			If ldir>0 Then
				temper\x=p1\x+16
			Else
				temper\x=p1\x-16
			End If
			temper\y=p1\y-40
			temper\counter=40
			temper\dx=ldir
			firecnt=10
		End If
	End If
	
	;
	;	system keys
	;
	If KeyDown(2) Then
		temper.screen_object=New screen_object
		temper\tpe=19
		temper\path_number=0
		temper\x=Rnd(-100,s_width+100)
		temper\y=Rnd(-100,s_height+100)
		temper\dx=1
		temper\dy=0
		temper\spdx=8
	End If
End Function

Function draw_objects()
	For a.screen_object=Each screen_object
	 If a\x>-200 And a\x<s_width+200 Then				;Only draw objects if
	  If a\y>-200 And a\y<s_height+200 Then				;within range of screen
		Select a\tpe
			Case 2										;100 pnts
				DrawImage tellscore,a\x,a\y,Rnd(10)
			Case 3										;200 pnts
				DrawImage tellscore,a\x,a\y,Rnd(10,20)
			Case 4										;300 pnts
				DrawImage tellscore,a\x,a\y,Rnd(20,30)
			Case 5										;400 pnts
				DrawImage tellscore,a\x,a\y,Rnd(30,40)
			Case 6										;500 pnts
				DrawImage tellscore,a\x,a\y,Rnd(40,50)
			Case 7										;600 pnts
				DrawImage tellscore,a\x,a\y,Rnd(50,60)	
			Case 8										;700 pnts
				DrawImage tellscore,a\x,a\y,Rnd(60,70)	
			Case 9										;800 pnts
				DrawImage tellscore,a\x,a\y,Rnd(70,80)
			Case 10										;900 pnts
				DrawImage tellscore,a\x,a\y,Rnd(80,90)	
			Case 11										;1000 pnts
				DrawImage tellscore,a\x,a\y,Rnd(90,100)	
			Case 12										;seesaw for puzzles
				DrawImage seesaw,a\x,a\y,a\frame
			Case 13										;players bone
				DrawImage bullet1,a\x,a\y,a\frame
			Case 14										;explosions
				DrawImage g_bang,a\x,a\y,a\frame
			Case 15
				DrawImage g_bigbang,a\x,a\y,a\frame		;larger explosion
			Case 16
				DrawImage bubbles,a\x,a\y,a\frame
			Case 17										;goal object coins
				DrawImage coin,a\x,a\y,a\frame
			Case 18										;10 ton wieght
				DrawImage s_ton,a\x,a\y,0
			Case 19										;killer fish
				image=a\frame*2+a\gfx
				DrawImage fish,a\x,a\y,image
			Case 20										;scorpion bad01
				image=a\gfx*2+a\frame
				DrawImage bad01,a\x,a\y,image
			Case 21
				DrawImage bad02,a\x,a\y,a\frame
			Case 22										;non leathal log
				DrawImage g_log,a\x,a\y,a\frame
			Case 23										;Mobile eye
				image=a\gfx*2+a\frame
				DrawImage bad03,a\x,a\y,image
			Case 24										;man with gun
				image=a\gfx*2+a\frame
				DrawImage bad04,a\x,a\y,image
			Case 25										;dragon
				image=(a\frame*2)+a\gfx
				DrawImage bad05,a\x,a\y,image
			Case 26										;big dragon
				image=(a\frame*2)+a\gfx
				DrawImage bad06,a\x,a\y,image
			Case 27										;Gorrila
				image=a\frame*2+a\gfx
				DrawImage bad07,a\x,a\y,image
			Case 28										;Turtle
				image=(a\frame*2)+a\gfx
				DrawImage bad08,a\x,a\y,image
			Case 29										;fly
				image=a\frame*2+a\gfx
				DrawImage fly,a\x,a\y,image
			Case 30										;moscy
				image=(a\frame*2)+a\gfx
				DrawImage mosc,a\x,a\y,image
			Case 100
				image=a\gfx*2+a\frame
				DrawImage badbul,a\x,a\y,image
			Case 101									;killer egg
				DrawImage egg,a\x,a\y,0
			Case 102									;egg splat
				DrawImage splat,a\x+Rnd(-16,16),a\y+Rnd(-4,16),a\frame
			Case 103
				DrawImage drawbridge,a\x,a\y,a\frame
		End Select
	   End If
	  End If
	Next
	;
	;	Draw player object last so that its on top
	;
	If p1\stand_still=0 Then
		image=p1\gfx*2
	Else
		image=p1\gfx*2+p1\frame
	End If
	DrawImage player,p1\x,p1\y,image

End Function
;
;	Simple function
;
Function check_blocks(x,y)
	If y>map_height Or y<0 Then y=map_height:Return 1
	Return mapinfo(level,x,y)\tpe
End Function

Function move_objects()
	For a.screen_object=Each screen_object
		Select a\tpe
			Case 1
				control_player(a)
			Case 2					;move image for points indicator 100
				control_pnts(a)
			Case 3					;move image for points indicator 200
				control_pnts(a)
			Case 4					;move image for points indicator 300
				control_pnts(a)
			Case 5					;move image for points indicator 400
				control_pnts(a)
			Case 6					;move image for points indicator 500
				control_pnts(a)
			Case 7					;move image for points indicator 600
				control_pnts(a)
			Case 8					;move image for points indicator 700
				control_pnts(a)
			Case 9					;move image for points indicator 800
				control_pnts(a)
			Case 10					;move image for points indicator 900
				control_pnts(a)
			Case 11					;move image for points indicator 1000
				control_pnts(a)
			Case 12					;control seesaw
				control_seesaw(a)
			Case 13					;moves bullet fired from player
				control_bullet1(a)
			Case 14					;controls explosions effect
				control_explosion(a)
			Case 15					;controls bigger explosions
				control_explosion(a)
			Case 16					;controls the movement of bubbles in water
				control_bubbles(a)
			Case 17					;control coins on screen
				control_coins(a)
			Case 18					;10 ton weight
				control_10ton(a)
			Case 19					;fish in the water
				control_fish(a)
			Case 20					;move scorpion
				control_bad01(a)
			Case 21					;move big bee
				control_bad02(a)
			Case 22					;move image for non lethal logs		
				control_logs(a)
			Case 23					;control eye
				control_eye(a)
			Case 24					;Man with gun
				control_bad04(a)
			Case 25					;Dragon	that only follow a path
				control_bad05(a)
			Case 26					;Big Dragon that only follow a path
				control_bad06(a)
			Case 27					;Gorrila
				control_bad07(a)
			Case 28					;Turtle
				control_bad08(a)
			Case 29					;fly - use the same as big bee
				control_fly(a)
			Case 30					;mosc - use the same as big bee
				control_moscy(a)
			Case 100				;control bad bullet
				control_badbull(a)
			Case 101				;egg object just kills
				control_egg(a)
			Case 102				;egg hit ground
				control_eggsplat(a)
			Case 103
				control_drawbridge(a)
		End Select
	Next
End Function

Function control_drawbridge(a.screen_object)
	x=p1\x-a\x
	y=p1\y-a\y
	x=x*x
	y=y*y
	range=Sqr(x+y)
	If range>200 Then
		If a\counter=0 Then
			a\counter=5
			a\frame=a\frame-1
			If a\frame=-1 Then 
				a\frame=0
				For r=0 To 5
					mapinfo(level,((a\x+screenx)/32)+4,((a\y+screeny)/32)+r)\tpe=0
				Next
				For r=1 To 4
					mapinfo(level,((a\x+screenx)/32)+r,((a\y+screeny)/32)+5)\tpe=1
				Next
			End If
		End If
	Else
		If a\counter=0 Then
			a\counter=5
			a\frame=a\frame+1
			If a\frame=6 Then 
				a\frame=5
				For r=1 To 4
					mapinfo(level,((a\x+screenx)/32)+r,((a\y+screeny)/32)+5)\tpe=0
				Next
				For r=0 To 5
					mapinfo(level,((a\x+screenx)/32)+4,((a\y+screeny)/32)+r)\tpe=1
				Next
			End If
		End If
	End If
	a\counter=a\counter-1
End Function

Function control_player(a.screen_object)
		If a\counter=0 Then 
			a\counter=10:a\frame=1-a\frame
		End If
		a\counter=a\counter-1
		If (a\counter)=0 Then
			If (a\y+screeny-56)>waterlevel Then						;create bubbles if under water
				temper.screen_object=New screen_object				;and decrease air
				temper\tpe=16
				temper\x=a\x+Rnd(-26,-6)
				temper\y=a\y-70
				temper\frame=Int(Rnd(8))
				temper\counter=0
				If (a\air Mod 90)=0 Then PlaySound water
				If a\air<=0 Then
					dead=True
				Else
;					a\air=a\air-5									;only disabled for testing
				End If
			Else
				If a\air<1000 Then a\air=a\air+5
				If a\air>1000 Then a\air=1000
			End If
		End If
		;
		;	Altered collision of blocks for using height map tiles
		;
		If a\jumpcnt>0 Then a\jumpcnt=a\jumpcnt-1
		If a\jumping=0 Then											;check for falling if not jumping
			Checkfall(level,a)	
		Else
			If checkpoint(level,a\x-15,a\y-66)=True Then
				If checkpoint(level,a\x+15,a\y-66)=True Then
					a\y=a\y-a\spdx
					a\jumping=a\jumping-1
					If a\jumping=0 Then a\falling=1
				Else
					a\jumping=0
					a\jumpcnt=0
					a\falling=1
				End If
			Else
				a\jumping=0
				a\jumpcnt=0
				a\falling=1
			End If
		End If
End Function

Function control_fish(a.screen_object)
	If a\counter=0 Then 
		a\counter=4
		a\frame=a\frame+1
		If a\frame=3 Then 
			a\frame=0
		End If
	End If
	a\counter=a\counter-1
	
	a\x=a\x+a\dx
	a\y=a\y+a\dy
	If a\dx>0 Then a\gfx=0 Else a\gfx=1
	
	xx=a\x+screenx:yy=a\y+screeny
	If xx>(map_width*32)-48 Or xx<0 Then a\dx=-a\dx
	If yy>(map_height*32)-32 Or yy<waterlevel Then a\dy=-a\dy
	If Rnd(4)=2 Then a\dx=-a\dx				; Put a bit of random movement in x
	If Rnd(9)=5 Then a\dy=-a\dy				; Put a bit of random movement in y
	If Int(Rnd(30))=5 Then 						; Randomly create bubble
		temper.screen_object=New screen_object				;and decrease air
		temper\tpe=16
		temper\x=a\x
		temper\y=a\y-40
		temper\frame=Int(Rnd(8))
		temper\counter=0
	End If
End Function

Function control_10ton(a.screen_object)
	;
	;	Check if player is on top
	;
	If dead=False Then
		If p1\jumping=0 And p1\falling=1 Then
			If ImagesCollide(s_ton,a\x,a\y,1,player,p1\x,p1\y+6,image) Then
				p1\falling=0
				p1\y=a\y-44
				p1\y=p1\y-p1\spdx
				p1\jumpcnt=0
			End If
		End If
	End If

	a\spdx=4														;speed of the 10 ton weight
		If a\jumpcnt>0 Then a\jumpcnt=a\jumpcnt-1
		If a\jumping=0 Then											;check for falling if not jumping
			CheckObjectfall(level,a)	
		Else
			If checkpoint(level,a\x-15,a\y-66)=True Then
				If checkpoint(level,a\x+15,a\y-66)=True Then
					a\y=a\y-a\spdx
					a\jumping=a\jumping-1
					If a\jumping=0 Then a\falling=1
				Else
					a\jumping=0
					a\jumpcnt=0
					a\falling=1
				End If
			Else
				a\jumping=0
				a\jumpcnt=0
				a\falling=1
			End If
		End If

	For r.screen_object=Each screen_object
		If r\tpe=12 Then
			If ImagesCollide(seesaw,r\x,r\y,r\frame,s_ton,a\x,a\y,0) Then
				;if falling onto a seesaw on theright side set it off moving
				If a\falling<>0 Then
					If a\x<r\x+64 And r\frame = 4 Then 			;on left handside and left is down
						r\frame=3
						r\sawjump=1								;tell engine hit left side
						;check if an object is on the other side
						
						If p1\sawjump=2 Then					;if player is on otherside catapult them
							p1\jumping=70:p1\jumpcnt=80			;make player jump
						End If
					Else 
						If a\x>r\x+192 And r\frame = 0 Then 	;on righthand side and right is down
							r\frame = 1
							r\sawjump=2 						; tell engine hit right side
							;check if an object is on the other side
							
							If p1\sawjump=1 Then				;if player is on otherside catapult them
								p1\jumping=70:p1\jumpcnt=80		;make player jump
							End If
						End If
					End If
				End If

				;check if we`re ready to be catapulted
				If a\x<r\x+64 And r\frame = 0 Then ;on left handside and left is down
					a\sawjump=1
				Else 
					If a\x>r\x+192 And r\frame = 4 Then ;on righthand side and right is down
						a\sawjump=2
					End If
				End If
			End If
		End If
	Next
End Function

Function control_seesaw(a.screen_object)
	If a\sawjump=1 Then 								;hit right side
		If a\frame>2 Then 								;control left side
			If a\frame=3 And a\counter= 0 Then			;if only just been hit then check for object on side 2
				For r.screen_object=Each screen_object
					If r\tpe=18 And ImagesCollide(seesaw,a\x,a\y,a\frame,s_ton,r\x,r\y,0) Then 
						If r\falling=0
							If r\x>a\x+192 Then ;on left handside and left is down
								r\jumping=30:r\jumpcnt=80	;make object jump
							End If
						End If
					End If
				Next
			End If
			a\counter=a\counter+1
			If a\counter=2 Then a\frame=a\frame-1:a\counter=0
		Else									;control left side
			a\counter=a\counter+1
			If a\counter=2 Then 
				a\frame=a\frame-1:a\counter=0
				If a\frame=0 Then a\sawjump=0
			End If
		End If
	Else										;must have hit right side
		If a\frame=1 And a\counter =0 Then		;if only just been hit then check for object on side 2
			For r.screen_object=Each screen_object
				If r\tpe=18 And ImagesCollide(seesaw,a\x,a\y,a\frame,s_ton,r\x,r\y,0) Then 
					If r\x<a\x+64 Then ;on left handside and left is down
						r\jumping=30:r\jumpcnt=80	;make object jump
					End If
				End If
			Next
		End If
		If a\sawjump=2 Then
			If a\frame>2 Then 						;control left side
				a\counter=a\counter+1
				If a\counter=2 Then 
					a\frame=a\frame+1:a\counter=0
					If a\frame=4 Then a\sawjump=0
				End If
			Else									;control left side
				a\counter=a\counter+1
				If a\counter=2 Then a\frame=a\frame+1:a\counter=0
			End If
		End If
	End If
End Function

Function control_coins(a.screen_object)
	If a\counter=0 Then 
		a\counter=4
		a\frame=a\frame+1
		If a\frame=8 Then a\frame=0
	End If
	a\counter=a\counter-1
	If a\hasmoved=0 Then
		If a\path_number>0 Then
			run_path(a)
		End If
	Else			;if its been picked up
		If a\hasmoved=20 Then PlaySound Pikup
		a\y=a\y-(20-a\hasmoved)
		a\hasmoved=a\hasmoved-1
		If a\hasmoved=1 Then Delete a
	End If
End Function

Function control_bubbles(a.screen_object)
	a\y=a\y-4
	a\counter=a\counter+1
	If a\counter=100 Or a\y<waterlevel-screeny Then Delete a
End Function

Function control_badbull(a.screen_object)
	Del=0
	a\counter=a\counter+1
	If a\counter=10 Then a\counter=0:a\frame=1-a\frame
	If a\dx<0 Then a\gfx=1
	If a\dx>0 Then a\gfx=0
	If a\dy>0 Then a\gfx=3
	If a\dy<0 Then a\gfx=2
	a\x=a\x+(a\dx*a\spdx)
	a\y=a\y+(a\dy*a\spdx)
	a\jumping=a\jumping+1
	If a\jumping=60 Then Del=1
	b1=check_blocks((screenx+a\x)/32,(screeny+a\y)/32)
	;Can`t shoot through solid walls
	If check_em(b1)=False Then Del=1
	If Del=1 Then Delete a
End Function

Function control_pnts(a.screen_object)
	If a\jumping=0 Then Delete a:Return
	a\y=a\y-2
	a\jumping=a\jumping-1
End Function

Function control_logs(a.screen_object)
	If a\path_number=0 Then								;if there is a path assigned run it
		scnx=a\x+screenx:scny=a\y+screeny
		If (scnx Mod 32)=0 Then d=3 Else d=4
			For q=0 To d
				blkx=(scnx/32)+q
				blky=(scny/32)+1
				bt=check_blocks(blkx,blky)
				If check_em(bt)=False Then a\falling=2
			Next 

		If a\falling=1 Then
			a\y=a\y+4
			a\jumpcnt=a\jumpcnt+1
		End If
		If a\jumpcnt=30 Then a\jumpcnt=0:a\falling=0;Delete a
	Else
		run_path(a)
	End If
	image=p1\gfx*2+p1\frame
	If dead=False Then
		If p1\jumping=0 Then
			If ImagesCollide(g_log,a\x,a\y,0,player,p1\x,p1\y+16,image) Then
				p1\falling=0
				p1\y=a\y
				a\falling=1
				p1\jumpcnt=0
				p1\path_number=0
				p1\path_index=0
				p1\path_direction=0
			End If
		End If
	End If
End Function

Function control_bullet1(a.screen_object)
	If a\air=0 Then
		a\air=2
		a\frame=a\frame+1
		If a\frame=8 Then a\frame=0
	End If
	a\air=a\air-1
	
  For r.screen_object=Each screen_object
	Select r\tpe
		Case 19									;fish in the water
			image=r\frame*2+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,fish,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					fishcount=fishcount-1												;give it a score + playsound
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 20									;scorpion bad01
			image=r\gfx*2+r\frame
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad01,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 21									;big bee
			image=r\frame
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad02,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 23									;mobile eye
			image=r\gfx*2+r\frame
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad03,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 24									;Man with gun
			image=r\gfx*2+r\frame
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad04,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 25									;Dragon	that only follow a path
			image=(r\frame*2)+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad05,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 26									;Big Dragon that only follow a path
			image=(r\frame*2)+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad06,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 27									;Gorrila
			image=(r\frame*2)+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad07,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x-32
					r\y=r\y-48
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x-32
					temper\y=r\y-48
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 28									;Turtle
			image=(r\frame*2)+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,bad08,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x-32
					r\y=r\y-48
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x-32
					temper\y=r\y-48
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 29									;fly
			image=(r\frame*2)+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,fly,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					fishcount=fishcount-1												;give it a score + playsound
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Case 30									;moscy
			image=(r\frame*2)+r\gfx
			If ImagesCollide(bullet1,a\x,a\y,a\frame,mosc,r\x,r\y,image)
				If r\lives=0 Then 													;if not got any lives
					r\tpe=15															
					r\counter=0
					r\frame=0
					r\x=r\x
					r\y=r\y
					PlaySound kboom	
					Delete a:Return													;delete bullet & return
				Else 
					temper.screen_object=New screen_object
					temper\tpe=15
					temper\x=r\x
					temper\y=r\y
					temper\frame=0
					r\lives=r\lives-1
					Delete a:Return
				End If
			End If
		Default
			image=0
		End Select
	Next

	If a\counter=40 Then PlaySound shoot
	If a\counter=0 Then Delete a:Return
	a\x=a\x+a\dx
	a\y=a\y+a\dy
	a\counter=a\counter-1
	b1=check_blocks((screenx+a\x)/32,(screeny+a\y)/32)
	;Can`t shoot through solid walls
	If check_em(b1)=False Then Delete a
End Function

Function control_fly(a.screen_object)
	If a\counter=0 Then
		a\frame=a\frame+1
		If a\frame=6 Then a\frame=0
		a\counter=10
	End If
	a\counter=a\counter-1
		
	If a\path_number=0 Then
		a\x=a\x+a\spdx
		If a\dx=0 Then
			a\dx=160
			a\spdx=-a\spdx
			a\gfx=1-a\gfx
		End If
		a\dx=a\dx-1
	Else
		run_path(a)
	End If
End Function

Function control_moscy(a.screen_object)
	If a\counter=0 Then
		a\frame=a\frame+1
		If a\frame=6 Then a\frame=0
		a\counter=10
		; check ifplayer is roughly underneath
		If a\x<p1\x And a\x+32>p1\x Then		;is within one block in x
			If a\y<p1\y And a\y+400>p1\y Then   ;is within 400 pixels fire an egg
				temper.screen_object=New screen_object
				temper\tpe=101
				temper\x=a\x+24
				temper\y=a\y+48
			End If
		End If
	End If
	a\counter=a\counter-1
	If a\path_number=0 Then
		a\x=a\x+a\spdx
		If a\dx=0 Then
			a\dx=160
			a\spdx=-a\spdx
			a\gfx=1-a\gfx
		End If
		a\dx=a\dx-1
	Else
		run_path(a)
	End If
End Function

Function control_egg(a.screen_object)
	If checkpoint(level,a\x+10,a\y+30)=False Then ;If hit floor end its life
		a\tpe=102	;turn into splat
		a\counter=3
		a\dx=0
		;a\x=a\x-2
		;a\y=a\y+10
		Return
	End If
	a\y=a\y+4
End Function

Function control_eggsplat(a.screen_object)
	If a\counter=0 Then
		a\counter=3
		a\frame=a\frame+1
		If a\frame=3 Then a\frame=0
		a\dx=a\dx+1
		If a\dx=10 Then Delete a:Return
	End If
	a\counter=a\counter-1
End Function

Function control_bad01(a.screen_object)
	If a\counter=0 Then a\counter=10:a\frame=1-a\frame
	a\counter=a\counter-1
	If a\dx=0 Then a\dx=1
	on_object=False
	If a\x>-200 And a\x<s_width+200 Then				;Only check object if
		If a\y>-200 And a\y<s_height+200 Then			;within range of screen
			If a\path_number=0 Then 
				For coll.screen_object=Each screen_object
					If coll<>a Then
						If coll\tpe=22 Then
							If ImagesCollide(g_log,coll\x,coll\y,coll\frame,bad01,a\x,a\y+32,a\frame) Then
								on_object=True
								a\y=coll\y
							End If
						End If
					End If
				Next
			End If
			If a\path_number=0 Then								;if there is a path assigned run it
				If checkobjectfall(level,a)=False Or on_object=True Then
					If a\dx>0 Then
						If checkpoint(level,a\x+17,a\y-1)=True Then
							If checkpoint(level,a\x+17,a\y-16)=True Then
								If checkpoint(level,a\x+17,a\y-31)=True Then
									If ((a\x+screenx) Mod 32)=32-a\spdx
										If ret_blk(level,a\x+a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x+a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					Else
						If checkpoint(level,a\x-17,a\y-1)=True Then
							If checkpoint(level,a\x-17,a\y-16)=True Then
								If checkpoint(level,a\x-17,a\y-15)=True Then
									If ((a\x+screenx) Mod 32)=0
										If ret_blk(level,a\x-a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x-a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					End If
				End If

				If blky>map_height-1 Then Delete a:Return
			Else
				run_path(a)
			End If
		End If
	End If
	If a\dx<0 Then a\gfx=1
	If a\dx>0 Then a\gfx=0
End Function
Function control_bad02(a.screen_object)						;large floating bee
	If a\counter=0 Then a\frame=1-a\frame:a\counter=5
	a\counter=a\counter-1
	If a\path_number=0 Then														;if there is a path assigned run it
		;
		;	Move in a random way
		;	problem to sort out later
		;	objects may stray off edge of map
		;
		If a\dx=0 Then 
			a\dx=Rnd(-10,10)
		End If
		If a\dy=0 Then
			a\dy=Rnd(-10,10)
		End If
		
		If a\dx<0 Then
			a\x=a\x-1:a\dx=a\dx+1
		End If
		If a\dy<0 Then
			a\y=a\y-1:a\dy=a\dy+1
		End If
		If a\dx>0 Then
			a\x=a\x+1:a\dx=a\dx-1
		End If
		If a\dy>0 Then
			a\y=a\y+1:a\dy=a\dy-1
		End If
	Else
		run_path(a)
	End If
End Function
Function control_eye(a.screen_object)
	If a\counter=0 Then a\counter=10:a\frame=1-a\frame
	a\counter=a\counter-1
	If a\dx=0 Then a\dx=1
	on_object=False
	If a\x>-200 And a\x<s_width+200 Then				;Only check object if
		If a\y>-200 And a\y<s_height+200 Then			;within range of screen
			If a\path_number=0 Then 
				For coll.screen_object=Each screen_object
					If coll<>a Then
						If coll\tpe=22 Then
							If ImagesCollide(g_log,coll\x,coll\y,coll\frame,bad03,a\x,a\y+32,a\frame) Then
								on_object=True
								a\y=coll\y
							End If
						End If
					End If
				Next
			End If
			If a\path_number=0 Then								;if there is a path assigned run it
				If checkobjectfall(level,a)=False Or on_object=True Then
					If a\dx>0 Then
						If checkpoint(level,a\x+17,a\y-1)=True Then
							If checkpoint(level,a\x+17,a\y-16)=True Then
								If checkpoint(level,a\x+17,a\y-31)=True Then
									If ((a\x+screenx) Mod 32)=32-a\spdx
										If ret_blk(level,a\x+a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x+a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					Else
						If checkpoint(level,a\x-17,a\y-1)=True Then
							If checkpoint(level,a\x-17,a\y-16)=True Then
								If checkpoint(level,a\x-17,a\y-15)=True Then
									If ((a\x+screenx) Mod 32)=0
										If ret_blk(level,a\x-a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x-a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					End If
				End If

				If blky>map_height-1 Then Delete a:Return
			Else
				run_path(a)
			End If
		End If
	End If
	If a\dx<0 Then a\gfx=1
	If a\dx>0 Then a\gfx=0
End Function
Function control_bad04(a.screen_object)
	If a\counter=0 Then a\counter=10:a\frame=1-a\frame
	a\counter=a\counter-1
	If a\dx=0 Then a\dx=1
	on_object=False
	If a\x>-200 And a\x<s_width+200 Then				;Only check object if
		If a\y>-200 And a\y<s_height+200 Then			;within range of screen
			If a\path_number=0 Then 
				For coll.screen_object=Each screen_object
					If coll<>a Then
						If coll\tpe=22 Then
							If ImagesCollide(g_log,coll\x,coll\y,coll\frame,bad04,a\x,a\y+32,a\frame) Then
								on_object=True
								a\y=coll\y
							End If
						End If
					End If
				Next
			End If
			If a\path_number=0 Then								;if there is a path assigned run it
				If checkobjectfall(level,a)=False Or on_object=True Then
					If a\dx>0 Then
						If checkpoint(level,a\x+17,a\y-1)=True Then
							If checkpoint(level,a\x+17,a\y-16)=True Then
								If checkpoint(level,a\x+17,a\y-31)=True Then
									If ((a\x+screenx) Mod 32)=32-a\spdx
										If ret_blk(level,a\x+a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x+a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					Else
						If checkpoint(level,a\x-17,a\y-1)=True Then
							If checkpoint(level,a\x-17,a\y-16)=True Then
								If checkpoint(level,a\x-17,a\y-15)=True Then
									If ((a\x+screenx) Mod 32)=0
										If ret_blk(level,a\x-a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x-a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					End If
				End If

				If blky>map_height-1 Then Delete a:Return
			Else
				run_path(a)
			End If
		End If
	End If
	If a\dx<0 Then a\gfx=0
	If a\dx>0 Then a\gfx=1
End Function
Function control_bad05(a.screen_object)						;flying dragon
	If a\counter=0 Then 
		a\frame=a\frame+1
		If a\frame=6 Then a\frame=0
		a\counter=5
	End If
	a\counter=a\counter-1
	run_path(a)
End Function
Function control_bad06(a.screen_object)						;large flying dragon
	If a\counter=0 Then 
		a\frame=a\frame+1
		If a\frame=6 Then a\frame=0
		a\counter=5
	End If
	a\counter=a\counter-1
	run_path(a)
End Function
Function control_bad07(a.screen_object)
	If a\counter=0 Then 
		a\counter=10
		a\frame=a\frame+1
		If a\frame>=3 Then a\frame=0
	End If
	
	a\counter=a\counter-1
	If a\dx=0 Then a\dx=1
	on_object=False
	If a\x>-200 And a\x<s_width+200 Then				;Only check object if
		If a\y>-200 And a\y<s_height+200 Then			;within range of screen
			If a\path_number=0 Then 
				For coll.screen_object=Each screen_object
					If coll<>a Then
						If coll\tpe=22 Then
							If ImagesCollide(g_log,coll\x,coll\y,coll\frame,bad07,a\x,a\y+32,a\frame) Then
								on_object=True
								a\y=coll\y
							End If
						End If
					End If
				Next
			End If
			If a\path_number=0 Then								;if there is a path assigned run it
				If checkobjectfall(level,a)=False Or on_object=True Then
					If a\dx>0 Then
						If checkpoint(level,a\x+17,a\y-1)=True Then
							If checkpoint(level,a\x+17,a\y-31)=True Then
								If checkpoint(level,a\x+17,a\y-63)=True Then
									If ((a\x+screenx) Mod 32)=32-a\spdx
										If ret_blk(level,a\x+a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x+a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					Else
						If checkpoint(level,a\x-17,a\y-1)=True Then
							If checkpoint(level,a\x-17,a\y-31)=True Then
								If checkpoint(level,a\x-17,a\y-63)=True Then
									If ((a\x+screenx) Mod 32)=0
										If ret_blk(level,a\x-a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x-a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					End If
				End If

				If blky>map_height-1 Then Delete a:Return
			Else
				run_path(a)
			End If
		End If
	End If
	If a\dx<0 Then a\gfx=0
	If a\dx>0 Then a\gfx=1
End Function
Function control_bad08(a.screen_object)
	If a\counter=0 Then 
		a\counter=10
		a\frame=a\frame+1
		If a\frame>=3 Then a\frame=0
	End If
	a\counter=a\counter-1
	If a\dx=0 Then a\dx=1
	on_object=False
	If a\x>-200 And a\x<s_width+200 Then				;Only check object if
		If a\y>-200 And a\y<s_height+200 Then			;within range of screen
			If a\path_number=0 Then 
				For coll.screen_object=Each screen_object
					If coll<>a Then
						If coll\tpe=22 Then
							If ImagesCollide(g_log,coll\x,coll\y,coll\frame,bad08,a\x,a\y+32,a\frame) Then
								on_object=True
								a\y=coll\y
							End If
						End If
					End If
				Next
			End If
			If a\path_number=0 Then								;if there is a path assigned run it
				If checkobjectfall(level,a)=False Or on_object=True Then
					If a\dx>0 Then
						If checkpoint(level,a\x+17,a\y-1)=True Then
							If checkpoint(level,a\x+17,a\y-31)=True Then
								If checkpoint(level,a\x+17,a\y-61)=True Then
									If ((a\x+screenx) Mod 32)=32-a\spdx
										If ret_blk(level,a\x+a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x+a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					Else
						If checkpoint(level,a\x-17,a\y-1)=True Then
							If checkpoint(level,a\x-17,a\y-31)=True Then
								If checkpoint(level,a\x-17,a\y-61)=True Then
									If ((a\x+screenx) Mod 32)=0
										If ret_blk(level,a\x-a\spdx,a\y-16)=10 Then
											a\y=a\y-2
										End If
									End If
									a\x=a\x-a\spdx
								Else
									a\dx=-a\dx
								End If
							Else
								a\dx=-a\dx
							End If
						Else
							a\dx=-a\dx
						End If
					End If
				End If

				If blky>map_height-1 Then Delete a:Return
			Else
				run_path(a)
			End If
		End If
	End If
	If a\dx<0 Then a\gfx=0
	If a\dx>0 Then a\gfx=1
End Function

Function control_explosion(a.screen_object)				;	explosion function.
	If a\frame=0 And a\counter=0 Then					;	~~~~~~~~~~~~~~~~~~~
		If a\score>0 Then								;
			p1\score=p1\score+a\score					;	some objects when killed gives player a value
			; Indicate to player that they have scored	;	to add to there score;
			tester.screen_object=New screen_object		;	create a new points object
			tester\tpe=1+(a\score/100)					;
			tester\x=a\x-9								;
			tester\y=a\y								;
			tester\jumping=40							;
		End If											;
	End If												;
	a\counter=a\counter+1								;
	If a\counter=10 Then 								;
		a\counter=0										;
		a\frame=a\frame+1								;
		If a\frame=6 Then 								;
			Delete a:Return								;
		End If											;
	End If												;
End Function											;

Function check_em(block)
	If block=0 Or (block>=2 And block<7) Then Return True
	Return False
End Function

Function check_6blocks(a.screen_object)
	tmpx=(screenx+a\x):tmpy=(screeny+a\y)
	cx=-10
	For y=0 To 64 Step 32
		For x=0 To 1
			tle=mapinfo(level,(tmpx+cx)/32,(tmpy-y)/32)\tpe
			val=mapinfo(level,(tmpx+cx)/32,(tmpy-y)/32)\value
			If tle=6 Then 							;Death Object
				PlaySound kboom
				dead=True
			End If
			If tle>=3 And tle<=5 Then
				mapinfo(level,(tmpx+cx)/32,(tmpy-y)/32)\tpe=0
				mapinfo(level,(tmpx+cx)/32,(tmpy-y)/32)\value=0
				map(level,(tmpx+cx)/32,(tmpy-y)/32)=0
				If val>0 Then
					a\score=a\score+val
					; Indicate to player that they have scored
					tester.screen_object=New screen_object
					tester\tpe=1+(val/100)
					tester\x=a\x/32*32+(x*32)
					tester\y=a\y
					tester\jumping=40
					PlaySound Pikup
				End If
			End If 
			cx=-cx
		Next
	Next
End Function

Function move_delta(x,y)
	For a.screen_object=Each screen_object
		If a\tpe<>1 Then
			a\x=a\x+x
			a\y=a\y+y
		End If
	Next
End Function

Function Exit_game()
	For a.screen_object=Each screen_object
		Delete a
	Next 
	For l=0 To 20
		For y=0 To nap_width
			For x=0 To map_height
				Delete mapinfo(l,x,y)
			Next
		Next
	Next
	FreeFont font1
	FreeFont font2
	FreeFont font3
End Function

Function flush_objects()
	For a.screen_object=Each screen_object
		If a <> p1 Then 
			Delete a
		End If
	Next 
End Function

Function loadup_player(a.screen_object)
	p1\gfx=a\gfx
	p1\stand_still=a\stand_still
	p1\lives=a\lives
	p1\score=a\score
	p1\frame=a\frame
	p1\tpe=a\tpe
	p1\x=a\x
	p1\y=a\y
	p1\spdx=4;a\spdx
	p1\falling=a\falling
	p1\jumping=a\jumping
	p1\jumpcnt=a\jumpcnt
	p1\counter=a\counter
	p1\dx=a\dx
	p1\dy=a\dy
	p1\path_number=0
	p1\path_index=1
	p1\Air=1000
	p1\sawjump=0
End Function


;
;	Path control codes
;
;	M	-	move object inc.
;	B	-	bounce path loop
;	L	-	loop to beginning of path
;	P	-	pause until next frame
;
Function run_path(a.screen_object)
	If a\path_number=0 Then Return
	If a\path_direction=0 Then a\path_direction=1
	If a\path_index=0 And a\path_direction<0 Then a\path_direction=1:a\path_index=1
	Select paths(a\path_number,a\path_index)\tpe$
		Case "B"	;change index direction
			a\path_direction=-a\path_direction
			a\path_index=a\path_index+a\path_direction
		Case "L"	;loop to beginning
			a\path_index=1
		Case "M"	;move object
			a\x=a\x+(paths(a\path_number,a\path_index)\dx*a\path_direction)
			a\y=a\y+(paths(a\path_number,a\path_index)\dy*a\path_direction)
			a\path_index=a\path_index+a\path_direction
			If paths(a\path_number,a\path_index)\dx*a\path_direction<0 Then a\gfx=0:a\dx=-1
			If paths(a\path_number,a\path_index)\dx*a\path_direction>0 Then a\gfx=1:a\dx=1
		Case "P"	;pause			
			a\path_index=a\path_index+a\path_direction
	End Select
End Function

;	Check for collisions with objects
Function Check_for_death()
	p1\sawjump=0			; as far as we know not on a seesaw

	If p1\stand_still=0 Then
		image=p1\gfx*2
	Else
		image=p1\gfx*2+p1\frame
	End If
	For a.screen_object=Each screen_object
		If a<>p1 Then						;don`t check against players object
			If a\x>-128 And a\x<s_width+128 Then
				If a\y>-128 And a\y<s_height+128 Then
					Select a\tpe
						Case 17			;Pickup a coin
							If ImagesCollide(coin,a\x,a\y,a\frame,player,p1\x,p1\y,image) And a\hasmoved=0 Then
								p1\score=p1\score+100
								a\hasmoved=20
								coinstocollect=	coinstocollect-1
								If coinstocollect=0 Then			; goal complete just goto exit level
								;	This is just the demo version
								;	So No other levels are included
								;   I NEED more graphics to sort out this game
								;	Some nice shooting things Drawbridges etc...
								End_Demo()
								End If
							End If
						Case 19			;killer fish
							If ImagesCollide(fish,a\x,a\y,2*(a\frame)+a\gfx,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 20			;Scorpion
							If ImagesCollide(bad01,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 21			;Big Bee
							If ImagesCollide(bad02,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 23			;Mobile Eye
							If ImagesCollide(bad03,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 24			;Jumping man
							If ImagesCollide(bad04,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 25			;Dragon
							If ImagesCollide(bad05,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 26			;Big Dragon
							If ImagesCollide(bad06,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 27			;Monkey
							If ImagesCollide(bad07,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 28			;turtle
							If ImagesCollide(bad08,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 100
							image=a\gfx*2+a\frame
							If ImagesCollide(badbul,a\x,a\y,image,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 101
							If ImagesCollide(egg,a\x,a\y,0,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 102
							If ImagesCollide(splat,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								dead=True
							End If
						Case 12			;seesaw
							If ImagesCollide(seesaw,a\x,a\y,a\frame,player,p1\x,p1\y,image) Then
								;if falling onto a seesaw on theright side set it off moving
								If p1\falling<>0 Then
									If p1\x<a\x+64 And a\frame = 4 Then ;on left handside and left is down
										a\frame=3
										a\sawjump=1	;tell engine hit left side
									Else 
										If p1\x>a\x+192 And a\frame = 0 Then ;on righthand side and right is down
											a\frame = 1
											a\sawjump=2 ; tell engine hit right side
										End If
									End If
								End If
								;check if we`re ready to be catapulted
								If p1\x<a\x+64 And a\frame = 0 Then ;on left handside and left is down
									p1\sawjump=1
								Else 
									If p1\x>a\x+192 And a\frame = 4 Then ;on righthand side and right is down
										p1\sawjump=2
									End If
								End If
							End If
					End Select
				End If
			End If
		End If
	Next
End Function

Function Sort_High_Table()
	Sc=Htable(11)\Score
	tSc$=Htable(11)\Name$
	For a=10 To 1 Step -1
		If Sc>Htable(a)\Score Then
			Htable(a+1)\Score=Htable(a)\Score
			Htable(a+1)\Name$=Htable(a)\Name$
			Htable(a)\Name$=tSc$:Htable(a)\Score=Sc
		End If
	Next
	
End Function

Function HighScorePage(sc)
	SetFont font3
	If sc>Htable(10)\Score Then
		Cls
		For r=1 To 200
			Color Rnd(255),Rnd(255),Rnd(255)
			Text s_width/2,40,Upper$("Congratulations"),1,1
			Text s_width/2,90,Upper$("Your score was good enough"),1,1
			Text s_width/2,140,Upper$("for the High Score Table."),1,1
			Flip
		Next
		SetBuffer FrontBuffer()
		Cls
		Locate 0,0
		Print "Please Enter Your Name"
		a$=Input$(a$)
		Htable(11)\name$=Upper$(a$)
		Htable(11)\Score=sc
		Sort_High_Table()
		SetBuffer BackBuffer()
		Cls
		Flip
		Cls
		For r=1 To 180
			For ea=1 To 10
				Color 255,255,255
				If Htable(ea)\Score=sc Then Color Rnd(255),Rnd(255),Rnd(255)
				Text s_width/4,ea*50+100,Htable(ea)\name$,1,1
				Text (s_width/4)*3,ea*50+100,Htable(ea)\Score,1,1
			Next
			Flip
			If KeyDown(57) Then p1\score=0:Return
			If KeyDown(31) Then p1\score=0:Return

		Next
		Cls
	Else
		Color Rnd(255),200,10
		Text s_width/2,40,"High Scores to Date",1,1
		Color 255,255,255

		For ea=1 To 10
			Color 255,255,255
			Text s_width/4,ea*50+100,Htable(ea)\name$,1,1
			Text (s_width/4)*3,ea*50+100,Htable(ea)\Score,1,1
		Next
		p1\score=0
	End If
	p1\Score=0
End Function

Function Screen2()
SetFont font3
	Color Rnd(255),200,10
	Text s_width/2,40,"Bad Guy Line up.",1,1
	Color 255,255,255
	DrawImage player,s_width/4,100-32,3
	Text s_width/2,100,"Player",1,1
	DrawImage Bad01,s_width/4,200-16,3
	Text s_width/2,200,"Dumb Scorpion",1,1
	DrawImage Bad02,s_width/4,300-32,Rnd(1)
	Text s_width/2,300,"Big Bee",1,1
	DrawImage Bad03,s_width/4,400-16,Rnd(1)
	Text s_width/2,400,"Killer Eye",1,1
	DrawImage Bad04,s_width/4,500-16,Rnd(1)
	Text s_width/2,500,"Shooter",1,1

	Text s_width/2,s_height-40,"More Bad guys when I get Time.",1,1
End Function

Function Screen3()
SetFont font1
Text s_width/2,30,"Written by David Bird",1,1
Color Rnd(255),0,10
Text s_width/2,80,"e-mail dave@birdie72.freeserve.co.uk",1,1
Color 255,255,255
Text s_width/2,120,"with suggestions",1,1
SetFont font3
Text s_width/2,170,"Written using the demo version",1,1

Text s_width/2,250,"Of",1,1

hwidth=ImageWidth(blitzlogo)/2
hheight=ImageHeight(blitzlogo)/2
DrawImage blitzlogo,(s_width/2)-hwidth,(s_height/2)-hheight,0

End Function

Function Save_Highs()
	file = WriteFile("Highs.hgh")
		For ex=1 To 10
			WriteString file,Htable(ex)\name$
			WriteInt file,Htable(ex)\Score
		Next
End Function

Function Load_Highs()
	file = ReadFile("Highs.hgh")
		For ex=1 To 10
			Htable(ex)\name$=ReadString(file)
			Htable(ex)\Score=ReadInt(file)
		Next
End Function

Function Screen1()
	DrawImage Gametitle,0,0,0
End Function


.Title
	Delay 500
	Cls:Flip
	Cls:Flip
	tcnt=0
	If p1\Score>0 Then HighScorePage(p1\score)
	lv=1;Rnd(1,20)
	sx=Rnd(0,map_width*32-s_width)
	sy=Rnd(0,map_Height*32-s_height)
	load_map(lv)										;loads all map information for this level
	While Not KeyDown(1)								;ESC -	To Exit Game
		Cls
		tcnt=tcnt+1
		rendermap(lv,sx,sy)
		If (tcnt Mod 140)=0 Then
			sx=Rnd(0,map_width*32-s_width)
			sy=Rnd(0,map_Height*16-s_height)
		End If
		If tcnt<500 Then Screen1()
		If tcnt>500 And tcnt<1000 Then HighScorePage(0)
		If tcnt>1000 And tcnt<1500 Then Screen2()
		If tcnt>1500 And tcnt<2000 Then Screen3()
		If tcnt>2000 Then tcnt=0
		If KeyDown(31) Then Goto main					;S	-	Start Game
		Flip
	Wend

.ext
Save_Highs()
End_demo()
End
Function checkpoint(lev,x,y)			;checks block at x,y return false if solid
	t_mapx=screenx+x:t_mapy=screeny+y
	t_blkx=t_mapx/32:t_blky=t_mapy/32
	
	If t_blkx<0 Or t_blkx>map_width Then Return False
	If t_blky<0 Or t_blky>map_height Then Return False
	blocktype=mapinfo(lev,t_blkx,t_blky)\tpe
	Select blocktype
		Case 1
			Return False
		Case 2
;			Return False
		Case 3
		Case 4
		Case 5
		Case 6
		Case 7
		Case 8
		Case 9
	End Select
	Return True
End Function

Function ret_blk(lev,x,y)
	t_mapx=screenx+x:t_mapy=screeny+y
	t_blkx=t_mapx/32:t_blky=t_mapy/32
	blocktype=mapinfo(lev,t_blkx,t_blky)\tpe
	Return blocktype
End Function

Function checkfall(lev,a.screen_object)
	t_mapx=screenx+a\x:t_mapy=screeny+a\y
	t_blkx=t_mapx/32:t_blky=t_mapy/32
	xoff=t_mapx-(t_blkx*32)
	a\falling=0
	blocktype=mapinfo(lev,t_blkx,t_blky)\tpe
	pointheight=Tileheight(mapinfo(lev,t_blkx,t_blky)\blk,xoff)
	If blocktype=10 Then						;use heightmap
		ymod1=screeny+a\y
		ymod2=((ymod1/32*32)+pointheight)-ymod1
		If ymod2>a\spdx Then
			a\y=a\y+a\spdx
			a\falling=1
			a\jumpcnt=0
			a\jumping=0
		Else
			a\y=a\y+ymod2
			a\falling=0
			a\jumpcnt=0
			a\jumping=0
		End If		
	Else										;check blocktype
		Select blocktype
			Case 1
				a\y=(a\y/32*32)
				Return False
			Case 2
				a\y=(a\y/32*32)
				Return False
			Case 3
			Case 4
			Case 5
			Case 6
				If a\tpe=1 Then					;only player can be killed by death objects
					dead=True
				End If
			Case 7
				spring=True
			Case 8
			Case 9
		End Select
		a\y=a\y+a\spdx
		a\falling=1
		a\jumpcnt=0
		a\jumping=0
	End If
End Function

Function checkobjectfall(lev,a.screen_object)
	t_mapx=screenx+a\x:t_mapy=screeny+a\y
	t_blkx=t_mapx/32:t_blky=t_mapy/32
	xoff=t_mapx-(t_blkx*32)
	a\falling=0
	blocktype=mapinfo(lev,t_blkx,t_blky)\tpe
	pointheight=Tileheight(mapinfo(lev,t_blkx,t_blky)\blk,xoff)
	If blocktype=10 Then						;use heightmap
		ymod1=screeny+a\y
		ymod2=((ymod1/32*32)+pointheight)-ymod1
		If ymod2>8 Then
			a\y=a\y+8
			a\falling=1
			a\jumpcnt=0
			a\jumping=0
			Return True
		Else
			a\y=a\y+ymod2
			a\falling=0
			a\jumpcnt=0
			a\jumping=0
			Return False
		End If		
	Else										;check blocktype
		Select blocktype
			Case 1
				a\y=((screeny+a\y)/32*32-screeny)
				Return False
			Case 2
				a\y=((screeny+a\y)/32*32-screeny)
				Return False
			Case 3
			Case 4
			Case 5
			Case 6
				If a\tpe=1 Then					;only player can be killed by death objects
					dead=True
				End If
			Case 7
				spring=True
			Case 8
			Case 9
		End Select
		a\y=a\y+8
		a\falling=1
		a\jumpcnt=0
		a\jumping=0
		Return True
	End If
End Function


Function End_Demo()
	Cls
	temp=CreateImage(s_width/2,s_height+20,1)
	SetFont font1
	Text s_width/2,60,"Scrolling Platform Game",1,0
	Color 255,0,0
	Text s_width/2,75,"~~~~~~~~~~~~~~~~~~~~~",1,0
	Color 0,0,255
	Text s_width/2,150,"Programmed by David Bird",1,0
	Text s_width/2,180,"Using the Demo Version",1,0
	Text s_width/2,230,"of",1,0

	hwidth=ImageWidth(blitzlogo)/2
	hheight=ImageHeight(blitzlogo)/2
	DrawImage blitzlogo,(s_width/2)-hwidth,(s_height/2)-hheight,0
	
	Color 100,20,255
	Text s_width/2,490,"Thats all the demo has in store",1,0
	Text s_width/2,530,"The full version will have",1,0
	Text s_width/2,560,"many more objects and levels",1,0

	Color 0,255,0
	Text s_width/2,630,"E-Mail me with suggestions.",1,0
	Color 255,255,0
	Text s_width/2,710,"dave@birdie72.freeserve.co.uk",1,0
	
	Color 255,0,0
	Text s_width/2,735,"NO SPAM MAIL",1,0


	GrabImage temp,s_width/4,0
	Cls
	yps=s_height
	FlushKeys
	cnt=0
	While Not KeyDown(1)
		Cls
		If cnt=0 Then
			cnt=10
			img1=img1+1
			If img1=2 Then img1=0
			img2=img2+1
			If img2=3 Then img2=0
		End If			
		cnt=cnt-1
		yps=yps-1
		If yps=-s_height Then yps=s_height
		DrawImage temp,s_width/4,yps
		DrawImage player,s_width/4+40,yps+90,2+img1
		DrawImage bad07,s_width/4*3-40,yps+90,img2*2
		Flip
	Wend
	Exit_game()
	End
End Function