; 3D Function Plotting.  Pointless, but I like it!
;
; Make sure Debug is switched off -- it's _such_ a drag.
;
; yak_the_hairy@hotmail.com
;
; Available for children's parties, birthdays, and bar mitzvahs.  (And 2D graphics work, I suppose. :)

; ****************
; ** INITIALISE **
; ****************

Graphics 640,480									; Usual starting point: Set the graphics mode,
SetBuffer BackBuffer()								; pick a buffer, etc.

Dim S#(900)											; Pre-calculating the Sine and Cosine values
Dim C#(900)											; and stuffing them in arrays can save a bit
For Q = 0 To 900									; of time, especially if you're going to use
	S#(Q) = Sin(Q)									; them a lot.
	C#(Q) = Cos(Q)
Next

ZF = 350											; Sets the "focal length" in the perspective
													; calculations.

; ***************
; ** MAIN LOOP **
; ***************

While Not KeyDown(1)								; Escape!

	V1 = (V1+5) Mod 360								; V1 and V2 are the "frequencies" of the
	V2 = (V2+3) Mod 360								; waveforms.  Change the increments to vary
													; the speed of the wibbling.

	Cls												; Clear the screen before we draw on it!

	For Z = -200 To 200 Step 10						; The X (horizontal) and Z (depth) boundaries
		For X = -200 To 200 Step 10					; of the grid.

			R = Sqr(X*X+Z*Z)						; R is the distance between (X,Z) and (0,0).
			
			F1 = (R+V1) Mod 360						; F1 and F2 are the positions along the waves
			F2 = (R+V2) Mod 360						; generated from V1 and V2.
							
			Y# = S#(F1)								; Some formulae for generating purdy patterns.
;			y# = S#(F1)*C#(F2)						; Uncomment as required.
;			y# = C#(F1)*S#(V2)						; If you're feeling brave, create your own!
;			y# = C#(2*F2)-(C#(F1)*S#(F2))/2			; (Remember, C#() is Cosine and S#() is Sine.
;			y# = S#(F1)*(R/300.0)					; Try to keep the results between -1 and 1.)
;			y# = S#(F1)*((300.0-R)/300)
;			y# = (F1>180)
;			y# = -(F1>180)*((300.0-R)/300)
;			y# = 1-Rnd(2000)/1000.0
;			y# = (S#(F1)*S#(F1)-C#(F1)*S#(F2))/2


			Y = (Y#+1)*60							; Normalise the amplitude (Y value).
			Color Y, 150-Y, 0						; Set the colour according to the amplitude.
			
			ZQ# = ((Z+200.0)/ZF) + 1				; Calculate the draw distance.  Note the "200.0"
													; rather than "200" -- this is because we need
													; a floating-point value for the distance, but
													; the calculation would produce an integer value
													; if all the numbers involved are themselves
													; integers.  (Handy tip! ;)
													
			XP = X/ZQ#								; Calculate the screen X and Y positions of the
			YP = -((Z+Y)/ZQ#)						; point based on its "real world" X, Y, Z co-ords.
			YO = -((Z+60)/ZQ#)						; (YO is the "origin" plane height.)
							
			Plot XP+320, YP+240						; Draw the point!
;			Line XP+320, YO+240, XP+320, YP+240		; Alternative rendering method.  (Fairly slow!)

		Next										; X
	Next											; Z

	Flip											; Switch the visible and non-visible buffers.

Wend