; Shows how to use the SetBuffer() command 
; Almost a 'Worms' type game :]
; Enjoy! btw. NOTE: when land is completely destroyed
; it becomes a parallax starfield, so you really get 2 demos in one :]
; Coded by KrayZ using Blitz Basic v1.15
; entitize@crosswinds.net

Graphics 800,600

SetBuffer BackBuffer()

Global LandBuffer				; this will hold the Land - so we can destroy it piece by piece

Const MaxBombs = 150				; Maximum bombs active - change for total destruction >B]

Type TBomb
	Field bx#, by#, speed#
End Type



CreateBombs()
CreateLand()


; ***********************
; ****** MAIN LOOP ******
; ***********************
While Not(KeyDown(1))
	Cls

	DrawBomb()					; Draw the bombs and destroy the land
	DrawImage LandBuffer,0,0	; Draw the newly destroyed land

	Flip
Wend
End



; ******* LAND *******
Function CreateLand()
	Local ang#=0.0
	
	LandBuffer=CreateImage(GraphicsWidth(),GraphicsHeight())
	SetBuffer ImageBuffer(LandBuffer)

	; Set the colour to draw the land in - Green	
	Color 0,150,0
	
	For x=0 To GraphicsWidth()
		; Just create the land out of a Sine wave
		y=Sin(ang*Pi/180)*70+Rnd(2)+200
		ang=ang+1
		Line x,y,x,GraphicsHeight()-1
	Next
	
	; Set the buffer to the BackBuffer() as we no longer need to deal with 
	; the LandBuffer yet
	SetBuffer BackBuffer()
End Function


; ******* BOMBS *******
Function CreateBombs()
	For ctr=1 To MaxBombs
		bomb.TBomb=New TBomb
		bomb\bx=Rnd(GraphicsWidth())
		bomb\by=-Rnd(100)
		bomb\speed=Rnd(3)
	Next		
End Function

; DRAWBOMB
Function DrawBomb()
	; Set the buffer to the LandBuffer as we want to read from it
	SetBuffer ImageBuffer(LandBuffer) 
	
	For bomb.TBomb=Each TBomb
		; Check colour below.. if it's not black then the bomb has hit land
		; Also check to see if the bomb goes off screen
		If (GetColor(bomb\bx,bomb\by+bomb\speed)<>0) Or (bomb\by>GraphicsHeight()) Then
			; Black - ready for clearing a circle out of the land where the bomb hits
			Color 0,0,0
			; Wipeout the land - the faster the bomb, the bigger the crater
			Oval bomb\bx-((bomb\speed*12)/2),bomb\by-((bomb\speed*12)/2),bomb\speed*12,bomb\speed*12
			; Now set the bomb back to the top of the screen ready for another round
			bomb\bx=Rnd(GraphicsWidth())
			bomb\by=-Rnd(100)
		End If
	Next
	
	; Set the buffer back to the BackBuffer() as we're done with the LandBuffer
	SetBuffer BackBuffer()
	
	; Set the colour back to white ready to draw the bombs
	Color 255,255,255
	For bomb.TBomb=Each TBomb
		Plot bomb\bx,bomb\by
		; Moves the bomb
		bomb\by=bomb\by+bomb\speed
	Next
End Function





